/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.container;

import cd4017be.lib.Content;
import cd4017be.lib.Lib;
import cd4017be.lib.container.ItemContainer;
import cd4017be.lib.container.slot.HidableSlot;
import cd4017be.lib.gui.ModularGui;
import cd4017be.lib.gui.comp.Button;
import cd4017be.lib.gui.comp.GuiFrame;
import cd4017be.lib.network.StateSyncAdv;
import cd4017be.lib.tileentity.Grid;
import java.util.function.IntConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerGrid
extends ItemContainer {
    private final Inventory sideInv = new Inventory(6);
    private Grid cache;
    public static final ResourceLocation TEX = Lib.rl("textures/gui/grid_edit.png");

    public ContainerGrid(int id, PlayerInventory inv, PacketBuffer pkt) {
        this(id, inv, pkt.readUnsignedByte());
    }

    public ContainerGrid(int id, PlayerInventory inv, int slot) {
        super(Content.gRID, id, inv, slot, (Item)Content.grid, StateSyncAdv.of(inv.field_70458_d.field_70170_p.field_72995_K, new Object[0]), 0);
        ((HidableSlot)this.func_75146_a(new HidableSlot((IInventory)inv, slot, 199, 45))).lock();
        this.func_75146_a(new Slot((IInventory)this.sideInv, 0, 199, 63));
        this.func_75146_a(new Slot((IInventory)this.sideInv, 1, 199, 27));
        this.func_75146_a(new Slot((IInventory)this.sideInv, 2, 217, 54));
        this.func_75146_a(new Slot((IInventory)this.sideInv, 3, 181, 36));
        this.func_75146_a(new Slot((IInventory)this.sideInv, 4, 217, 36));
        this.func_75146_a(new Slot((IInventory)this.sideInv, 5, 181, 54));
        this.addPlayerInventory(8, 16, false);
    }

    public void func_75134_a(PlayerEntity player) {
        this.func_193327_a(player, player.field_70170_p, (IInventory)this.sideInv);
        super.func_75134_a(player);
    }

    private Grid grid() {
        if (this.cache == null) {
            this.cache = (Grid)Content.grid.tileEntity(this.getStack());
        }
        return this.cache;
    }

    private Grid grid(ItemStack stack) {
        if (stack.func_77973_b() == Content.grid) {
            return (Grid)Content.grid.tileEntity(stack);
        }
        return null;
    }

    private ItemStack set(int slot, Grid grid, int n) {
        ItemStack stack = grid.getItem();
        if (!stack.func_190926_b()) {
            stack.func_190920_e(n);
        }
        ((Slot)this.field_75151_b.get(slot)).func_75215_d(stack);
        return stack;
    }

    @Override
    public ItemStack func_184996_a(int s, int b, ClickType m, PlayerEntity player) {
        if (s != 0) {
            return super.func_184996_a(s, b, m, player);
        }
        if (player.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.getStack();
        ItemStack stack1 = player.field_71071_by.func_70445_o();
        int n = stack.func_190916_E();
        if (stack1.func_190916_E() < n || stack1.func_77973_b() != stack.func_77973_b()) {
            return ItemStack.field_190927_a;
        }
        Grid grid = this.grid();
        if (!grid.merge(this.grid(stack1))) {
            return ItemStack.field_190927_a;
        }
        stack1.func_190918_g(n);
        return this.set(s, grid, n);
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        int n;
        byte cmd = pkt.readByte();
        int i = cmd & 0x7F;
        int n2 = n = cmd < 0 ? 2 : 1;
        if (i < 6) {
            Direction d = Direction.func_82600_a((int)i);
            ItemStack stack1 = this.getStack();
            int m = stack1.func_190916_E();
            ItemStack stack2 = this.sideInv.func_70301_a(i);
            if (!stack2.func_190926_b() && stack2.func_190916_E() != m) {
                return;
            }
            ItemStack stack0 = this.sideInv.func_70301_a(i ^ 1);
            if (!stack0.func_190926_b() && stack0.func_190916_E() != m) {
                return;
            }
            Grid gridX = this.grid(stack2);
            if (gridX == null) {
                if (!stack2.func_190926_b()) {
                    return;
                }
                gridX = (Grid)Content.GRID.tileType.func_200968_a();
            } else if (!gridX.shift(d, n, null)) {
                return;
            }
            Grid grid = this.grid();
            boolean done = grid.shift(d, n, gridX);
            this.set(i + 1, gridX, m);
            if (!done) {
                return;
            }
            gridX = this.grid(stack0);
            if (gridX != null && gridX.shift(d, n, grid)) {
                this.set((i ^ 1) + 1, gridX, m);
            }
            grid.updateBounds();
            this.set(0, grid, m);
        } else if (i < 8) {
            Grid grid;
            if (i == 7) {
                n = 4 - n;
            }
            if (!(grid = this.grid()).rotate(n)) {
                return;
            }
            this.set(0, grid, this.getStack().func_190916_E());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModularGui<ContainerGrid> setupGui(PlayerInventory inv, ITextComponent name) {
        ModularGui<ContainerGrid> gui = new ModularGui<ContainerGrid>(this, inv, name);
        GuiFrame frame = new GuiFrame(gui, 252, 98, 8).background(TEX, 0, 0).title("gui.cd4017be.grid_edit", 0.9f);
        new Button(frame, 10, 10, 202, 80, 0, null, ContainerGrid.send(gui, 0)).tooltip("gui.cd4017be.shift0");
        new Button(frame, 10, 10, 202, 16, 0, null, ContainerGrid.send(gui, 1)).tooltip("gui.cd4017be.shift1");
        new Button(frame, 10, 10, 234, 67, 0, null, ContainerGrid.send(gui, 2)).tooltip("gui.cd4017be.shift2");
        new Button(frame, 10, 10, 170, 29, 0, null, ContainerGrid.send(gui, 3)).tooltip("gui.cd4017be.shift3");
        new Button(frame, 10, 10, 234, 29, 0, null, ContainerGrid.send(gui, 4)).tooltip("gui.cd4017be.shift4");
        new Button(frame, 10, 10, 170, 67, 0, null, ContainerGrid.send(gui, 5)).tooltip("gui.cd4017be.shift5");
        new Button(frame, 8, 18, 235, 44, 0, null, ContainerGrid.send(gui, 6)).tooltip("gui.cd4017be.rot_right");
        new Button(frame, 8, 18, 170, 44, 0, null, ContainerGrid.send(gui, 7)).tooltip("gui.cd4017be.rot_left");
        gui.slotTooltips.put(0, (Object)"gui.cd4017be.merge");
        return gui.setComps(frame, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static IntConsumer send(ModularGui<?> gui, int i) {
        return b -> gui.sendPkt((byte)(b == 1 ? i | 0xFFFFFF80 : i));
    }
}

