/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.container.slot;

import cd4017be.lib.capability.IFluidHandlerModifiable;
import cd4017be.lib.capability.IMultiFluidHandler;
import cd4017be.lib.container.AdvancedContainer;
import cd4017be.lib.container.slot.IFluidSlot;
import cd4017be.lib.container.slot.ISpecialSlot;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SlotFluidHandler
extends Slot
implements IFluidSlot,
ISpecialSlot {
    private static final IInventory emptyInventory = new Inventory(0);
    private final IFluidHandler fluidHandler;

    public SlotFluidHandler(IFluidHandler fluidHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.fluidHandler = fluidHandler;
    }

    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    public ItemStack func_75211_c() {
        return ItemStack.field_190927_a;
    }

    public void func_75215_d(ItemStack stack) {
        throw new UnsupportedOperationException("Fluid slots don't have an item stack to set!");
    }

    public int func_75219_a() {
        return 0;
    }

    public ItemStack func_75209_a(int amount) {
        return ItemStack.field_190927_a;
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        return false;
    }

    @Override
    public FluidStack getFluid() {
        return this.fluidHandler.getFluidInTank(this.getSlotIndex());
    }

    @Override
    public void putFluid(FluidStack stack) {
        ((IFluidHandlerModifiable)this.fluidHandler).setFluidInTank(this.getSlotIndex(), stack);
    }

    @Override
    public int getCapacity() {
        return this.fluidHandler.getTankCapacity(this.getSlotIndex());
    }

    @Override
    public boolean insertHereOnly(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack onClick(int b, ClickType ct, PlayerEntity player, AdvancedContainer advancedContainer) {
        ItemStack curItem = player.field_71071_by.func_70445_o();
        if (ct == ClickType.CLONE) {
            if (!curItem.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            FluidStack stack = this.getFluid();
            Predicate<FluidStack> filter = f -> stack.isEmpty() ? this.fluidHandler.isFluidValid(this.getSlotIndex(), f) : f.isEmpty() || f.isFluidEqual(stack);
            NonNullList inv = player.field_71071_by.field_70462_a;
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack item = (ItemStack)inv.get(i);
                if (!FluidUtil.getFluidContained((ItemStack)item).filter(filter).isPresent()) continue;
                player.field_71071_by.func_70437_b(item);
                inv.set(i, (Object)curItem);
                break;
            }
            if (player.func_184812_l_() && !stack.isEmpty()) {
                player.field_71071_by.func_70437_b(FluidUtil.getFilledBucket((FluidStack)stack));
            }
        } else if (ct == ClickType.PICKUP || ct == ClickType.PICKUP_ALL || ct == ClickType.QUICK_MOVE) {
            IFluidHandler inv = this.fluidHandler;
            if (inv instanceof IMultiFluidHandler) {
                inv = ((IMultiFluidHandler)inv).accessTank(this.getSlotIndex());
            }
            int limit = ct == ClickType.QUICK_MOVE ? Integer.MAX_VALUE : 1000;
            FluidActionResult r = b == 0 ? FluidUtil.tryEmptyContainerAndStow((ItemStack)curItem, (IFluidHandler)inv, null, (int)limit, (PlayerEntity)player, (boolean)true) : FluidUtil.tryFillContainerAndStow((ItemStack)curItem, (IFluidHandler)inv, null, (int)limit, (PlayerEntity)player, (boolean)true);
            if (r.success) {
                player.field_71071_by.func_70437_b(r.result);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean sim) {
        return stack;
    }

    @Override
    public ItemStack extractItem(int am, boolean sim) {
        return ItemStack.field_190927_a;
    }
}

