/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.gui;

import cd4017be.lib.Lib;
import cd4017be.lib.container.AdvancedContainer;
import cd4017be.lib.container.slot.IFluidSlot;
import cd4017be.lib.container.slot.SlotHolo;
import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.text.TooltipUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.items.ItemHandlerHelper;

@OnlyIn(value=Dist.CLIENT)
public class ModularGui<T extends AdvancedContainer>
extends ContainerScreen<T> {
    public static final ResourceLocation LIB_TEX = Lib.rl("textures/icons.png");
    protected byte drawTitles;
    private Slot lastClickSlot;
    public GuiCompGroup compGroup;
    public final Int2ObjectOpenHashMap<String> slotTooltips = new Int2ObjectOpenHashMap();

    public ModularGui(T container, PlayerInventory inv, ITextComponent name) {
        super(container, inv, name);
        if (((AdvancedContainer)container).hasPlayerInv()) {
            this.drawTitles = (byte)(this.drawTitles | 2);
            Slot slot = container.func_75139_a(((AdvancedContainer)container).playerInvStart());
            this.field_238744_r_ = slot.field_75223_e;
            this.field_238745_s_ = slot.field_75221_f - 13;
        }
    }

    public ModularGui<T> setComps(GuiCompGroup comps, boolean title) {
        this.compGroup = comps;
        if (title) {
            this.drawTitles = (byte)(this.drawTitles | 1);
        }
        return this;
    }

    protected void func_231160_c_() {
        this.field_146999_f = this.compGroup.w;
        this.field_147000_g = this.compGroup.h;
        super.func_231160_c_();
        this.init(this.compGroup, this.field_147003_i, this.field_147009_r);
    }

    public void init(GuiCompGroup comp, int x, int y) {
        comp.init(this.field_230708_k_, this.field_230709_l_, 0.0f, this.field_230712_o_);
        comp.position(x, y);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mx, int my, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mx, my, partialTicks);
        this.func_230459_a_(matrixStack, mx, my);
    }

    protected void func_230459_a_(MatrixStack matrixStack, int x, int y) {
        String s;
        super.func_230459_a_(matrixStack, x, y);
        if (this.field_147006_u instanceof IFluidSlot) {
            IFluidSlot fslot = (IFluidSlot)this.field_147006_u;
            FluidStack stack = fslot.getFluid();
            ArrayList<String> info = new ArrayList<String>();
            info.add(stack.getRawFluid() != Fluids.field_204541_a ? stack.getDisplayName().getString() : TooltipUtil.translate("cd4017be.tankEmpty"));
            info.add(TooltipUtil.format("cd4017be.tankAmount", stack != null ? (double)stack.getAmount() / 1000.0 : 0.0, (double)fslot.getCapacity() / 1000.0));
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, TooltipUtil.convertText(info), (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        } else if (!(this.field_147006_u == null || this.field_147006_u.func_75216_d() && this.field_213127_e.func_70445_o().func_190926_b() || (s = (String)this.slotTooltips.get(this.field_147006_u.field_75222_d)) == null)) {
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, TooltipUtil.convertText(TooltipUtil.translate(s)), (int)x, (int)y, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_);
        }
        this.compGroup.drawOverlay(matrixStack, x, y);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        for (Slot slot : ((AdvancedContainer)this.field_147002_h).field_75151_b) {
            IFluidSlot fslot;
            FluidStack stack;
            if (!(slot instanceof IFluidSlot) || (stack = (fslot = (IFluidSlot)slot).getFluid()) == null) continue;
            float h = (float)stack.getAmount() / (float)fslot.getCapacity();
            h = Float.isNaN(h) || h > 1.0f || h < 0.0f ? 16.0f : (h *= 16.0f);
            this.drawFluid(matrixStack, stack, slot.field_75223_e, (float)(slot.field_75221_f + 16) - h, 16.0f, h);
        }
        ModularGui.color(-1);
    }

    protected void drawFluid(MatrixStack matrixStack, FluidStack stack, float x, float y, float w, float h) {
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        FluidAttributes attr = stack.getFluid().getAttributes();
        TextureAtlasSprite tex = (TextureAtlasSprite)this.field_230706_i_.func_228015_a_(AtlasTexture.field_110575_b).apply(attr.getStillTexture(stack));
        float u0 = tex.func_94209_e();
        float v0 = tex.func_94206_g();
        float u1 = tex.func_94212_f();
        float v1 = tex.func_94210_h();
        ModularGui.color(attr.getColor(stack));
        this.field_230706_i_.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(mat, x, y + h, 0.0f).func_225583_a_(u0, v1).func_181675_d();
        bufferbuilder.func_227888_a_(mat, x + w, y + h, 0.0f).func_225583_a_(u1, v1).func_181675_d();
        bufferbuilder.func_227888_a_(mat, x + w, y, 0.0f).func_225583_a_(u1, v0).func_181675_d();
        bufferbuilder.func_227888_a_(mat, x, y, 0.0f).func_225583_a_(u0, v0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mx, int my) {
        this.compGroup.drawBackground(matrixStack, mx, my, partialTicks);
        if ((this.drawTitles & 1) != 0) {
            this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, (float)(this.field_147003_i + this.field_238742_p_), (float)(this.field_147009_r + this.field_238743_q_), 0x404040);
        }
        if ((this.drawTitles & 2) != 0) {
            this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), (float)(this.field_147003_i + this.field_238744_r_), (float)(this.field_147009_r + this.field_238745_s_), 0x404040);
        }
    }

    public boolean func_231044_a_(double x, double y, int b) {
        return this.compGroup.mouseIn((int)x, (int)y, b, (byte)0) || super.func_231044_a_(x, y, b);
    }

    public boolean func_231045_a_(double x, double y, int b, double dx, double dy) {
        if (this.compGroup.mouseIn((int)x, (int)y, b, (byte)1)) {
            return true;
        }
        Slot slot = this.getSlotUnderMouse();
        ItemStack itemstack = this.field_213127_e.func_70445_o();
        if (slot instanceof SlotHolo && slot != this.lastClickSlot) {
            ItemStack slotstack = slot.func_75211_c();
            if (itemstack.func_190926_b() || slotstack.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)slotstack)) {
                this.func_184098_a(slot, slot.field_75222_d, b, ClickType.PICKUP);
            }
            this.lastClickSlot = slot;
            return true;
        }
        this.lastClickSlot = slot;
        return super.func_231045_a_(x, y, b, dx, dy);
    }

    public boolean func_231048_c_(double x, double y, int b) {
        this.lastClickSlot = null;
        return this.compGroup.mouseIn((int)x, (int)y, b, (byte)2) || super.func_231048_c_(x, y, b);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return this.compGroup.keyIn('\u0000', keyCode, (byte)0) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char c, int modifiers) {
        return this.compGroup.keyIn(c, -1, (byte)0) || super.func_231042_a_(c, modifiers);
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        return this.compGroup.mouseIn((int)x, (int)y, (int)(Double.doubleToRawLongBits(delta) >> 63) | 1, (byte)3) || super.func_231043_a_(x, y, delta);
    }

    public void drawFormatInfo(MatrixStack stack, int x, int y, String key, Object ... args) {
        this.renderWrappedToolTip(stack, TooltipUtil.convertText(TooltipUtil.format(key, args)), x, y, this.field_230712_o_);
    }

    public void drawLocString(MatrixStack stack, int x, int y, int h, int c, String s, Object ... args) {
        String[] text;
        for (String l : text = TooltipUtil.format(s, args).split("\n")) {
            this.field_230712_o_.func_238421_b_(stack, l, (float)x, (float)y, c);
            y += h;
        }
    }

    public void drawStringCentered(MatrixStack stack, String s, int x, int y, int c) {
        this.field_230712_o_.func_238421_b_(stack, s, (float)(x - this.field_230712_o_.func_78256_a(s) / 2), (float)y, c);
    }

    public void drawSideConfig(MatrixStack stack, Direction side, int type) {
    }

    protected void renderBlock(MatrixStack stack, IWorldReader world, BlockPos pos, BufferBuilder t) {
    }

    public void func_146982_a(ItemStack stack, int x, int y, String altText) {
        this.field_230707_j_.field_77023_b = 200.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(stack, x, y);
        this.field_230707_j_.func_180453_a(font, stack, x, y, altText);
        this.field_230707_j_.field_77023_b = 0.0f;
    }

    public void sendChat(String msg) {
        this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(msg), null);
    }

    public static void color(int c) {
        GlStateManager.func_227740_m_();
        GlStateManager.func_227702_d_((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)((float)(c >> 8 & 0xFF) / 255.0f), (float)((float)(c & 0xFF) / 255.0f), (float)((float)(c >> 24 & 0xFF) / 255.0f));
    }

    public void sendCommand(int c) {
        PacketBuffer buff = GuiNetworkHandler.preparePacket(this.field_147002_h);
        buff.writeByte(c);
        GuiNetworkHandler.GNH_INSTANCE.sendToServer(buff);
    }

    public void sendPkt(Object ... args) {
        PacketBuffer buff = GuiNetworkHandler.preparePacket(this.field_147002_h);
        for (Object arg : args) {
            if (arg instanceof Byte) {
                buff.writeByte((int)((Byte)arg).byteValue());
                continue;
            }
            if (arg instanceof Short) {
                buff.writeShort((int)((Short)arg).shortValue());
                continue;
            }
            if (arg instanceof Integer) {
                buff.writeInt(((Integer)arg).intValue());
                continue;
            }
            if (arg instanceof Long) {
                buff.writeLong(((Long)arg).longValue());
                continue;
            }
            if (arg instanceof Float) {
                buff.writeFloat(((Float)arg).floatValue());
                continue;
            }
            if (arg instanceof Double) {
                buff.writeDouble(((Double)arg).doubleValue());
                continue;
            }
            if (arg instanceof String) {
                buff.func_180714_a((String)arg);
                continue;
            }
            throw new IllegalArgumentException();
        }
        GuiNetworkHandler.GNH_INSTANCE.sendToServer(buff);
    }
}

