/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.gui.comp;

import cd4017be.lib.gui.comp.GuiCompBase;
import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.text.TooltipUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;

public class Button
extends GuiCompBase<GuiCompGroup> {
    protected final IntSupplier get;
    private final IntConsumer set;
    public final int states;
    public int tx = 0;
    public int ty = Integer.MIN_VALUE;
    public String tooltip;
    public static final byte B_SCROLL_UP = -1;
    public static final byte B_SCROLL_DOWN = -3;

    public Button(GuiCompGroup parent, int w, int h, int x, int y, int states, @Nullable IntSupplier get, @Nullable IntConsumer set) {
        super(parent, w, h, x, y);
        this.states = states;
        this.get = get;
        this.set = set;
    }

    public Button texture(int tx, int ty) {
        this.tx = tx;
        this.ty = ty;
        return this;
    }

    public Button tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    @Override
    public void drawOverlay(MatrixStack stack, int mx, int my) {
        if (this.tooltip == null) {
            return;
        }
        String s = this.tooltip;
        if (this.get != null && s.endsWith("#")) {
            s = s.substring(0, s.length() - 1) + this.get.getAsInt();
        }
        this.parent.drawTooltip(stack, TooltipUtil.translate(s), mx, my);
    }

    @Override
    public void drawBackground(MatrixStack stack, int mx, int my, float t) {
        if (this.ty == Integer.MIN_VALUE) {
            return;
        }
        int s = this.get == null ? 0 : this.get.getAsInt();
        this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty + s * this.h, this.w, this.h);
    }

    @Override
    public boolean mouseIn(int x, int y, int b, byte d) {
        if (this.set == null || d == 1 || d == 2) {
            return false;
        }
        if (this.states <= 0 || this.get == null) {
            this.set.accept(d == 3 ? b - 2 : b);
        } else {
            if (d != 3) {
                b = b == 0 ? 1 : -1;
            }
            this.set.accept(Math.floorMod(b + this.get.getAsInt(), this.states));
        }
        return true;
    }
}

