/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.gui.comp;

import cd4017be.lib.gui.comp.IGuiComp;
import cd4017be.lib.text.TooltipUtil;
import cd4017be.lib.util.IndexedSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuiCompGroup
extends IndexedSet<IGuiComp>
implements IGuiComp {
    public final GuiCompGroup parent;
    public final int w;
    public final int h;
    protected int x = 0;
    protected int y = 0;
    protected int focus = -1;
    protected boolean enabled = true;
    protected boolean inheritRender = false;
    private int idx = -1;
    public int screenWidth;
    public int screenHeight;
    public int texW;
    public int texH;
    public float zLevel;
    public FontRenderer fontRenderer;
    public Tessellator tessellator;
    public ResourceLocation mainTex;
    protected boolean bound;
    protected boolean drawing;

    public GuiCompGroup(@Nullable GuiCompGroup parent, int w, int h, int comps) {
        super((IndexedSet.IndexedElement[])new IGuiComp[comps]);
        this.parent = parent;
        this.w = w;
        this.h = h;
        if (parent != null) {
            parent.add(this);
        }
    }

    public GuiCompGroup inheritRender() {
        this.inheritRender = true;
        this.texture(this.parent.mainTex, this.parent.texW, this.parent.texH);
        return this;
    }

    public void init(int sw, int sh, float z, FontRenderer fr) {
        this.screenWidth = sw;
        this.screenHeight = sh;
        this.zLevel = z;
        this.fontRenderer = fr;
        for (int i = 0; i < this.count; ++i) {
            IGuiComp c = ((IGuiComp[])this.array)[i];
            if (!(c instanceof GuiCompGroup)) continue;
            ((GuiCompGroup)c).init(sw, sh, z, fr);
        }
    }

    public void texture(ResourceLocation tex, int w, int h) {
        this.mainTex = tex;
        this.texW = w;
        this.texH = h;
    }

    @Override
    public void setIdx(int idx) {
        this.idx = idx;
    }

    @Override
    public int getIdx() {
        return this.idx;
    }

    @Override
    public GuiCompGroup getParent() {
        return this.parent;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public void position(int px, int py) {
        if (px != this.x || py != this.y) {
            this.move(px - this.x, py - this.y);
        }
    }

    @Override
    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        for (int i = 0; i < this.count; ++i) {
            ((IGuiComp[])this.array)[i].move(dx, dy);
        }
    }

    @Override
    public boolean add(IGuiComp e) {
        if (!super.add(e)) {
            return false;
        }
        if (this.x != 0 || this.y != 0) {
            e.move(this.x, this.y);
        }
        return true;
    }

    @Override
    public boolean isInside(int mx, int my) {
        return mx >= this.x && mx < this.x + this.w && my >= this.y && my < this.y + this.h;
    }

    @Override
    public void drawOverlay(MatrixStack stack, int mx, int my) {
        for (int i = this.count - 1; i >= 0; --i) {
            IGuiComp c = ((IGuiComp[])this.array)[i];
            if (!c.enabled() || !c.isInside(mx, my)) continue;
            c.drawOverlay(stack, mx, my);
            if (!(c instanceof GuiCompGroup)) continue;
            return;
        }
    }

    @Override
    public void drawBackground(MatrixStack stack, int mx, int my, float t) {
        if (!this.inheritRender) {
            if (this.parent != null) {
                this.parent.bound = false;
            }
            this.bound = false;
        }
        for (int i = 0; i < this.count; ++i) {
            IGuiComp c = ((IGuiComp[])this.array)[i];
            if (!c.enabled()) continue;
            c.drawBackground(stack, mx, my, t);
        }
        this.drawNow();
    }

    @Override
    public boolean keyIn(char c, int k, byte d) {
        return this.focus >= 0 && this.focus < this.count && ((IGuiComp[])this.array)[this.focus].keyIn(c, k, d);
    }

    @Override
    public boolean mouseIn(int mx, int my, int b, byte d) {
        if (d == 0) {
            for (int i = this.count - 1; i >= 0; --i) {
                IGuiComp c = ((IGuiComp[])this.array)[i];
                if (!c.enabled() || !c.isInside(mx, my)) continue;
                if (c.getIdx() != this.focus) {
                    this.setFocus(c);
                }
                if (!c.mouseIn(mx, my, b, d)) continue;
                return true;
            }
            if (this.focus >= 0 && this.focus < this.count && !((IGuiComp[])this.array)[this.focus].isInside(mx, my)) {
                this.setFocus(null);
            }
        } else if (d == 3) {
            for (int i = this.count - 1; i >= 0; --i) {
                IGuiComp c = ((IGuiComp[])this.array)[i];
                if (!c.enabled() || !c.isInside(mx, my) || !c.mouseIn(mx, my, b, d)) continue;
                return true;
            }
        } else {
            return this.focus >= 0 && this.focus < this.count && ((IGuiComp[])this.array)[this.focus].mouseIn(mx, my, b, d);
        }
        return false;
    }

    @Override
    public void unfocus() {
        this.setFocus(null);
    }

    @Override
    public boolean focus() {
        return true;
    }

    public void setFocus(IGuiComp c) {
        if (this.focus >= 0 && this.focus < this.count) {
            ((IGuiComp[])this.array)[this.focus].unfocus();
        }
        this.focus = this.contains(c) && c.focus() ? c.getIdx() : -1;
    }

    public void focusNext(Class<? extends IGuiComp> type) {
        for (int i = 1; i < this.count; ++i) {
            IGuiComp c = ((IGuiComp[])this.array)[this.focus + i % this.count];
            if (!type.isInstance(c)) continue;
            this.setFocus(c);
            return;
        }
    }

    public void focusPrev(Class<? extends IGuiComp> type) {
        for (int i = this.count - 1; i > 0; --i) {
            IGuiComp c = ((IGuiComp[])this.array)[this.focus + i % this.count];
            if (!type.isInstance(c)) continue;
            this.setFocus(c);
            return;
        }
    }

    public void bindTexture(ResourceLocation tex) {
        if (this.inheritRender) {
            this.parent.bindTexture(tex);
        }
        if (tex != this.mainTex) {
            this.bound = false;
        } else {
            if (this.bound) {
                return;
            }
            this.bound = true;
        }
        if (tex != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
        }
    }

    public BufferBuilder getDraw() {
        if (this.inheritRender) {
            BufferBuilder b = this.parent.getDraw();
            this.tessellator = this.parent.tessellator;
            return b;
        }
        if (this.tessellator == null) {
            this.tessellator = new Tessellator(1280);
        }
        BufferBuilder b = this.tessellator.func_178180_c();
        if (!this.drawing) {
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.drawing = true;
        }
        return b;
    }

    public void drawNow() {
        if (this.inheritRender) {
            this.parent.drawNow();
        } else if (this.drawing) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_227740_m_();
            this.bindTexture(this.mainTex);
            this.tessellator.func_78381_a();
            this.drawing = false;
        }
    }

    public void drawRect(MatrixStack stack, int x, int y, int tx, int ty, int w, int h) {
        Matrix4f mat = stack.func_227866_c_().func_227870_a_();
        BufferBuilder b = this.getDraw();
        int X = x + w;
        int Y = y + h;
        float u = (float)tx / (float)this.texW;
        float U = (float)(tx + w) / (float)this.texW;
        float v = (float)ty / (float)this.texH;
        float V = (float)(ty + h) / (float)this.texH;
        float z = this.zLevel;
        b.func_227888_a_(mat, (float)x, (float)Y, z).func_225583_a_(u, V).func_181675_d();
        b.func_227888_a_(mat, (float)X, (float)Y, z).func_225583_a_(U, V).func_181675_d();
        b.func_227888_a_(mat, (float)X, (float)y, z).func_225583_a_(U, v).func_181675_d();
        b.func_227888_a_(mat, (float)x, (float)y, z).func_225583_a_(u, v).func_181675_d();
    }

    public void drawTooltip(MatrixStack stack, List<String> text, int mx, int my) {
        GuiUtils.drawHoveringText((MatrixStack)stack, TooltipUtil.convertText(text), (int)mx, (int)my, (int)this.screenWidth, (int)this.screenHeight, (int)-1, (FontRenderer)this.fontRenderer);
    }

    public void drawTooltip(MatrixStack stack, String text, int mx, int my) {
        GuiUtils.drawHoveringText((MatrixStack)stack, TooltipUtil.convertText(text), (int)mx, (int)my, (int)this.screenWidth, (int)this.screenHeight, (int)-1, (FontRenderer)this.fontRenderer);
    }
}

