/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.gui.comp;

import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.gui.comp.GuiFrame;
import cd4017be.lib.gui.comp.Tooltip;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;

public class Progressbar
extends Tooltip {
    private final DoubleSupplier get;
    public final byte type;
    public final int tx;
    public final int ty;
    public final double f0;
    public final double scale;
    public static final byte H_FILL_R = -2;
    public static final byte V_FILL_R = -1;
    public static final byte H_FILL = 0;
    public static final byte V_FILL = 1;
    public static final byte H_SLIDE = 2;
    public static final byte V_SLIDE = 3;
    public static final byte PIXELS = 4;

    public Progressbar(GuiCompGroup parent, int w, int h, int x, int y, int tx, int ty, byte type, @Nonnull DoubleSupplier get, double min, double max) {
        super(parent, w, h, x, y, null, () -> new Object[]{get.getAsDouble(), min, max});
        this.type = type;
        this.tx = tx;
        this.ty = ty;
        this.get = get;
        this.f0 = min;
        switch (type) {
            case -2: 
            case 0: 
            case 2: {
                this.scale = (double)w / (max - min);
                break;
            }
            case -1: 
            case 1: 
            case 3: {
                this.scale = (double)h / (max - min);
                break;
            }
            default: {
                this.scale = (double)(w * h) / (max - min);
            }
        }
    }

    public Progressbar(GuiFrame parent, int w, int h, int x, int y, int tx, int ty, byte type, @Nonnull DoubleSupplier get) {
        this(parent, w, h, x, y, tx, ty, type, get, 0.0, 1.0);
    }

    @Override
    public void drawBackground(MatrixStack stack, int mx, int my, float t) {
        double f = this.scale * (this.get.getAsDouble() - this.f0);
        if (!(f > 0.0)) {
            return;
        }
        int n = (int)f;
        boolean rev = this.scale < 0.0;
        switch (this.type) {
            case -2: {
                if (n >= this.w) break;
                if (rev) {
                    this.parent.drawRect(stack, this.x + this.w - n, this.y, this.tx, this.ty, n, this.h);
                } else {
                    this.parent.drawRect(stack, this.x, this.y, this.tx + this.w - n, this.ty, n, this.h);
                }
                return;
            }
            case 0: {
                if (n >= this.w) break;
                if (rev) {
                    this.parent.drawRect(stack, this.x + this.w - n, this.y, this.tx + this.w - n, this.ty, n, this.h);
                } else {
                    this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty, n, this.h);
                }
                return;
            }
            case -1: {
                if (n >= this.h) break;
                if (rev) {
                    this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty + this.h - n, this.w, n);
                } else {
                    this.parent.drawRect(stack, this.x, this.y + this.h - n, this.tx, this.ty, this.w, n);
                }
                return;
            }
            case 1: {
                if (n >= this.h) break;
                if (rev) {
                    this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty, this.w, n);
                } else {
                    this.parent.drawRect(stack, this.x, this.y + this.h - n, this.tx, this.ty + this.h - n, this.w, n);
                }
                return;
            }
            case 2: {
                this.parent.drawRect(stack, this.x, this.y, this.tx + this.w - n, this.ty, this.w, this.h);
                return;
            }
            case 3: {
                this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty + n, this.w, this.h);
                return;
            }
            case 4: {
                int m = n / this.h;
                n %= this.h;
                if (m >= this.w) break;
                if (rev) {
                    this.parent.drawRect(stack, this.x + this.w - m, this.y, this.tx + this.w - m, this.ty, m, this.h);
                    int dx1 = this.w - m - 1;
                    int dy1 = this.h - n;
                    this.parent.drawRect(stack, this.x + dx1, this.y + dy1, this.tx + dx1, this.ty + dy1, 1, n);
                } else {
                    this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty, m, this.h);
                    this.parent.drawRect(stack, this.x + m, this.y, this.tx + m, this.ty, 1, n);
                }
                return;
            }
        }
        this.parent.drawRect(stack, this.x, this.y, this.tx, this.ty, this.w, this.h);
    }
}

