/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.gui.comp;

import cd4017be.lib.gui.comp.Button;
import cd4017be.lib.gui.comp.FormatText;
import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.gui.comp.Tooltip;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;

public class Spinner
extends GuiCompGroup {
    private final DoubleSupplier get;
    private final DoubleConsumer set;
    public final double min;
    public final double max;
    public double clickScale = 8.0;

    public Spinner(GuiCompGroup parent, int w, int h, int x, int y, boolean hor, String format, DoubleSupplier get, DoubleConsumer set, double min, double max, double ... steps) {
        super(parent, w, h, 2 * steps.length + 2);
        this.inheritRender();
        this.move(x, y);
        this.get = get;
        this.set = set;
        this.min = min;
        this.max = max;
        int l = steps.length;
        if (hor) {
            int i = 0;
            for (double d : steps) {
                new Button(this, 5, h, i * 5, 0, 0, null, b -> this.click(b, -d));
                new Button(this, 5, h, w - ++i * 5, 0, 0, null, b -> this.click(b, d));
            }
            new FormatText(this, w - l * 10, h, l * 5, 0, format, this::formatInfo);
        } else {
            int i = 0;
            for (double d : steps) {
                new Button(this, w / l, 5, i * w / l, 0, 0, null, b -> this.click(b, d));
                ++i;
                new Button(this, w / l, 5, i * w / l, h - 5, 0, null, b -> this.click(b, -d));
            }
            new FormatText(this, w, h - 10, 0, 5, format, this::formatInfo);
        }
    }

    public Spinner tooltip(String tooltip) {
        new Tooltip(this, this.w, this.h, 0, 0, tooltip, this::formatInfo);
        return this;
    }

    public Spinner clickScale(double scale) {
        this.clickScale = scale;
        return this;
    }

    private Object[] formatInfo() {
        return new Object[]{this.get.getAsDouble(), this.min, this.max};
    }

    private void click(int b, double step) {
        if (b == -3) {
            step = -step;
        } else if (b != -1) {
            if (b != 0) {
                step *= this.clickScale;
            }
            if (b == 2) {
                step *= this.clickScale;
            }
        }
        double f = this.get.getAsDouble() + step;
        this.set.accept(f < this.min ? this.min : (f > this.max ? this.max : f));
    }
}

