/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.gui.comp;

import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.gui.comp.Tooltip;
import cd4017be.lib.text.TooltipUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TextField
extends Tooltip {
    private final Supplier<String> get;
    private final Consumer<String> set;
    public final int maxL;
    public int tc = -12566464;
    public int cc = -8388608;
    public String text = "";
    public int cur = 0;
    public boolean allowFormat = false;
    public boolean multiline = false;

    public TextField(GuiCompGroup parent, int w, int h, int x, int y, int max, @Nonnull Supplier<String> get, @Nonnull Consumer<String> set) {
        super(parent, w, h, x, y, null, null);
        this.maxL = max;
        this.get = get;
        this.set = set;
    }

    public TextField color(int text, int cursor) {
        this.tc = text;
        this.cc = cursor;
        return this;
    }

    public TextField allowFormat() {
        this.allowFormat = true;
        return this;
    }

    public TextField multiline() {
        this.multiline = true;
        return this;
    }

    @Override
    public void drawBackground(MatrixStack stack, int mx, int my, float ft) {
        String[] stringArray;
        this.parent.bindTexture(null);
        FontRenderer fr = this.parent.fontRenderer;
        boolean focused = this.focused();
        if (!focused) {
            this.text = this.get.get();
            if (this.text == null) {
                this.text = "";
            }
        }
        if (this.multiline) {
            stringArray = this.text.split("\n", -1);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.text;
        }
        String[] lines = stringArray;
        int l1 = lines.length;
        fr.getClass();
        int ln = Math.min(Math.max(this.h / 9, 1), l1);
        fr.getClass();
        int y = this.y + (this.h - 9 * ln >> 1) + 1;
        if (this.focused()) {
            String t;
            if (this.cur > this.text.length()) {
                this.cur = this.text.length();
            }
            int row = 0;
            int col = this.cur;
            int l0 = 0;
            int ofs = 0;
            if (this.multiline) {
                String line;
                int l;
                String[] stringArray3 = lines;
                int n = stringArray3.length;
                for (int i = 0; i < n && col > (l = (line = stringArray3[i]).length()); ++i) {
                    col -= l + 1;
                    ++row;
                }
                t = lines[row];
                if (l1 > ln) {
                    if (l1 - row <= ln / 2) {
                        l0 = l1 - ln;
                    } else if (row > ln / 2) {
                        l0 = row - ln / 2;
                    }
                }
            } else {
                t = this.text;
            }
            int l = fr.func_78256_a(t);
            int k = fr.func_78256_a(t.substring(0, col));
            if (l > this.w) {
                if (l - k < this.w / 2) {
                    ofs = l - this.w;
                } else if (k > this.w / 2) {
                    ofs = k - this.w / 2;
                }
            }
            fr.getClass();
            int y1 = y + 9 * (row - l0);
            GuiUtils.drawGradientRect((Matrix4f)stack.func_227866_c_().func_227870_a_(), (int)((int)this.parent.zLevel), (int)((k += this.x - ofs) - 1), (int)y1, (int)k, (int)(y1 + 7), (int)this.cc, (int)this.cc);
            int i = 0;
            while (i < ln) {
                t = fr.func_238412_a_(lines[i + l0], this.w + ofs);
                int x = this.x;
                if (ofs > 0) {
                    String t0 = t;
                    int w = fr.func_78256_a(t) - ofs;
                    t = w <= 0 ? "" : fr.func_238413_a_(t, w, true);
                    x += fr.func_78256_a(t0.substring(0, t0.length() - t.length())) - ofs;
                }
                fr.func_238421_b_(stack, t, (float)x, (float)y, this.tc);
                ++i;
                fr.getClass();
                y += 9;
            }
        } else {
            int i = 0;
            while (i < ln) {
                fr.func_238421_b_(stack, fr.func_238412_a_(lines[i], this.w), (float)this.x, (float)y, this.tc);
                ++i;
                fr.getClass();
                y += 9;
            }
        }
    }

    @Override
    public boolean keyIn(char c, int k, byte d) {
        block23: {
            try {
                boolean shift = Screen.func_231173_s_();
                boolean ctr = Screen.func_231172_r_() && !shift && !Screen.func_231174_t_();
                switch (k) {
                    case 263: {
                        if (this.cur <= 0) break;
                        --this.cur;
                        break;
                    }
                    case 262: {
                        if (this.cur >= this.text.length()) break;
                        ++this.cur;
                        break;
                    }
                    case 261: {
                        if (this.cur >= this.text.length()) break;
                        this.text = this.text.substring(0, this.cur).concat(this.text.substring(this.cur + 1));
                        break;
                    }
                    case 259: {
                        if (this.cur <= 0) break;
                        --this.cur;
                        this.text = this.text.substring(0, this.cur).concat(this.text.substring(this.cur + 1));
                        break;
                    }
                    case 265: {
                        if (this.multiline) {
                            this.cur = Math.max(this.text.lastIndexOf(10, this.cur - 1), 0);
                            break;
                        }
                        this.parent.focusNext(TextField.class);
                        break;
                    }
                    case 264: {
                        if (this.multiline) {
                            this.cur = this.text.indexOf(10, this.cur + 1);
                            if (this.cur >= 0) break;
                            this.cur = this.text.length();
                            break;
                        }
                        this.parent.focusPrev(TextField.class);
                        break;
                    }
                    case 257: {
                        if (!this.multiline || !shift) {
                            this.parent.setFocus(null);
                            break;
                        }
                        c = (char)10;
                    }
                    case 67: {
                        if (ctr) {
                            TooltipUtil.setClipboardString(this.text);
                            break;
                        }
                    }
                    case 86: {
                        if (ctr) {
                            String s = TooltipUtil.getClipboardString();
                            this.text = this.text.substring(0, this.cur).concat(s).concat(this.text.substring(this.cur, this.text.length()));
                            this.cur += s.length();
                            if (this.text.length() <= this.maxL) break;
                            this.text = this.text.substring(0, this.maxL);
                            this.cur = this.maxL;
                            break;
                        }
                    }
                    case 68: {
                        if (ctr) {
                            this.text = "";
                            break;
                        }
                    }
                    case -1: {
                        if (c == '\u0000' || this.cur >= this.maxL || !this.allowFormat && c == '\u00a7') {
                            return false;
                        }
                        this.text = this.text.substring(0, this.cur).concat("" + c).concat(this.text.substring(this.cur, Math.min(this.text.length(), this.maxL - 1)));
                        ++this.cur;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (this.cur < 0) {
                    this.cur = 0;
                }
                if (this.cur <= this.text.length()) break block23;
                this.cur = this.text.length();
            }
        }
        return true;
    }

    @Override
    public void unfocus() {
        this.set.accept(this.text);
    }

    @Override
    public boolean focus() {
        this.text = this.get.get();
        if (this.text == null) {
            this.text = "";
        }
        this.cur = this.text.length();
        return true;
    }
}

