/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.item;

import cd4017be.lib.text.TooltipUtil;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

public class DocumentedItem
extends Item {
    public static final TranslationTextComponent EXT_TOOLTIP_HINT = new TranslationTextComponent("cd4017be_lib.ext");
    private Supplier<Object[]> tooltipArgs;
    protected ItemGroup extraTab;

    public DocumentedItem(Item.Properties p) {
        super(p);
    }

    public DocumentedItem tooltipArgs(Supplier<Object[]> tooltipArgs) {
        this.tooltipArgs = tooltipArgs;
        return this;
    }

    public DocumentedItem tooltipArgs(ForgeConfigSpec.ConfigValue<?> ... tooltipArgs) {
        return this.tooltipArgs(new ConfigArgs(tooltipArgs));
    }

    public DocumentedItem tab(ItemGroup extraTab) {
        this.extraTab = extraTab;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        DocumentedItem.addInformation(this.func_77658_a(), this.tooltipArgs, tooltip);
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return TooltipUtil.cTranslate(this.func_77667_c(stack));
    }

    public static void addInformation(String key, Supplier<Object[]> tooltipArgs, List<ITextComponent> tooltip) {
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
        String key1 = key + ".tip";
        if (TooltipUtil.hasTranslation(key1)) {
            if (TooltipUtil.showShiftHint()) {
                for (String s : TooltipUtil.translate(key1).split("\n")) {
                    tooltip.add((ITextComponent)TooltipUtil.convert(s).func_230530_a_(style));
                }
            } else {
                tooltip.add((ITextComponent)TooltipUtil.TOOLTIP_HINT);
            }
        }
        if (TooltipUtil.hasTranslation(key1 = key + ".ext")) {
            if (TooltipUtil.showAltHint()) {
                for (String s : TooltipUtil.format(key1, tooltipArgs == null ? new Object[]{} : tooltipArgs.get()).split("\n")) {
                    tooltip.add((ITextComponent)TooltipUtil.convert(s).func_230530_a_(style));
                }
            } else {
                tooltip.add((ITextComponent)EXT_TOOLTIP_HINT);
            }
        }
    }

    public Collection<ItemGroup> getCreativeTabs() {
        if (this.extraTab == null) {
            return super.getCreativeTabs();
        }
        return ImmutableList.of((Object)this.field_77701_a, (Object)this.extraTab);
    }

    public static class ConfigArgs
    implements Supplier<Object[]> {
        private final ForgeConfigSpec.ConfigValue<?>[] cfg;

        public ConfigArgs(ForgeConfigSpec.ConfigValue<?> ... cfg) {
            this.cfg = cfg;
        }

        @Override
        public Object[] get() {
            Object[] args = new Object[this.cfg.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.cfg[i].get();
            }
            return args;
        }
    }
}

