/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.item;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.lib.item.GridItem;
import cd4017be.lib.part.MicroBlock;
import cd4017be.lib.render.MicroBlockFace;
import cd4017be.lib.render.model.IModelDataItem;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.render.model.TileEntityModel;
import cd4017be.lib.text.TooltipUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;

public class MicroBlockItem
extends GridItem
implements IModelDataItem {
    public MicroBlockItem(Item.Properties p) {
        super(p);
    }

    @Override
    public GridPart createPart() {
        return new MicroBlock();
    }

    private ItemStack of(Block block) {
        return this.wrap(new ItemStack((IItemProvider)block), block.func_176223_P(), 1);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)this.of(Blocks.field_150348_b));
            items.add((Object)this.of(Blocks.field_196662_n));
            items.add((Object)this.of(Blocks.field_150451_bX));
        }
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        ItemStack cont = ItemStack.func_199557_a((CompoundNBT)stack.func_196082_o());
        return TooltipUtil.cFormat(this.func_77658_a(), cont.func_200301_q().getString());
    }

    @Override
    public ActionResultType onInteract(IGridHost grid, ItemStack stack, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == null) {
            return ActionResultType.PASS;
        }
        int pos = IGridHost.target(hit, false);
        if (pos < 0 || grid.getPart(pos, (byte)1) != null) {
            pos = IGridHost.target(hit, true);
        }
        if (pos < 0) {
            return ActionResultType.PASS;
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        CompoundNBT tag = stack.func_196082_o();
        BlockState block = MicroBlockItem.getBlock(new BlockItemUseContext(player, hand, ItemStack.func_199557_a((CompoundNBT)tag), hit));
        if (block == null) {
            return ActionResultType.FAIL;
        }
        MicroBlock part = (MicroBlock)grid.findPart(p -> p instanceof MicroBlock && ((MicroBlock)p).block == block);
        if (!(part == null ? grid.addPart(new MicroBlock(block, tag, 1L << pos)) : part.addVoxel(pos))) {
            return ActionResultType.FAIL;
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ItemStack convert(ItemStack stack, World world, PlayerEntity player, BlockPos pos) {
        BlockState state = MicroBlockItem.getBlock(new BlockItemUseContext(world, player, Hand.MAIN_HAND, stack, new BlockRayTraceResult(Vector3d.func_237490_a_((Vector3i)pos, (double)1.0), Direction.UP, pos, false)));
        return state != null ? this.wrap(stack, state, 64) : ItemStack.field_190927_a;
    }

    public static BlockState getBlock(BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        if (!(stack.func_77973_b() instanceof BlockItem)) {
            return null;
        }
        Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
        BlockState state = block.func_196258_a(context);
        return state.func_235785_r_((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a) ? state : null;
    }

    public ItemStack wrap(ItemStack stack, BlockState state, int n) {
        ItemStack ret = new ItemStack((IItemProvider)this, n);
        CompoundNBT nbt = stack.func_77955_b(ret.func_196082_o());
        nbt.func_74774_a("Count", (byte)1);
        nbt.func_74768_a("state", Block.func_196246_j((BlockState)state));
        return ret;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelDataMap getModelData(ItemStack stack, ClientWorld world, LivingEntity entity) {
        BlockState state = Block.func_196257_b((int)stack.func_196082_o().func_74762_e("state"));
        if (state.func_177230_c() == Blocks.field_150350_a) {
            state = Blocks.field_150348_b.func_176223_P();
        }
        ModelDataMap data = TileEntityModel.MODEL_DATA_BUILDER.build();
        ArrayList<BakedQuad> quads = JitBakedModel.make((IModelData)data).inner();
        float[] ofs = new float[]{0.25f, 0.25f, 0.25f};
        float[] size = new float[]{0.5f, 0.5f, 0.5f};
        for (MicroBlockFace f : MicroBlockFace.facesOf(state)) {
            if (f == null) continue;
            quads.add(f.makeRect(ofs, size));
        }
        return data;
    }
}

