/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Utils;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class Encoders<T> {
    private static final HashMap<Class<?>, Encoders<?>> ENCODERS = new HashMap();
    public final Function<T, INBT> encode;
    public final Function<INBT, T> decode;
    public final BiConsumer<T, INBT> idec;
    public final BinObjEnc<T> binary;

    public static <T> void register(Class<T> c, Function<T, INBT> enc, Function<INBT, T> dec, BiConsumer<T, INBT> idec, BinObjEnc<T> bin) {
        ENCODERS.put(c, new Encoders<T>(enc, dec, idec, bin));
    }

    public static <T> Encoders<T> of(Class<T> c) {
        Encoders<?> enc = ENCODERS.get(c);
        if (enc == null && INBTSerializable.class.isAssignableFrom(c)) {
            enc = ENCODERS.get(INBTSerializable.class);
        }
        return enc;
    }

    private Encoders(Function<T, INBT> encode, Function<INBT, T> decode, BiConsumer<T, INBT> idec, BinObjEnc<T> binary) {
        this.encode = encode;
        this.decode = decode;
        this.idec = idec;
        this.binary = binary;
    }

    <C> Pair<Function<C, INBT>, BiConsumer<C, INBT>> compose(Function<C, T> get, BiConsumer<C, T> set) {
        BiConsumer<Object, INBT> write;
        if (set != null && this.decode != null) {
            Function decode = this.decode;
            write = (o, nbt) -> set.accept(o, decode.apply((INBT)nbt));
        } else if (this.idec != null) {
            BiConsumer idec = this.idec;
            write = (o, nbt) -> idec.accept((Object)get.apply(o), (INBT)nbt);
        } else {
            write = null;
        }
        return Pair.of(this.encode == null ? null : this.encode.compose(get), write);
    }

    public static void relaxedArrayCopy(Object to, Object from) {
        int l0;
        int l1 = Array.getLength(to);
        int n = l0 = from == null ? 0 : Math.min(l1, Array.getLength(from));
        if (l0 > 0) {
            System.arraycopy(from, 0, to, 0, l0);
        }
    }

    static {
        Encoders.register(CompoundNBT.class, val -> val, nbt -> nbt instanceof CompoundNBT ? (CompoundNBT)nbt : new CompoundNBT(), null, new BinObjEnc<CompoundNBT>(){

            @Override
            public void encode(CompoundNBT val, PacketBuffer pkt) {
                pkt.func_150786_a(val);
            }

            @Override
            public CompoundNBT decode(CompoundNBT old, PacketBuffer pkt) throws IOException {
                return pkt.func_150793_b();
            }
        });
        Encoders.register(ListNBT.class, val -> val, nbt -> nbt instanceof ListNBT ? (ListNBT)nbt : new ListNBT(), null, null);
        Encoders.register(String.class, StringNBT::func_229705_a_, nbt -> nbt instanceof StringNBT ? ((StringNBT)nbt).func_150285_a_() : "", null, new BinObjEnc<String>(){

            @Override
            public void encode(String val, PacketBuffer pkt) {
                pkt.func_180714_a(val);
            }

            @Override
            public String decode(String old, PacketBuffer pkt) {
                return pkt.func_150789_c(1024);
            }
        });
        Encoders.register(ItemStack.class, val -> val.func_190926_b() ? null : val.func_77955_b(new CompoundNBT()), nbt -> nbt instanceof CompoundNBT ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt)) : ItemStack.field_190927_a, null, new BinObjEnc<ItemStack>(){

            @Override
            public void encode(ItemStack val, PacketBuffer pkt) {
                pkt.func_150788_a(val);
            }

            @Override
            public ItemStack decode(ItemStack old, PacketBuffer pkt) throws IOException {
                return pkt.func_150791_c();
            }
        });
        Encoders.register(FluidStack.class, val -> val == null ? null : val.writeToNBT(new CompoundNBT()), nbt -> nbt instanceof CompoundNBT ? FluidStack.loadFluidStackFromNBT((CompoundNBT)((CompoundNBT)nbt)) : null, null, new BinObjEnc<FluidStack>(){

            @Override
            public void encode(FluidStack val, PacketBuffer pkt) {
                ItemFluidUtil.writeFluidStack(pkt, val);
            }

            @Override
            public FluidStack decode(FluidStack old, PacketBuffer pkt) throws IOException {
                return ItemFluidUtil.readFluidStack(pkt);
            }
        });
        Encoders.register(BlockPos.class, val -> val == null ? null : LongNBT.func_229698_a_((long)val.func_218275_a()), nbt -> nbt instanceof LongNBT ? BlockPos.func_218283_e((long)((LongNBT)nbt).func_150291_c()) : null, null, new BinObjEnc<BlockPos>(){

            @Override
            public void encode(BlockPos val, PacketBuffer pkt) {
                pkt.func_179255_a(val != null ? val : Utils.NOWHERE);
            }

            @Override
            public BlockPos decode(BlockPos old, PacketBuffer pkt) throws IOException {
                return pkt.func_179259_c();
            }
        });
        Encoders.register(byte[].class, ByteArrayNBT::new, nbt -> nbt instanceof ByteArrayNBT ? ((ByteArrayNBT)nbt).func_150292_c() : new byte[]{}, (val, nbt) -> Encoders.relaxedArrayCopy(val, nbt instanceof ByteArrayNBT ? ((ByteArrayNBT)nbt).func_150292_c() : null), new BinObjEnc<byte[]>(){

            @Override
            public void encode(byte[] val, PacketBuffer pkt) {
                pkt.func_179250_a(val);
            }

            @Override
            public byte[] decode(byte[] old, PacketBuffer pkt) throws IOException {
                return pkt.func_179251_a();
            }
        });
        Encoders.register(int[].class, IntArrayNBT::new, nbt -> nbt instanceof IntArrayNBT ? ((IntArrayNBT)nbt).func_150302_c() : new int[]{}, (val, nbt) -> Encoders.relaxedArrayCopy(val, nbt instanceof IntArrayNBT ? ((IntArrayNBT)nbt).func_150302_c() : null), new BinObjEnc<int[]>(){

            @Override
            public void encode(int[] val, PacketBuffer pkt) {
                pkt.func_186875_a(val);
            }

            @Override
            public int[] decode(int[] old, PacketBuffer pkt) throws IOException {
                return pkt.func_186863_b();
            }
        });
    }

    public static interface BinObjEnc<T> {
        default public boolean hasChanged(T val, Object[] states, int i) {
            if (Objects.equals(val, states[i])) {
                return false;
            }
            states[i] = val;
            return true;
        }

        public void encode(T var1, PacketBuffer var2);

        public T decode(T var1, PacketBuffer var2) throws IOException;

        default public void update(T old, PacketBuffer pkt) throws IOException {
            this.decode(old, pkt);
        }
    }
}

