/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.Lib;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GuiNetworkHandler
extends NetworkHandler {
    public static GuiNetworkHandler GNH_INSTANCE;
    private static final int MAX_QUEUED = 16;
    private ArrayDeque<PacketBuffer> packetQueue = new ArrayDeque(16);

    public static void register() {
        if (GNH_INSTANCE == null) {
            GNH_INSTANCE = new GuiNetworkHandler(Lib.rl("ui"));
        }
    }

    private GuiNetworkHandler(ResourceLocation channel) {
        super(channel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        int curId = container.field_75152_c;
        int id = pkt.markReaderIndex().readInt();
        if ((curId == id || curId == 0) && container instanceof IServerPacketReceiver) {
            ((IServerPacketReceiver)container).handleServerPacket(pkt);
            if (pkt.readableBytes() > 0) {
                StringBuilder sb = new StringBuilder("Packet > GUI: ");
                GuiNetworkHandler.printPacketData(sb, pkt);
                Lib.LOG.info(NETWORK, sb.toString());
            }
        } else if (id > curId) {
            if (this.packetQueue.size() >= 16) {
                this.packetQueue.remove();
                Lib.LOG.warn(NETWORK, "GUI packet queue overflow!");
            }
            pkt.resetReaderIndex();
            this.packetQueue.add(pkt);
        } else {
            Lib.LOG.warn(NETWORK, "received packet for invalid GUI {} @CLIENT, expected id {} ({})", (Object)id, (Object)container.field_75152_c, container.getClass());
        }
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        int id = pkt.readInt();
        Container container = sender.field_71070_bA;
        if (container.field_75152_c == id && container instanceof IPlayerPacketReceiver) {
            ((IPlayerPacketReceiver)container).handlePlayerPacket(pkt, sender);
            if (pkt.readableBytes() > 0) {
                StringBuilder sb = new StringBuilder("Packet > SERVER: ");
                GuiNetworkHandler.printPacketData(sb, pkt);
                Lib.LOG.info(NETWORK, sb.toString());
            }
        } else {
            Lib.LOG.warn(NETWORK, "received packet for invalid GUI {} @SERVER, expected id {} ({})", (Object)id, (Object)container.field_75152_c, container.getClass());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGuiOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof ContainerScreen) {
            for (int i = this.packetQueue.size(); i > 0; --i) {
                PacketBuffer buf = this.packetQueue.remove();
                try {
                    this.handleServerPacket(buf);
                    continue;
                }
                catch (Exception e) {
                    this.logError(buf, "QUEUED", e);
                }
            }
        }
    }

    public static PacketBuffer preparePacket(Container container) {
        PacketBuffer pkt = new PacketBuffer(Unpooled.buffer());
        pkt.writeInt(container.field_75152_c);
        return pkt;
    }

    @Override
    protected String version() {
        return "0";
    }
}

