/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.Lib;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.util.DimPos;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class NetworkHandler
implements Consumer<NetworkEvent>,
IServerPacketReceiver,
IPlayerPacketReceiver {
    private static final long LOG_INTERVAL = 1000L;
    public static final Marker NETWORK = MarkerManager.getMarker((String)"Network");
    public final EventNetworkChannel eventChannel;
    public final ResourceLocation channel;
    private long lastErr;
    private int errCount;

    protected NetworkHandler(ResourceLocation channel) {
        this.channel = channel;
        this.eventChannel = NetworkRegistry.newEventChannel((ResourceLocation)channel, this::version, this::acceptClient, this::acceptServer);
        this.eventChannel.addListener((Consumer)this);
    }

    protected abstract String version();

    protected boolean acceptClient(String version) {
        return this.version().equals(version);
    }

    protected boolean acceptServer(String version) {
        return this.version().equals(version);
    }

    @Override
    public void accept(NetworkEvent e) {
        if (e instanceof NetworkEvent.ChannelRegistrationChangeEvent) {
            return;
        }
        PacketBuffer data = e.getPayload();
        NetworkEvent.Context c = (NetworkEvent.Context)e.getSource().get();
        String source = "UNKNOWN";
        try {
            switch (c.getDirection()) {
                case PLAY_TO_CLIENT: {
                    source = "SERVER";
                    this.handleServerPacket(data);
                    break;
                }
                case PLAY_TO_SERVER: {
                    ServerPlayerEntity player = c.getSender();
                    source = "PLAYER \"" + player.func_200200_C_() + "\"";
                    this.handlePlayerPacket(data, player);
                    break;
                }
                default: {
                    return;
                }
            }
            c.setPacketHandled(true);
        }
        catch (Exception ex) {
            this.logError(data, source, ex);
        }
    }

    protected void logError(PacketBuffer buf, String source, Exception e) {
        long t = System.currentTimeMillis();
        if (t - this.lastErr < 1000L) {
            ++this.errCount;
        } else {
            this.lastErr = t;
            if (this.errCount > 0) {
                Lib.LOG.error(NETWORK, "suppressed {} additional packet processing errors within the last {}ms", (Object)this.errCount, (Object)(t - this.lastErr));
                this.errCount = 0;
            }
            StringBuilder sb = new StringBuilder("failed processing packet from ").append(source).append(" @").append(this.channel).append(": \n");
            NetworkHandler.printPacketData(sb, buf);
            Lib.LOG.error(NETWORK, (CharSequence)sb, (Throwable)e);
        }
    }

    public static void printPacketData(StringBuilder sb, PacketBuffer p) {
        int r = p.readerIndex();
        int l = p.writerIndex();
        sb.append("read ").append(r).append(" of ").append(l).append(" bytes [");
        for (int i = 0; i < l; ++i) {
            sb.append(String.format("%02X ", p.getUnsignedByte(i)));
        }
        sb.setCharAt(sb.length() - 1, ']');
    }

    public IPacket<?> packet2C(PacketBuffer data) {
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket(Pair.of((Object)data, (Object)0), this.channel).getThis();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(PacketBuffer pkt) {
        Minecraft.func_71410_x().func_147114_u().func_147297_a(NetworkDirection.PLAY_TO_SERVER.buildPacket(Pair.of((Object)pkt, (Object)0), this.channel).getThis());
    }

    public void sendToPlayer(PacketBuffer pkt, ServerPlayerEntity player) {
        player.field_71135_a.field_147371_a.func_179290_a(this.packet2C(pkt));
    }

    public void sendToPlayers(PacketBuffer pkt, Collection<ServerPlayerEntity> players) {
        IPacket<?> packet = this.packet2C(pkt);
        for (ServerPlayerEntity player : players) {
            player.field_71135_a.field_147371_a.func_179290_a(packet);
        }
    }

    public void sendToAllNear(PacketBuffer pkt, DimPos pos, double range) {
        ((MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER)).func_184103_al().func_148543_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, range, pos.dim, this.packet2C(pkt));
    }
}

