/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.network.Synchronizer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class StateSyncAdv
extends StateSynchronizer {
    public final Object[] holders;
    final Synchronizer<?>[] synchronizers;
    final int[] rawIdx;

    public static int[] array(int size, int count) {
        int[] indices = new int[count];
        int i = 0;
        int j = size;
        while (i < count) {
            indices[i] = j;
            ++i;
            j += size;
        }
        return indices;
    }

    public static int[] sequence(int ... sizes) {
        int s = 0;
        int i = 0;
        while (i < sizes.length) {
            int n = i++;
            int n2 = sizes[n] + s;
            sizes[n] = n2;
            s = n2;
        }
        return sizes;
    }

    public static StateSyncAdv of(boolean client, Object ... elements) {
        return StateSyncAdv.of(client, new int[0], 0, elements);
    }

    public static StateSyncAdv of(boolean client, int[] rawIdx, int objects, Object ... elements) {
        Synchronizer[] synchronizers = new Synchronizer[elements.length];
        int[] ofsIdx = new int[elements.length];
        int[] ofsObj = new int[elements.length];
        int l = rawIdx.length;
        int bytes = l > 0 ? rawIdx[l - 1] : 0;
        int indices = objects + l;
        for (int i = 0; i < elements.length; ++i) {
            Object o = elements[i];
            Synchronizer<?> s = client && o instanceof Class ? Synchronizer.of((Class)o) : Synchronizer.of(o.getClass());
            ofsIdx[i] = indices + 1;
            ofsObj[i] = objects;
            indices += s.syncVariables();
            objects += s.objSize();
            bytes += s.rawSize();
            synchronizers[i] = s;
        }
        return new StateSyncAdv(indices, ofsIdx, ofsObj, objects, bytes, client ? null : elements, synchronizers, rawIdx);
    }

    private StateSyncAdv(int count, int[] indices, int[] objIdx, int objCount, int rawSize, Object[] holders, Synchronizer<?>[] synchronizers, int[] rawIdx) {
        super(count, indices, objIdx, new Object[objCount], ByteBuffer.allocate(rawSize).order(ByteOrder.LITTLE_ENDIAN));
        this.holders = holders;
        this.synchronizers = synchronizers;
        this.rawIdx = rawIdx;
    }

    @Override
    public BitSet clear() {
        this.rawStates.clear();
        if (this.set.get(0)) {
            this.set.clear(0);
            this.set.set(1, this.count + 1);
        } else {
            this.set.clear();
        }
        return this.set;
    }

    @Override
    public BitSet read(ByteBuf buf) {
        this.rawStates.clear();
        return super.read(buf);
    }

    public void detectChanges() {
        this.rawStates.clear();
        if (this.rawIdx.length > 0) {
            this.rawStates.position(this.rawIdx[this.rawIdx.length - 1]);
        }
        for (int i = 0; i < this.synchronizers.length; ++i) {
            this.synchronizers[i].detectChanges(this.holders[i], this.rawStates, this.objStates, this.objIdx[i], this.set, this.indices[i]);
        }
        this.rawStates.rewind();
    }

    public void writeChanges(PacketBuffer pkt) {
        int j;
        int i;
        int i1 = this.rawIdx.length + 1;
        for (i = 1; i <= i1 && (j = this.set.nextSetBit(i)) > 0 && j < i1; ++i) {
            i = this.set.nextClearBit(j + 1);
            if (i > i1) {
                i = i1;
            }
            this.rawStates.limit(this.rawIdx[i - 2]);
            if (j >= 2) {
                this.rawStates.position(this.rawIdx[j - 2]);
            }
            pkt.writeBytes(this.rawStates);
        }
        this.rawStates.clear();
        if (i1 >= 2) {
            this.rawStates.position(this.rawIdx[i1 - 2]);
        }
        for (i = 0; i < this.synchronizers.length; ++i) {
            this.synchronizers[i].writeChanged(pkt, this.rawStates, this.objStates, this.objIdx[i], this.set, this.indices[i]);
        }
    }

    public void readChanges(PacketBuffer pkt) throws IOException {
        int j;
        int i;
        int i1 = this.rawIdx.length + 1;
        for (i = 1; i <= i1 && (j = this.set.nextSetBit(i)) > 0 && j < i1; ++i) {
            i = this.set.nextClearBit(j + 1);
            if (i > i1) {
                i = i1;
            }
            this.rawStates.limit(this.rawIdx[i - 2]);
            if (j >= 2) {
                this.rawStates.position(this.rawIdx[j - 2]);
            }
            pkt.readBytes(this.rawStates);
        }
        this.rawStates.clear();
        if (i1 >= 2) {
            this.rawStates.position(this.rawIdx[i1 - 2]);
        }
        if (this.holders == null) {
            for (i = 0; i < this.synchronizers.length; ++i) {
                this.synchronizers[i].readChanges(pkt, this.rawStates, this.objStates, this.objIdx[i], this.set, this.indices[i]);
            }
        } else {
            for (i = 0; i < this.synchronizers.length; ++i) {
                this.synchronizers[i].updateChanges(this.holders[i], pkt, this.set, this.indices[i]);
            }
        }
    }

    public int objIdxOfs() {
        return 1 + this.rawIdx.length;
    }

    public <T> T get(int i) {
        return (T)this.objStates[i];
    }

    public void set(int i, Object v) {
        this.set.set(i + this.objIdxOfs());
        this.objStates[i] = v;
    }

    public void setDouble(int i, double v) {
        this.setDouble(i, -8, v);
    }

    public void setFloat(int i, float v) {
        this.setFloat(i, -4, v);
    }

    public void setLong(int i, long v) {
        this.setLong(i, -8, v);
    }

    public void setInt(int i, int v) {
        this.setInt(i, -4, v);
    }

    public void setShort(int i, int v) {
        this.setShort(i, -2, v);
    }

    public void setByte(int i, int v) {
        this.setByte(i, -1, v);
    }

    public void setDouble(int i, int p, double v) {
        this.setLong(i, p, Double.doubleToRawLongBits(v));
    }

    public void setFloat(int i, int p, float v) {
        this.setInt(i, p, Float.floatToRawIntBits(v));
    }

    public void setLong(int i, int p, long v) {
        if (v != this.rawStates.getLong(p += this.rawIdx[i])) {
            this.rawStates.putLong(p, v);
            this.set.set(i + 1);
        }
    }

    public void setInt(int i, int p, int v) {
        if (v != this.rawStates.getInt(p += this.rawIdx[i])) {
            this.rawStates.putInt(p, v);
            this.set.set(i + 1);
        }
    }

    public void setShort(int i, int p, int v) {
        if ((short)v != this.rawStates.getShort(p += this.rawIdx[i])) {
            this.rawStates.putShort(p, (short)v);
            this.set.set(i + 1);
        }
    }

    public void setByte(int i, int p, int v) {
        if ((byte)v != this.rawStates.get(p += this.rawIdx[i])) {
            this.rawStates.put(p, (byte)v);
            this.set.set(i + 1);
        }
    }

    public ByteBuffer buffer() {
        return this.rawStates;
    }

    public int objIndex(Class<?> c, String name) {
        for (int i = 0; i < this.synchronizers.length; ++i) {
            Synchronizer<?> s = this.synchronizers[i];
            if (c != null && s.clazz != c) continue;
            int j = s.varIndex(name);
            if (j >= 0) {
                return this.objIdx[i] + j;
            }
            if (c == null) continue;
            throw new IllegalArgumentException("variable '" + name + "' is not defined!");
        }
        throw new IllegalArgumentException("class '" + c + "' is not listed!");
    }

    public long rawIndex(Class<?> c, String name) {
        int l = this.rawIdx.length;
        int p = l > 0 ? this.rawIdx[l - 1] : 0;
        for (Synchronizer<?> s : this.synchronizers) {
            if (c == null || s.clazz == c) {
                int j = s.varIndex(name);
                if (j >= 0) {
                    int i0 = s.indices[j];
                    return (long)(p + i0) | (long)(s.indices[j + 1] - i0) << 32;
                }
                if (c != null) {
                    throw new IllegalArgumentException("variable '" + name + "' is not defined!");
                }
            }
            p += s.rawSize();
        }
        throw new IllegalArgumentException(c != null ? "class '" + c + "' is not listed!" : "variable '" + name + "' is not defined!");
    }

    public <U> Supplier<U> objGetter(String name) {
        return this.objGetter(null, name);
    }

    public <U> Supplier<U> objGetter(Class<?> c, String name) {
        return this.objGetter(this.objIndex(c, name));
    }

    public <U> Supplier<U> objGetter(int i) {
        Object[] states = this.objStates;
        return () -> states[i];
    }

    public DoubleSupplier floatGetter(String name, boolean integer) {
        return this.floatGetter(null, name, integer);
    }

    public DoubleSupplier floatGetter(Class<?> c, String name, boolean integer) {
        long i = this.rawIndex(c, name);
        return this.floatGetter((int)i, (int)(i >>> 32), integer);
    }

    public DoubleSupplier floatGetter(int p, int l, boolean integer) {
        ByteBuffer state = this.rawStates;
        switch (l) {
            case 8: {
                return integer ? () -> state.getLong(p) : () -> state.getDouble(p);
            }
            case 4: {
                return integer ? () -> state.getInt(p) : () -> state.getFloat(p);
            }
            case 2: {
                return () -> state.getShort(p);
            }
            case 1: {
                return () -> state.get(p);
            }
        }
        throw new IllegalArgumentException();
    }

    public IntSupplier intGetter(String name, boolean signed) {
        return this.intGetter(null, name, signed);
    }

    public IntSupplier intGetter(Class<?> c, String name, boolean signed) {
        long i = this.rawIndex(c, name);
        return this.intGetter((int)i, (int)(i >>> 32), signed);
    }

    public IntSupplier intGetter(int i, boolean signed) {
        int p = i == 0 ? 0 : this.rawIdx[i - 1];
        return this.intGetter(p, this.rawIdx[i] - p, signed);
    }

    public IntSupplier intGetter(int p, int l, boolean signed) {
        ByteBuffer state = this.rawStates;
        switch (l) {
            case 8: {
                return () -> (int)state.getLong(p);
            }
            case 4: {
                return () -> state.getInt(p);
            }
            case 2: {
                return signed ? () -> state.getShort(p) : () -> state.getShort(p) & 0xFFFF;
            }
            case 1: {
                return signed ? () -> state.get(p) : () -> state.get(p) & 0xFF;
            }
        }
        throw new IllegalStateException();
    }

    public LongSupplier longGetter(String name, boolean signed) {
        return this.longGetter(null, name, signed);
    }

    public LongSupplier longGetter(Class<?> c, String name, boolean signed) {
        long i = this.rawIndex(c, name);
        return this.longGetter((int)i, (int)(i >>> 32), signed);
    }

    public LongSupplier longGetter(int p, int l, boolean signed) {
        ByteBuffer state = this.rawStates;
        switch (l) {
            case 8: {
                return () -> state.getLong(p);
            }
            case 4: {
                return signed ? () -> state.getInt(p) : () -> (long)state.getInt(p) & 0xFFFFFFFFL;
            }
            case 2: {
                return signed ? () -> state.getShort(p) : () -> (long)state.getShort(p) & 0xFFFFL;
            }
            case 1: {
                return signed ? () -> state.get(p) : () -> (long)state.get(p) & 0xFFL;
            }
        }
        throw new IllegalStateException();
    }

    public BooleanSupplier boolGetter(String name) {
        return this.boolGetter(null, name);
    }

    public BooleanSupplier boolGetter(Class<?> c, String name) {
        long i = this.rawIndex(c, name);
        return this.boolGetter((int)i, (int)(i >>> 32));
    }

    public BooleanSupplier boolGetter(int p, int l) {
        ByteBuffer state = this.rawStates;
        switch (l) {
            case 8: {
                return () -> state.getLong(p) != 0L;
            }
            case 4: {
                return () -> state.getInt(p) != 0;
            }
            case 2: {
                return () -> state.getShort(p) != 0;
            }
            case 1: {
                return () -> state.get(p) != 0;
            }
        }
        throw new IllegalStateException();
    }
}

