/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.util.ItemFluidUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class StateSyncServer
extends StateSynchronizer {
    public byte[] header;
    public final PacketBuffer buffer;
    private final int fixCount;
    private int elIdx = -1;
    public boolean sendAll = true;

    public StateSyncServer(int count, int ... sizes) {
        super(count, StateSyncServer.accumulate(sizes), sizes, (Object[])new byte[count - sizes.length][], ByteBuffer.allocate(StateSyncServer.count(sizes)));
        if (sizes.length > count) {
            throw new IllegalArgumentException("can't have more fixed sized elements than total elements!");
        }
        this.fixCount = sizes.length;
        this.buffer = new PacketBuffer(Unpooled.buffer());
    }

    public StateSyncServer setInitPkt() {
        this.sendAll = true;
        return this;
    }

    public void setHeader() {
        int l = this.buffer.readableBytes();
        if (this.header == null || this.header.length != l) {
            this.header = new byte[l];
        }
        this.buffer.readBytes(this.header);
    }

    public StateSyncServer begin() {
        this.buffer.clear();
        this.set.clear();
        this.elIdx = -1;
        return this;
    }

    public StateSyncServer endFixed() {
        int l;
        BitSet chng = this.set;
        if (this.sendAll) {
            this.buffer.readBytes(this.rawStates.array());
            l = this.buffer.readableBytes();
            chng.set(1, this.count + 1);
        } else {
            byte[] arr0 = this.buffer.array();
            byte[] arr1 = this.rawStates.array();
            int i0 = this.buffer.arrayOffset();
            int i1 = 0;
            l = this.buffer.readableBytes();
            int j = 0;
            for (int n : this.objIdx) {
                if ((l -= n) < 0) {
                    throw new IllegalStateException("end of buffer reached!");
                }
                while (n > 0) {
                    if (arr0[i0] != arr1[i1]) {
                        chng.set(j + 1);
                        System.arraycopy(arr0, i0, arr1, i1, n);
                    }
                    --n;
                    ++i0;
                    ++i1;
                }
                ++j;
            }
        }
        if (l > 0) {
            throw new IllegalStateException("buffer still has unread data left!");
        }
        this.buffer.clear();
        this.elIdx = this.objIdx.length;
        return this;
    }

    public PacketBuffer encodePacket() {
        BitSet chng;
        int cc;
        if (this.elIdx < 0 && this.buffer.readableBytes() > 0) {
            this.endFixed();
        }
        if ((cc = (chng = this.set).cardinality()) == 0) {
            return null;
        }
        PacketBuffer buf = this.buffer;
        buf.clear();
        if (this.header != null) {
            buf.writeBytes(this.header);
        }
        boolean all = this.sendAll || cc >= this.count;
        this.write((ByteBuf)buf);
        if (all) {
            buf.writeBytes(this.rawStates);
            for (Object arr : this.objStates) {
                buf.writeBytes((byte[])arr);
            }
        } else {
            int[] sizes = this.objIdx;
            int i = 0;
            int j = 0;
            while (i < this.fixCount) {
                int n = sizes[i];
                if (chng.get(++i)) {
                    buf.writeBytes(this.rawStates.array(), j, n);
                }
                j += n;
            }
            int p = chng.nextSetBit(this.fixCount + 1);
            while (p >= 0) {
                buf.writeBytes((byte[])this.objStates[p - this.fixCount - 1]);
                p = chng.nextSetBit(p + 1);
            }
        }
        this.elIdx = -1;
        this.sendAll = false;
        return new PacketBuffer(buf.copy());
    }

    public void put() {
        this.set(this.elIdx++);
    }

    public void put(byte[] data) {
        this.set(this.elIdx++, data);
    }

    public void set(int i) {
        if (i < 0) {
            throw new IllegalStateException("element must be submitted as variabled sized!");
        }
        if (i < this.fixCount) {
            int i1;
            byte[] arr0 = this.buffer.array();
            byte[] arr1 = this.rawStates.array();
            int i0 = this.buffer.arrayOffset() + this.buffer.readerIndex();
            int l0 = this.buffer.readableBytes();
            int l1 = this.objIdx[i];
            if (this.sendAll) {
                this.set.set(i + 1);
                System.arraycopy(arr0, i0, arr1, i1, l1);
            } else {
                int l = i1 + l1;
                for (i1 = this.indices[i]; i1 < l; ++i1) {
                    if (arr0[i0] != arr1[i1]) {
                        this.set.set(i + 1);
                        System.arraycopy(arr0, i0, arr1, i1, l - i1);
                    }
                    ++i0;
                }
            }
            if (l0 > l1) {
                this.buffer.skipBytes(l1);
                this.set(i + 1);
            }
        } else {
            byte[] arr0 = this.buffer.array();
            byte[] arr1 = (byte[])this.objStates[i - this.fixCount];
            int i0 = this.buffer.arrayOffset() + this.buffer.readerIndex();
            int l = this.buffer.readableBytes();
            if (this.sendAll || l != arr1.length) {
                this.set.set(i + 1);
                this.objStates[i - this.fixCount] = Arrays.copyOfRange(arr0, i0, i0 + l);
            } else {
                for (int i1 = 0; i1 < l; ++i1) {
                    if (arr0[i0] != arr1[i1]) {
                        this.set.set(i + 1);
                        System.arraycopy(arr0, i0, arr1, i1, l - i1);
                    }
                    ++i0;
                }
            }
        }
        this.buffer.clear();
    }

    public void set(int i, byte[] data) {
        if (this.sendAll || !Arrays.equals(data, (byte[])this.objStates[i -= this.fixCount])) {
            this.objStates[i] = data;
            this.set.set(i + 1);
        }
    }

    public StateSyncServer writeIntArray(int[] data) {
        PacketBuffer buf = this.buffer;
        for (int v : data) {
            buf.writeInt(v);
        }
        return this;
    }

    private int curSize() {
        int i = Arrays.binarySearch(this.indices, this.buffer.writerIndex());
        return i >= 0 ? this.objIdx[i] : 0;
    }

    private StateSyncServer check(int i, int l) {
        if (i >= this.fixCount) {
            throw new IllegalStateException("element must be submitted as fixed sized!");
        }
        if ((i < 0 ? this.curSize() : this.objIdx[i]) != l) {
            throw new IllegalStateException("wrong element size!");
        }
        return this;
    }

    public StateSyncServer writeInt(int v) {
        switch (this.curSize()) {
            case 4: {
                this.buffer.writeInt(v);
                break;
            }
            case 3: {
                this.buffer.writeMedium(v);
                break;
            }
            case 2: {
                this.buffer.writeShort(v);
                break;
            }
            case 1: {
                this.buffer.writeByte(v);
                break;
            }
            default: {
                throw new IllegalStateException("size for int element must be 1, 2, 3 or 4!");
            }
        }
        return this;
    }

    public StateSyncServer set(int i, Object v) {
        if (v instanceof Number) {
            Number n = (Number)v;
            if (n instanceof Float) {
                this.check((int)i, (int)4).buffer.writeFloat(n.floatValue());
            } else if (n instanceof Double) {
                this.check((int)i, (int)8).buffer.writeDouble(n.doubleValue());
            } else if (n instanceof Long) {
                this.check((int)i, (int)8).buffer.writeLong(n.longValue());
            } else {
                this.writeInt(n.intValue());
            }
        } else if (v instanceof byte[]) {
            if (i < this.fixCount) {
                this.buffer.writeBytes((byte[])v);
            } else {
                this.buffer.func_179250_a((byte[])v);
            }
        } else if (v instanceof int[]) {
            if (i < this.fixCount) {
                this.writeIntArray((int[])v);
            } else {
                this.buffer.func_186875_a((int[])v);
            }
        } else if (v instanceof BlockPos) {
            this.check((int)i, (int)8).buffer.func_179255_a((BlockPos)v);
        } else if (v instanceof Enum) {
            this.writeInt(((Enum)v).ordinal());
        } else if (v == null) {
            if (i < this.fixCount) {
                this.writeInt(-1);
            } else {
                this.buffer.func_180714_a("");
            }
        } else if (v instanceof String) {
            this.buffer.func_180714_a((String)v);
        } else if (v instanceof UUID) {
            this.check((int)i, (int)16).buffer.func_179252_a((UUID)v);
        } else if (v instanceof CompoundNBT) {
            this.buffer.func_150786_a((CompoundNBT)v);
        } else if (v instanceof ItemStack) {
            ItemStack stack = (ItemStack)v;
            if (stack.func_190926_b()) {
                this.buffer.writeShort(-1);
            } else {
                Item item = stack.func_77973_b();
                this.buffer.writeShort(Item.func_150891_b((Item)item));
                this.buffer.writeInt(stack.func_190916_E());
                this.buffer.writeShort(stack.func_77952_i());
                CompoundNBT nbt = null;
                if (item.func_77645_m()) {
                    nbt = item.getShareTag(stack);
                }
                this.buffer.func_150786_a(nbt);
            }
        } else if (v instanceof FluidStack) {
            ItemFluidUtil.writeFluidStack(this.buffer, (FluidStack)v);
        } else {
            throw new IllegalArgumentException("invalid element type!");
        }
        if (i >= 0) {
            this.set(i);
        }
        return this;
    }

    public StateSyncServer putAll(Object ... values) {
        int i = this.elIdx;
        if (i < 0) {
            for (Object v : values) {
                this.set(-1, v);
            }
        } else {
            for (Object v : values) {
                this.set(i++, v);
            }
            this.elIdx = i;
        }
        return this;
    }
}

