/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.SyncBitset;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.nio.ByteBuffer;

public abstract class StateSynchronizer
extends SyncBitset {
    protected final Object[] objStates;
    protected final ByteBuffer rawStates;
    protected final int[] indices;
    protected final int[] objIdx;

    public StateSynchronizer(int count, int[] indices, int[] objIdx, Object[] objStates, ByteBuffer rawStates) {
        super(count);
        this.indices = indices;
        this.objIdx = objIdx;
        this.objStates = objStates;
        this.rawStates = rawStates;
    }

    protected static int count(int[] sizes) {
        int l = 0;
        for (int n : sizes) {
            l += n;
        }
        return l;
    }

    protected static int[] accumulate(int[] sizes) {
        int[] indices = new int[sizes.length];
        int l = 0;
        for (int i = 0; i < sizes.length; ++i) {
            indices[i] = l;
            l += sizes[i];
        }
        return indices;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IntArrayList sizes = new IntArrayList();
        private int count;

        private Builder() {
        }

        public Builder addVar(int count) {
            this.count += count;
            return this;
        }

        public Builder addFix(int ... sizes) {
            this.sizes.addElements(this.sizes.size(), sizes);
            return this;
        }

        public Builder addMulFix(int size, int count) {
            while (count > 0) {
                this.sizes.add(size);
                --count;
            }
            return this;
        }

        public int varCount() {
            return this.count;
        }

        public int fixCount() {
            return this.sizes.size();
        }

        public StateSyncServer buildSender() {
            return new StateSyncServer(this.count + this.sizes.size(), this.sizes.toIntArray());
        }

        public StateSyncClient buildReceiver() {
            return new StateSyncClient(this.count + this.sizes.size(), this.sizes.toIntArray());
        }

        public StateSynchronizer build(boolean receive) {
            return receive ? this.buildReceiver() : this.buildSender();
        }
    }
}

