/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import io.netty.buffer.ByteBuf;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface Sync {
    public static final int SAVE = 1;
    public static final int CLIENT = 2;
    public static final int SYNC = 4;
    public static final int ALL = 7;
    public static final int SPAWN = 8;
    public static final int GUI = Integer.MIN_VALUE;

    public int to() default 1;

    public Type type() default Type.Obj;

    public String tag() default "";

    public static enum Type {
        Obj(Object.class, -1),
        Fix(Object.class, -1),
        I1(Boolean.TYPE, 1),
        I8(Byte.TYPE, 1),
        I16(Short.TYPE, 2),
        I32(Integer.TYPE, 4),
        I64(Long.TYPE, 8),
        F32(Float.TYPE, 4),
        F64(Double.TYPE, 8),
        Enum(Enum.class, 1),
        Enum0(Enum.class, 1);

        final Class<?> inType;
        final MethodHandle read;
        final MethodHandle write;
        final MethodHandle comp;
        final MethodHandle update;
        final int size;

        private Type(Class<?> inType, int size) {
            this.inType = inType;
            this.size = size;
            try {
                if (inType.isPrimitive()) {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    this.read = l.unreflect(Type.class.getDeclaredMethod("read" + this.name(), INBT.class));
                    this.write = l.unreflect(Type.class.getDeclaredMethod("write" + this.name(), inType));
                    this.comp = l.unreflect(Type.class.getDeclaredMethod("check" + this.name(), inType, ByteBuffer.class));
                    String name = inType.getName();
                    this.update = l.unreflect(ByteBuf.class.getDeclaredMethod("read" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]));
                } else if (inType == Enum.class) {
                    MethodHandles.Lookup l = MethodHandles.lookup();
                    this.read = l.unreflect(Type.class.getDeclaredMethod("read" + this.name(), INBT.class, Enum[].class));
                    this.write = l.unreflect(Type.class.getDeclaredMethod("write" + this.name(), inType));
                    this.comp = l.unreflect(Type.class.getDeclaredMethod("check" + this.name(), inType, ByteBuffer.class));
                    this.update = l.unreflect(Type.class.getDeclaredMethod("read" + this.name(), ByteBuf.class, Enum[].class));
                } else {
                    this.read = null;
                    this.write = null;
                    this.comp = null;
                    this.update = null;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }

        public Type actual(Class<?> type) {
            if (type.isEnum()) {
                if (this.inType == Enum.class) {
                    return this;
                }
                return Enum;
            }
            if (!type.isPrimitive()) {
                return Obj;
            }
            if (this.inType.isPrimitive()) {
                return this;
            }
            for (Type t : Type.values()) {
                if (t.inType != type) continue;
                return t;
            }
            return this;
        }

        public MethodHandle read(Object[] enums) {
            return enums == null ? this.read : MethodHandles.insertArguments(this.read, 1, new Object[]{enums});
        }

        public MethodHandle update(Object[] enums) {
            return enums == null ? this.update : MethodHandles.insertArguments(this.update, 1, new Object[]{enums});
        }

        static boolean readI1(INBT nbt) {
            return nbt instanceof NumberNBT && ((NumberNBT)nbt).func_150290_f() != 0;
        }

        static byte readI8(INBT nbt) {
            return nbt instanceof NumberNBT ? ((NumberNBT)nbt).func_150290_f() : (byte)0;
        }

        static short readI16(INBT nbt) {
            return nbt instanceof NumberNBT ? ((NumberNBT)nbt).func_150289_e() : (short)0;
        }

        static int readI32(INBT nbt) {
            return nbt instanceof NumberNBT ? ((NumberNBT)nbt).func_150287_d() : 0;
        }

        static long readI64(INBT nbt) {
            return nbt instanceof NumberNBT ? ((NumberNBT)nbt).func_150291_c() : 0L;
        }

        static float readF32(INBT nbt) {
            return nbt instanceof NumberNBT ? ((NumberNBT)nbt).func_150288_h() : 0.0f;
        }

        static double readF64(INBT nbt) {
            return nbt instanceof NumberNBT ? ((NumberNBT)nbt).func_150286_g() : 0.0;
        }

        static <E extends Enum<E>> E readEnum(INBT nbt, E[] values) {
            int i = Type.readI8(nbt) & 0xFF;
            return i < values.length ? (E)values[i] : null;
        }

        static <E extends Enum<E>> E readEnum(ByteBuf buf, E[] values) {
            short i = buf.readUnsignedByte();
            return i < values.length ? (E)values[i] : null;
        }

        static <E extends Enum<E>> E readEnum0(INBT nbt, E[] values) {
            return values[Math.min(Type.readI8(nbt) & 0xFF, values.length - 1)];
        }

        static <E extends Enum<E>> E readEnum0(ByteBuf buf, E[] values) {
            return values[Math.min(buf.readUnsignedByte(), values.length - 1)];
        }

        static INBT writeI1(boolean val) {
            return ByteNBT.func_229672_a_((boolean)val);
        }

        static INBT writeI8(byte val) {
            return ByteNBT.func_229671_a_((byte)val);
        }

        static INBT writeI16(short val) {
            return ShortNBT.func_229701_a_((short)val);
        }

        static INBT writeI32(int val) {
            return IntNBT.func_229692_a_((int)val);
        }

        static INBT writeI64(long val) {
            return LongNBT.func_229698_a_((long)val);
        }

        static INBT writeF32(float val) {
            return FloatNBT.func_229689_a_((float)val);
        }

        static INBT writeF64(double val) {
            return DoubleNBT.func_229684_a_((double)val);
        }

        static INBT writeEnum(Enum<?> val) {
            return Type.writeI8((byte)val.ordinal());
        }

        static INBT writeEnum0(Enum<?> val) {
            return Type.writeI8((byte)(val == null ? -1 : val.ordinal()));
        }

        static boolean checkI1(boolean val, ByteBuffer state) {
            if (state.get() == 0 ^ val) {
                return false;
            }
            state.put(state.position() - 1, (byte)(val ? 1 : 0));
            return true;
        }

        static boolean checkI8(byte val, ByteBuffer state) {
            if (val == state.get()) {
                return false;
            }
            state.put(state.position() - 1, val);
            return true;
        }

        static boolean checkI16(short val, ByteBuffer state) {
            if (val == state.getShort()) {
                return false;
            }
            state.putShort(state.position() - 2, val);
            return true;
        }

        static boolean checkI32(int val, ByteBuffer state) {
            if (val == state.getInt()) {
                return false;
            }
            state.putInt(state.position() - 4, val);
            return true;
        }

        static boolean checkI64(long val, ByteBuffer state) {
            if (val == state.getLong()) {
                return false;
            }
            state.putLong(state.position() - 8, val);
            return true;
        }

        static boolean checkF32(float val, ByteBuffer state) {
            return Type.checkI32(Float.floatToIntBits(val), state);
        }

        static boolean checkF64(double val, ByteBuffer state) {
            return Type.checkI64(Double.doubleToLongBits(val), state);
        }

        static boolean checkEnum(Enum<?> val, ByteBuffer state) {
            return Type.checkI8((byte)val.ordinal(), state);
        }

        static boolean checkEnum0(Enum<?> val, ByteBuffer state) {
            return Type.checkI8((byte)(val == null ? -1 : val.ordinal()), state);
        }
    }
}

