/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.BitSet;

public class SyncBitset {
    public final int count;
    private final int modSetBytes;
    private final int idxBits;
    private final int idxCountBits;
    private final int maxIdxCount;
    public BitSet set;

    public SyncBitset(int count) {
        this.set = new BitSet(count + 1);
        this.count = count;
        if (count < 8) {
            this.modSetBytes = 1;
            this.maxIdxCount = 0;
            this.idxBits = 0;
            this.idxCountBits = 0;
        } else {
            this.modSetBytes = count / 8 + 1;
            int m = this.modSetBytes * 8 - 9;
            int i = this.idxBits = 32 - Integer.numberOfLeadingZeros(count - 1);
            int j = 32 - Integer.numberOfLeadingZeros(m / i);
            j = (m - j) / i;
            this.idxCountBits = 32 - Integer.numberOfLeadingZeros(j);
            this.maxIdxCount = j;
        }
    }

    public BitSet clear() {
        this.set.clear();
        return this.set;
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public boolean write(ByteBuf buf) {
        BitSet chng = this.set;
        int cc = chng.cardinality();
        if (cc == 0) {
            return false;
        }
        if (cc > this.maxIdxCount) {
            int p = buf.writerIndex() + this.modSetBytes;
            buf.writeBytes(chng.toByteArray());
            while (buf.writerIndex() < p) {
                buf.writeByte(0);
            }
        } else {
            int b = this.idxBits;
            int j = 1 + this.idxCountBits;
            int v = 1 | cc << 1;
            int i = chng.nextSetBit(1);
            while (i >= 0) {
                v |= i - 1 << j;
                if ((j += b) >= 16) {
                    buf.writeShortLE(v);
                    v >>>= 16;
                    j -= 16;
                }
                i = chng.nextSetBit(i + 1);
            }
            if (j > 8) {
                buf.writeShortLE(v);
            } else if (j > 0) {
                buf.writeByte(v);
            }
        }
        return true;
    }

    public BitSet read(ByteBuf buf) {
        int p = buf.readerIndex();
        if ((buf.getByte(p) & 1) == 0) {
            byte[] arr = new byte[this.modSetBytes];
            buf.readBytes(arr);
            this.set = BitSet.valueOf(arr);
            return this.set;
        }
        int j = this.idxCountBits + 1;
        int b = this.idxBits;
        int mask = 65535 >> 16 - b;
        int v = j <= 8 ? buf.readUnsignedByte() : buf.readUnsignedShortLE();
        int cc = (v & 65535 >> 16 - j) >> 1;
        BitSet chng = this.set;
        chng.clear();
        v >>= j;
        j = -j & 7;
        for (int i = 0; i < cc; ++i) {
            if (j < b) {
                if (j < b - 8) {
                    v |= buf.readUnsignedShortLE() << j;
                    j += 16;
                } else {
                    v |= buf.readUnsignedByte() << j;
                    j += 8;
                }
            }
            chng.set((v & mask) + 1);
            v >>= b;
            j -= b;
        }
        return chng;
    }
}

