/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.Lib;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.NetworkHandler;
import cd4017be.lib.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SyncNetworkHandler
extends NetworkHandler {
    public static final int Y_TILEENTITY = 0;
    public static final int Y_ENTITY = -1;
    public static final int Y_ITEM = -2;
    public static final int HEADERSIZE = 9;
    private static int MAX_PACKSIZE;
    public static SyncNetworkHandler instance;
    private final HashMap<ServerPlayerEntity, ByteBuf> chainedPackets = new HashMap();

    public static void register() {
        MAX_PACKSIZE = (Integer)Lib.CFG_COMMON.packet_chain_threshold.get() + 9;
        if (instance == null) {
            instance = new SyncNetworkHandler(new ResourceLocation("cd4017be_lib", "sy"));
        }
    }

    private SyncNetworkHandler(ResourceLocation channel) {
        super(channel);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        ClientPlayerEntity player = mc.field_71439_g;
        for (PacketBuffer buf : new PacketSplitter(pkt)) {
            ItemStack stack;
            Item item;
            int slot;
            BlockPos target = buf.func_179259_c();
            int y = target.func_177956_o();
            if (y >= 0) {
                TileEntity te = Utils.getTileAt((World)world, target);
                if (!(te instanceof IServerPacketReceiver)) continue;
                ((IServerPacketReceiver)te).handleServerPacket(buf);
                continue;
            }
            if (y == -1) {
                Entity entity = world.func_73045_a(target.func_177958_n() & 0xFFFF | target.func_177952_p() << 16);
                if (!(entity instanceof IServerPacketReceiver)) continue;
                ((IServerPacketReceiver)entity).handleServerPacket(buf);
                continue;
            }
            if (y != -2 || (slot = target.func_177958_n()) < 0 || slot >= player.field_71071_by.func_70302_i_() || !((item = (stack = player.field_71071_by.func_70301_a(slot)).func_77973_b()) instanceof IServerPacketReceiver.ItemSPR)) continue;
            ((IServerPacketReceiver.ItemSPR)item).handleServerPacket(stack, player, slot, buf);
        }
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        World world = sender.field_70170_p;
        for (PacketBuffer buf : new PacketSplitter(pkt)) {
            ItemStack stack;
            Item item;
            int slot;
            BlockPos target = buf.func_179259_c();
            int y = target.func_177956_o();
            if (y >= 0) {
                TileEntity te = Utils.getTileAt(world, target);
                if (!(te instanceof IPlayerPacketReceiver)) continue;
                ((IPlayerPacketReceiver)te).handlePlayerPacket(buf, sender);
                continue;
            }
            if (y == -1) {
                Entity entity = world.func_73045_a(target.func_177958_n() & 0xFFFF | target.func_177952_p() << 16);
                if (!(entity instanceof IPlayerPacketReceiver)) continue;
                ((IPlayerPacketReceiver)entity).handlePlayerPacket(buf, sender);
                continue;
            }
            if (y != -2 || (slot = target.func_177958_n()) < 0 || slot >= sender.field_71071_by.func_70302_i_() || !((item = (stack = sender.field_71071_by.func_70301_a(slot)).func_77973_b()) instanceof IPlayerPacketReceiver.ItemPPR)) continue;
            ((IPlayerPacketReceiver.ItemPPR)item).handlePlayerPacket(stack, slot, buf, sender);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.chainedPackets.isEmpty()) {
            return;
        }
        for (Map.Entry<ServerPlayerEntity, ByteBuf> e : this.chainedPackets.entrySet()) {
            super.sendToPlayer(new PacketBuffer(e.getValue()), e.getKey());
        }
        this.chainedPackets.clear();
    }

    private void addPacket(ByteBuf pkt, ServerPlayerEntity player) {
        pkt.setByte(0, pkt.readableBytes() - 9);
        this.chainedPackets.merge(player, pkt, ByteBuf::writeBytes);
    }

    @Override
    public void sendToPlayer(PacketBuffer pkt, ServerPlayerEntity player) {
        if (pkt.readableBytes() <= MAX_PACKSIZE) {
            this.addPacket((ByteBuf)pkt, player);
        } else {
            super.sendToPlayer(pkt, player);
        }
    }

    @Override
    public void sendToPlayers(PacketBuffer pkt, Collection<ServerPlayerEntity> players) {
        int l = pkt.readableBytes();
        if (l > MAX_PACKSIZE) {
            super.sendToPlayers(pkt, players);
        } else {
            pkt.setByte(0, pkt.readableBytes() - 9);
            for (ServerPlayerEntity player : players) {
                ByteBuf buf = this.chainedPackets.get(player);
                if (buf == null) {
                    this.chainedPackets.put(player, pkt.copy());
                    continue;
                }
                buf.writeBytes((ByteBuf)pkt);
            }
        }
    }

    public static PacketBuffer preparePacket(BlockPos pos) {
        PacketBuffer pkt = new PacketBuffer(Unpooled.buffer());
        pkt.writeByte(0);
        pkt.writeLong(pos.func_218275_a());
        return pkt;
    }

    public static PacketBuffer preparePacket(TileEntity tile) {
        return SyncNetworkHandler.preparePacket(tile.func_174877_v());
    }

    public static PacketBuffer preparePacket(Entity entity) {
        int id = entity.func_145782_y();
        return SyncNetworkHandler.preparePacket(new BlockPos(id & 0xFFFF, -1, id >> 16 & 0xFFFF));
    }

    public static PacketBuffer preparePacket(int slot) {
        return SyncNetworkHandler.preparePacket(new BlockPos(slot, -2, 0));
    }

    public static PacketBuffer preparePacket(PlayerEntity player, Hand hand) {
        return SyncNetworkHandler.preparePacket(new BlockPos(hand == Hand.MAIN_HAND ? 40 : player.field_71071_by.field_70461_c, -2, 0));
    }

    @Override
    protected String version() {
        return "0";
    }

    static class PacketSplitter
    implements Iterable<PacketBuffer>,
    Iterator<PacketBuffer> {
        final PacketBuffer pkt;
        boolean hasNext = true;

        public PacketSplitter(PacketBuffer pkt) {
            this.pkt = pkt;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public PacketBuffer next() {
            int size = this.pkt.readUnsignedByte();
            if (size == 0) {
                this.hasNext = false;
                return this.pkt;
            }
            int p = this.pkt.readerIndex();
            this.hasNext = this.pkt.readerIndex(p + (size += 8)).isReadable();
            return new PacketBuffer(this.pkt.slice(p, size));
        }

        @Override
        public Iterator<PacketBuffer> iterator() {
            this.pkt.readerIndex(0);
            this.hasNext = true;
            return this;
        }
    }
}

