/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.network;

import cd4017be.lib.Lib;
import cd4017be.lib.network.Encoders;
import cd4017be.lib.network.Sync;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class Synchronizer<T> {
    private static final Predicate<AccessibleObject> HAS_SYNC = o -> o.isAnnotationPresent(Sync.class);
    private static final Predicate<Method> IS_GETTER = m -> m.getReturnType() != Void.TYPE && m.getParameterTypes().length == 0;
    private static final HashMap<Class<?>, Synchronizer<?>> CACHE = new HashMap();
    public final Class<T> clazz;
    public final Encoder<T>[] variables;
    final RawComparator[] rawComps;
    final int[] indices;
    final Function<T, ?>[] objGetters;
    final ObjReader<T>[] readers;
    final Encoders.BinObjEnc[] encoders;

    public static <T> Synchronizer<T> of(Class<T> o) {
        return CACHE.computeIfAbsent(o, Synchronizer::new);
    }

    private Synchronizer(Class<T> c) {
        this.clazz = c;
        Triple lists = Stream.concat(Arrays.stream(c.getFields()).filter(HAS_SYNC).map(StateVariable::new), Arrays.stream(c.getMethods()).filter(HAS_SYNC).filter(IS_GETTER).map(StateVariable::new)).filter(StateVariable::valid).sorted().collect(() -> Triple.of(new ArrayList(), new ArrayList(), new ArrayList()), (l, sv) -> sv.process(l), (a, b) -> {
            ((List)a.getLeft()).addAll((Collection)b.getLeft());
            ((List)a.getMiddle()).addAll((Collection)b.getMiddle());
            ((List)a.getRight()).addAll((Collection)b.getRight());
        });
        List list = (List)lists.getLeft();
        this.variables = list.toArray(new Encoder[list.size()]);
        list = (List)lists.getMiddle();
        this.readers = new ObjReader[list.size() + ((List)lists.getRight()).size()];
        this.rawComps = new RawComparator[list.size()];
        this.indices = new int[list.size() + 1];
        int j = 0;
        for (int i = 0; i < this.rawComps.length; ++i) {
            Triple triple = (Triple)list.get(i);
            this.rawComps[i] = (RawComparator)triple.getLeft();
            this.readers[i] = (ObjReader)triple.getMiddle();
            this.indices[i + 1] = j += ((Integer)triple.getRight()).intValue();
        }
        list = (List)lists.getRight();
        this.objGetters = new Function[list.size()];
        this.encoders = new Encoders.BinObjEnc[list.size()];
        for (int i = 0; i < this.objGetters.length; ++i) {
            Triple e = (Triple)list.get(i);
            Function function = (Function)e.getLeft();
            BiConsumer set = (BiConsumer)e.getMiddle();
            Encoders.BinObjEnc enc = (Encoders.BinObjEnc)e.getRight();
            this.objGetters[i] = function;
            this.encoders[i] = enc;
            this.readers[i + this.rawComps.length] = Synchronizer.reader(function, enc, set);
        }
        if (Lib.DEV_DEBUG) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isPublic(field.getModifiers()) || !field.isAnnotationPresent(Sync.class)) continue;
                Lib.LOG.fatal("invalid @Sync {} in {}, must be public!", (Object)field.getName(), (Object)c.getName());
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !accessibleObject.isAnnotationPresent(Sync.class)) continue;
                Lib.LOG.fatal("invalid @Sync {} in {}, must be public!", (Object)((Method)accessibleObject).getName(), (Object)c.getName());
            }
        }
    }

    static <T, U> ObjReader<T> reader(Function<T, U> get, Encoders.BinObjEnc<U> enc, BiConsumer<T, U> set) {
        if (set != null) {
            return (o, pkt) -> set.accept(o, enc.decode(get.apply(o), pkt));
        }
        return (o, pkt) -> enc.update(get.apply(o), pkt);
    }

    public void writeNBT(Object o, CompoundNBT nbt, int mode) {
        T obj = this.clazz.cast(o);
        for (Encoder<T> enc : this.variables) {
            enc.writeNBT(obj, nbt, mode);
        }
    }

    public void readNBT(Object o, CompoundNBT nbt, int mode) {
        T obj = this.clazz.cast(o);
        for (Encoder<T> enc : this.variables) {
            enc.readNBT(obj, nbt, mode);
        }
    }

    public int rawSize() {
        return this.indices[this.indices.length - 1];
    }

    public int objSize() {
        return this.objGetters.length;
    }

    public ByteBuffer rawState() {
        return ByteBuffer.allocate(this.rawSize());
    }

    public Object[] objState() {
        return new Object[this.objGetters.length];
    }

    public int syncVariables() {
        return this.rawComps.length + this.objGetters.length;
    }

    public int varIndex(String name) {
        for (Encoder<T> var : this.variables) {
            if (!var.tag.equals(name) || var.index < 0) continue;
            return var.index;
        }
        return -1;
    }

    public void detectChanges(Object o, ByteBuffer rawState, Object[] objState, int j0, BitSet changes, int i0) {
        T obj = this.clazz.cast(o);
        for (RawComparator cmp : this.rawComps) {
            if (cmp.hasChanged(obj, rawState)) {
                changes.set(i0);
            }
            ++i0;
        }
        int i = 0;
        while (i < this.objGetters.length) {
            if (this.encoders[i].hasChanged(this.objGetters[i].apply(obj), objState, j0)) {
                changes.set(i0);
            }
            ++i;
            ++i0;
            ++j0;
        }
    }

    public void writeChanged(PacketBuffer pkt, ByteBuffer rawState, Object[] objState, int j0, BitSet changes, int i0) {
        int j;
        int i;
        int i1 = i0 + this.indices.length;
        int p0 = rawState.position();
        for (i = i0; i < i1 && (j = changes.nextSetBit(i)) >= 0; ++i) {
            i = changes.nextClearBit(j + 1);
            if (i >= i1) {
                i = i1 - 1;
            }
            rawState.limit(p0 + this.indices[i - i0]);
            rawState.position(p0 + this.indices[j - i0]);
            pkt.writeBytes(rawState);
        }
        rawState.clear().position(p0 + this.rawSize());
        i = changes.nextSetBit(--i1);
        while (i >= 0) {
            j = i - i1;
            this.encoders[j].encode(objState[j0 + j], pkt);
            i = changes.nextSetBit(i + 1);
        }
    }

    public void readChanges(PacketBuffer pkt, ByteBuffer rawState, Object[] objState, int j0, BitSet changes, int i0) throws IOException {
        int j;
        int i;
        int i1 = i0 + this.indices.length;
        int p0 = rawState.position();
        for (i = i0; i < i1 && (j = changes.nextSetBit(i)) >= 0; ++i) {
            i = changes.nextClearBit(j + 1);
            if (i >= i1) {
                i = i1 - 1;
            }
            rawState.limit(p0 + this.indices[i - i0]);
            rawState.position(p0 + this.indices[j - i0]);
            pkt.readBytes(rawState);
        }
        rawState.clear().position(p0 + this.rawSize());
        i = changes.nextSetBit(--i1);
        while (i >= 0) {
            j = i - i1;
            int k = j + j0;
            objState[k] = this.encoders[j].decode(objState[k], pkt);
            i = changes.nextSetBit(i + 1);
        }
    }

    public void updateChanges(Object o, PacketBuffer pkt, BitSet changes, int i0) throws IOException {
        T obj = this.clazz.cast(o);
        int i1 = i0 + this.syncVariables();
        int i = changes.nextSetBit(i0);
        while (i >= 0 && i < i1) {
            this.readers[i - i0].read(obj, pkt);
            i = changes.nextSetBit(i + 1);
        }
    }

    private static class StateVariable<T>
    implements Comparable<StateVariable<T>> {
        final Sync annotation;
        MethodHandle getter;
        MethodHandle setter;
        Class<?> type;
        String name;

        public StateVariable(Field f) {
            this.annotation = f.getAnnotation(Sync.class);
            this.name = f.getName();
            this.type = f.getType();
            try {
                MethodHandles.Lookup l = MethodHandles.publicLookup();
                this.getter = l.unreflectGetter(f);
                if (this.annotation.type() == Sync.Type.Fix) {
                    return;
                }
                try {
                    Method m = f.getDeclaringClass().getMethod(this.name, this.type);
                    if (m.isAnnotationPresent(Sync.class)) {
                        this.setter = l.unreflect(m);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (this.setter == null && !Modifier.isFinal(f.getModifiers())) {
                    this.setter = l.unreflectSetter(f);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public StateVariable(Method m) {
            this.annotation = m.getAnnotation(Sync.class);
            this.name = m.getName();
            this.type = m.getReturnType();
            try {
                MethodHandles.Lookup l = MethodHandles.publicLookup();
                this.getter = l.unreflect(m);
                if (this.annotation.type() == Sync.Type.Fix) {
                    return;
                }
                Class<?> c = m.getDeclaringClass();
                m = c.getMethod(this.name, this.type);
                this.setter = l.unreflect(m);
            }
            catch (NoSuchMethodException l) {
            }
            catch (IllegalAccessException | SecurityException e) {
                e.printStackTrace();
            }
        }

        public void process(Triple<List<Encoder<T>>, List<Triple<RawComparator, ObjReader<T>, Integer>>, List<Triple<Function<T, ?>, BiConsumer<T, ?>, Encoders.BinObjEnc<?>>>> l) {
            Pair enc_dec;
            int mask = this.annotation.to();
            int index = -1;
            Sync.Type t = this.annotation.type().actual(this.type);
            this.getter = MethodHandles.explicitCastArguments(this.getter, MethodType.methodType(t.inType, Object.class));
            if (this.setter != null) {
                this.setter = MethodHandles.explicitCastArguments(this.setter, MethodType.methodType(Void.class, Object.class, t.inType));
            }
            if (t == Sync.Type.Obj) {
                Encoders<?> enc = Encoders.of(this.type);
                Function get = MethodHandleProxies.asInterfaceInstance(Function.class, this.getter);
                if (enc == null) {
                    Synchronizer<?> s = Synchronizer.of(this.type);
                    if (s.variables.length > 0) {
                        ((List)l.getLeft()).add(new EncoderChild(mask, index, this.tag(), s, get));
                    } else {
                        Lib.LOG.warn("{} of type {} has no registered serialization and no @Sync variables!", (Object)this.name, this.type);
                    }
                    return;
                }
                BiConsumer set = this.setter == null ? null : MethodHandleProxies.asInterfaceInstance(BiConsumer.class, this.setter);
                enc_dec = enc.compose(get, set);
                if (mask < 0) {
                    if (enc.binary != null) {
                        index = ((List)l.getRight()).size();
                        ((List)l.getRight()).add(Triple.of((Object)get, (Object)set, enc.binary));
                    } else {
                        Lib.LOG.error("Failed to handle @Sync(on = GUI) {}:\nBinary serialization not supported for {}!", (Object)this.name, this.type);
                    }
                }
            } else {
                Object[] enums = this.type.getEnumConstants();
                enc_dec = Pair.of((Object)MethodHandleProxies.asInterfaceInstance(Function.class, MethodHandles.collectArguments(t.write, 0, this.getter)), this.setter == null ? null : MethodHandleProxies.asInterfaceInstance(BiConsumer.class, MethodHandles.collectArguments(this.setter, 1, t.read(enums))));
                if (mask < 0) {
                    index = ((List)l.getMiddle()).size();
                    ((List)l.getMiddle()).add(Triple.of((Object)MethodHandleProxies.asInterfaceInstance(RawComparator.class, MethodHandles.collectArguments(t.comp, 0, this.getter)), this.setter == null ? null : MethodHandleProxies.asInterfaceInstance(ObjReader.class, MethodHandles.collectArguments(this.setter, 1, t.update(enums))), (Object)t.size));
                }
            }
            if (enc_dec.getLeft() == null && mask != Integer.MIN_VALUE) {
                Lib.LOG.error("Failed to handle @Sync {}:\nNBT serialization not supported for {}!", (Object)this.name, this.type);
            } else if (enc_dec.getRight() == null && mask != Integer.MIN_VALUE) {
                Lib.LOG.error("Failed to handle @Sync {}:\nField can't be final, in-place write not supported for {}!", (Object)this.name, this.type);
            } else {
                ((List)l.getLeft()).add(new EncoderNBT(mask, index, this.tag(), enc_dec));
            }
        }

        private String tag() {
            return this.annotation.tag().isEmpty() ? this.name : this.annotation.tag();
        }

        @Override
        public int compareTo(StateVariable<T> o) {
            return this.name.compareTo(o.name);
        }

        public boolean valid() {
            return this.getter != null;
        }
    }

    @FunctionalInterface
    public static interface ObjReader<T> {
        public void read(T var1, PacketBuffer var2) throws IOException;
    }

    @FunctionalInterface
    public static interface RawComparator {
        public boolean hasChanged(Object var1, ByteBuffer var2);
    }

    public static class EncoderChild<T, U>
    extends Encoder<T> {
        final Synchronizer<U> sync;
        final Function<T, U> getter;

        EncoderChild(int flags, int index, String tag, Synchronizer<U> s, Function<T, U> getter) {
            super(flags, index, tag);
            this.sync = s;
            this.getter = getter;
        }

        @Override
        public void writeNBT(T o, CompoundNBT nbt, int mode) {
            if ((this.flags & mode) == 0) {
                return;
            }
            CompoundNBT sub = new CompoundNBT();
            this.sync.writeNBT(this.getter.apply(o), sub, mode);
            nbt.func_218657_a(this.tag, (INBT)sub);
        }

        @Override
        public void readNBT(T o, CompoundNBT nbt, int mode) {
            if ((this.flags & mode) == 0) {
                return;
            }
            this.sync.readNBT(this.getter.apply(o), nbt.func_74775_l(this.tag), mode);
        }
    }

    public static class EncoderNBT<T>
    extends Encoder<T> {
        final Function<T, INBT> encoder;
        final BiConsumer<T, INBT> decoder;

        public EncoderNBT(int flags, int index, String tag, Pair<Function<T, INBT>, BiConsumer<T, INBT>> enc_dec) {
            super(flags, index, tag);
            this.encoder = (Function)enc_dec.getLeft();
            this.decoder = (BiConsumer)enc_dec.getRight();
        }

        @Override
        public void writeNBT(T o, CompoundNBT nbt, int mode) {
            if ((this.flags & mode) == 0) {
                return;
            }
            INBT nb = this.encoder.apply(o);
            if (nb != null) {
                nbt.func_218657_a(this.tag, nb);
            }
        }

        @Override
        public void readNBT(T o, CompoundNBT nbt, int mode) {
            if ((this.flags & mode) == 0) {
                return;
            }
            this.decoder.accept(o, nbt.func_74781_a(this.tag));
        }
    }

    static abstract class Encoder<T> {
        final int flags;
        final int index;
        final String tag;

        Encoder(int flags, int index, String tag) {
            this.flags = flags;
            this.index = index;
            this.tag = tag;
        }

        public abstract void writeNBT(T var1, CompoundNBT var2, int var3);

        public abstract void readNBT(T var1, CompoundNBT var2, int var3);
    }
}

