/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.lib.Content;
import cd4017be.lib.item.MicroBlockItem;
import cd4017be.lib.render.MicroBlockFace;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MicroBlock
extends GridPart {
    public BlockState block;
    private CompoundNBT tag;

    public MicroBlock() {
        super(0);
    }

    public MicroBlock(BlockState block, CompoundNBT tag, long bounds) {
        this();
        this.block = block;
        this.tag = tag;
        this.bounds = bounds;
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        nbt.func_74772_a("m", this.bounds);
        nbt.func_74768_a("s", Block.func_196246_j((BlockState)this.block));
        if ((mode & 1) != 0) {
            nbt.func_218657_a("t", (INBT)this.tag);
        }
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        this.bounds = nbt.func_74763_f("m");
        this.block = Block.func_196257_b((int)nbt.func_74762_e("s"));
        this.tag = nbt.func_74775_l("t");
    }

    @Override
    public Object getHandler(int port) {
        return null;
    }

    @Override
    public void setHandler(int port, Object handler) {
    }

    @Override
    public boolean isMaster(int channel) {
        return false;
    }

    @Override
    public MicroBlockItem item() {
        return Content.microblock;
    }

    @Override
    public ItemStack asItemStack() {
        ItemStack stack;
        if (!this.tag.isEmpty()) {
            stack = super.asItemStack();
            stack.func_77982_d(this.tag);
        } else {
            stack = this.item().wrap(this.block.func_177230_c().func_185473_a((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, this.block), this.block, 1);
        }
        stack.func_190920_e(Long.bitCount(this.bounds));
        return stack;
    }

    @Override
    public byte getLayer() {
        return 1;
    }

    @Override
    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        if (hand != null) {
            return ActionResultType.PASS;
        }
        if (!player.field_70170_p.field_72995_K && player.func_184614_ca().func_77973_b() instanceof IGridItem) {
            long b = this.bounds & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
            if (b == 0L) {
                IGridHost host = this.host;
                host.removePart(this);
                host.removeIfEmpty();
            } else {
                this.setBounds(b);
            }
            if (!player.func_184812_l_()) {
                ItemStack stack = new ItemStack((IItemProvider)this.item());
                stack.func_77982_d(this.tag);
                ItemFluidUtil.dropStack(stack, (Entity)player);
            }
        }
        return ActionResultType.CONSUME;
    }

    public boolean addVoxel(int pos) {
        if (this.host.getPart(pos, (byte)1) != null) {
            return false;
        }
        this.setBounds(this.bounds | 1L << pos);
        return true;
    }

    @Override
    public int analogOutput(Direction side) {
        return this.block.func_185911_a((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, side);
    }

    @Override
    public boolean connectRedstone(Direction side) {
        return this.block.canConnectRedstone((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, side);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillModel(JitBakedModel model, long opaque) {
        MicroBlockFace.drawVoxels(model, this.block, this.bounds, opaque);
    }

    @Override
    public boolean merge(IGridHost host) {
        MicroBlock part = (MicroBlock)host.findPart(p -> p instanceof MicroBlock && ((MicroBlock)p).block == this.block);
        if (part == null) {
            return true;
        }
        part.bounds |= this.bounds;
        return false;
    }

    @Override
    public boolean canMove(Direction d, int n) {
        return true;
    }

    @Override
    protected GridPart copy(long bounds) {
        return new MicroBlock(this.block, this.tag, bounds);
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    @Override
    public void rotate(int steps) {
        this.block = this.block.func_185907_a(Rotation.values()[steps]);
        super.rotate(steps);
    }
}

