/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.part;

import cd4017be.api.grid.GridPart;
import cd4017be.lib.network.Sync;
import cd4017be.lib.render.GridModels;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.util.Orientation;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class OrientedPart
extends GridPart {
    @Sync(to=7, type=Sync.Type.Enum)
    public Orientation orient;
    @Sync(to=7)
    public byte pos;

    public OrientedPart(int ports) {
        super(ports);
    }

    public void set(int pos, Orientation orient) {
        this.pos = (byte)pos;
        this.orient = orient;
    }

    protected void setPort(int i, int pos, Direction dir, int type) {
        this.ports[i] = OrientedPart.port(this.orient, pos, dir, type);
    }

    protected void setBounds(int p0, int p1) {
        this.bounds = OrientedPart.bounds(OrientedPart.pos(p0, this.orient), OrientedPart.pos(p1, this.orient));
    }

    public static short port(Orientation orient, int pos, Direction dir, int type) {
        return OrientedPart.port(OrientedPart.pos(pos, orient), orient.apply(dir), type);
    }

    public static int pos(int pos, Orientation orient) {
        int o = orient.o;
        return ((pos ^= (o & 1 | o >> 2 & 4 | o >> 4 & 0x10) * 3) & 3) << (o & 6) | (pos >> 2 & 3) << (o >> 4 & 6) | (pos >> 4 & 3) << (o >> 8 & 6);
    }

    protected boolean onEdge() {
        return (this.bounds & FACES[this.orient.b.ordinal() ^ 1]) != 0L;
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        this.set(this.pos, this.orient);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ResourceLocation model() {
        return new ModelResourceLocation(this.item().getRegistryName(), "inventory");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillModel(JitBakedModel model, long opaque) {
        GridModels.putCube(this.model(), model, this.bounds, opaque, this.pos, this.orient.o);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void transform(MatrixStack ms) {
        ms.func_227866_c_().func_227870_a_().func_226595_a_(this.orient.mat4);
        ms.func_227866_c_().func_227872_b_().func_226118_b_(this.orient.mat3);
        ms.func_227861_a_((double)((float)(this.pos & 3) * 0.25f), (double)((float)(this.pos >> 2 & 3) * 0.25f), (double)((float)(this.pos >> 4 & 3) * 0.25f));
    }

    @Override
    public boolean canRotate() {
        return true;
    }

    @Override
    public void rotate(int steps) {
        Orientation o;
        switch (steps & 3) {
            case 1: {
                o = Orientation.W12;
                break;
            }
            case 2: {
                o = Orientation.N12;
                break;
            }
            case 3: {
                o = Orientation.E12;
                break;
            }
            default: {
                return;
            }
        }
        this.set(this.pos, o.apply(this.orient));
    }

    @Override
    public boolean canMove(Direction d, int n) {
        long m = OrientedPart.mask(d.ordinal(), n);
        return (this.bounds & m) == 0L || (this.bounds & (m ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    @Override
    public GridPart move(Direction d, int n) {
        d = this.orient.inv().apply(d);
        int x = (this.pos & 3) + d.func_82601_c() * n;
        int y = (this.pos >> 2 & 3) + d.func_96559_d() * n;
        int z = (this.pos >> 4 & 3) + d.func_82599_e() * n;
        this.set(x & 3 | (y & 3) << 2 | (z & 3) << 4 | this.pos & 0xC0, this.orient);
        return ((x | y | z) & 0xFFFFFFFC) == 0 ? null : this;
    }
}

