/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.lib.Lib;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.util.Orientation;
import cd4017be.math.Linalg;
import cd4017be.math.Orient;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class GridModels {
    private static final Random RAND = new Random();
    public static final ModelManager MODELS = Minecraft.func_71410_x().func_209506_al();
    public static final ResourceLocation[] PORTS;
    private static final int[] ORIENTS;
    private static final float _255 = 0.003921569f;

    public static void drawPort(JitBakedModel model, short port, boolean master, long b, long opaque) {
        boolean outer;
        int p = IGridHost.posOfport(port);
        int q = IGridHost.posOfport(port - 273);
        int o = Integer.numberOfTrailingZeros(0x111 & ~port) >> 1 & 6;
        if (o >= 6 || p >= 0 && q >= 0 && ((opaque |= b) >> p & opaque >> q & 1L) != 0L) {
            return;
        }
        boolean bl = outer = p < 0 || q < 0;
        if (p < 0 || (b >> p & 1L) == 0L) {
            if (q < 0 || (b >> q & 1L) == 0L) {
                return;
            }
            p = q;
            o |= 1;
        }
        o = ORIENTS[o];
        float[] vec = Linalg.dadd(3, Linalg.sca(3, GridPart.vec(p), 0.25f), -0.375f);
        Orient.orient(Orient.inv(o), vec);
        Orient.origin(o, Linalg.dadd(3, vec, 0.375f), 0.5f, 0.5f, 0.5f);
        GridModels.addOriented(outer ? model.quads[Orient.orient(o, 3)] : model.inner(), MODELS.getModel(PORTS[port >> 11 & 0xE | (master ? 1 : 0)]), null, o, vec);
    }

    public static void putCube(ResourceLocation key, JitBakedModel model, long b, long opaque, int ofs, int orient) {
        IBakedModel faces = MODELS.getModel(key);
        float[] v = GridModels.originOf(orient, ofs);
        if ((b & (opaque ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            GridModels.addOriented(model.inner(), faces, null, orient, v);
        }
        opaque = (opaque | b) ^ 0xFFFFFFFFFFFFFFFFL;
        for (int i = 0; i < 6; ++i) {
            ArrayList<BakedQuad> quads;
            int j = Orient.orient(orient, i);
            if ((b & GridPart.FACES[j]) != 0L) {
                quads = model.quads[j];
            } else {
                int s = GridPart.step(j);
                if ((((j & 1) != 0 ? b << s : b >>> s) & opaque) == 0L) continue;
                quads = model.inner();
            }
            GridModels.addOriented(quads, faces, Direction.func_82600_a((int)i), orient, v);
        }
    }

    public static void addOriented(ArrayList<BakedQuad> dest, IBakedModel model, Direction face, int o, float[] v) {
        for (BakedQuad quad : model.getQuads(null, face, RAND, (IModelData)EmptyModelData.INSTANCE)) {
            dest.add(Orient.orient(o, quad, v));
        }
    }

    private static float[] originOf(int orient, int ofs) {
        return Orient.origin(orient, Linalg.sca(3, GridPart.vec(ofs), 0.25f), 0.5f, 0.5f, 0.5f);
    }

    public static void draw(ResourceLocation key, MatrixStack.Entry mat, IVertexBuilder vb, int color, int light, int overlay) {
        float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
        float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
        float b = (float)(color & 0xFF) * 0.003921569f;
        float a = (float)(color >>> 24) * 0.003921569f;
        for (BakedQuad quad : MODELS.getModel(key).getQuads(null, null, RAND, (IModelData)EmptyModelData.INSTANCE)) {
            vb.addVertexData(mat, quad, r, g, b, a, light, overlay);
        }
    }

    static {
        ResourceLocation obj_p = Lib.rl("part/obj_p");
        ResourceLocation obj_u = Lib.rl("part/obj_u");
        PORTS = new ResourceLocation[]{Lib.rl("part/data_in"), Lib.rl("part/data_out"), Lib.rl("part/power_p"), Lib.rl("part/power_u"), Lib.rl("part/item_p"), Lib.rl("part/item_u"), Lib.rl("part/fluid_p"), Lib.rl("part/fluid_u"), obj_p, obj_u, obj_p, obj_u, obj_p, obj_u, obj_p, obj_u};
        ORIENTS = new int[]{Orientation.W12.o, Orientation.E12.o, Orientation.DS.o, Orientation.UN.o, Orientation.N12.o, Orientation.S12.o};
    }
}

