/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.api.grid.GridPart;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.render.model.TileEntityModel;
import cd4017be.lib.render.model.WrappedBlockModel;
import cd4017be.math.Linalg;
import cd4017be.math.MCConv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class MicroBlockFace {
    private final BakedQuad quad;
    private final float[] u;
    private final float[] v;
    private final int ax;
    private static final HashMap<Object, MicroBlockFace[]> MODEL_CACHE = new HashMap();

    public MicroBlockFace(BakedQuad quad) {
        this.quad = quad;
        this.ax = quad.func_178210_d().func_176740_k().ordinal();
        int[] data = quad.func_178209_a();
        int stride = data.length >> 2;
        float[][] mat = new float[3][5];
        for (int i = 0; i < 3; ++i) {
            float[] row = mat[i];
            MCConv.intBitsToVec(3, row, 0, data, i * stride);
            MCConv.intBitsToVec(2, row, 3, data, i * stride + 4);
            row[this.ax] = 1.0f;
        }
        Linalg.solveGauss(mat, 3, 5);
        this.u = Linalg.col(3, new float[3], mat, 3);
        this.v = Linalg.col(3, new float[3], mat, 4);
    }

    public static void drawVoxels(JitBakedModel model, Object key, long b, long opaque) {
        MicroBlockFace[] faces = MicroBlockFace.facesOf(key);
        opaque |= b;
        ArrayList<BakedQuad> quads = model.inner();
        for (int i = 0; i < 6; ++i) {
            MicroBlockFace face = faces[i];
            if (face == null) continue;
            int s = GridPart.step(i);
            long f = (i & 1) != 0 ? b & (opaque >>> s ^ 0xFFFFFFFFFFFFFFFFL) : b >>> s & (opaque ^ 0xFFFFFFFFFFFFFFFFL);
            long m = GridPart.FACES[i & 6];
            int j = 1;
            while (j < 4) {
                face.addFaces(quads, f & m, j - (i & 1));
                ++j;
                f >>>= s;
            }
            f = b & GridPart.FACES[i];
            if (f == 0L) continue;
            if ((i & 1) != 0) {
                f >>>= s * 3;
            }
            face.addFaces(model.quads[i], f, (i & 1) * 3);
        }
    }

    public List<BakedQuad> addFaces(List<BakedQuad> quads, long mask, float layer) {
        int s;
        int sv;
        int su = this.ax == 0 ? 4 : 1;
        int n = sv = this.ax == 2 ? 4 : 16;
        while ((s = Long.numberOfTrailingZeros(mask)) < 64) {
            long not;
            int e;
            int i = (s | sv - 1) + 1;
            long strip = 1L << s;
            for (e = s + su; e < i && (mask >>> e & 1L) != 0L; e += su) {
                strip |= 1L << e;
            }
            mask &= strip ^ 0xFFFFFFFFFFFFFFFFL;
            long l = not = s + sv > i && e < i ? (strip <<= sv) << 1 | strip >>> 1 : 0L;
            while ((strip & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L && (not & (mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                mask &= strip ^ 0xFFFFFFFFFFFFFFFFL;
                strip <<= sv;
                not <<= sv;
                e += sv;
            }
            float[] p0 = GridPart.vec(s);
            float[] size = Linalg.dadd(3, GridPart.vec(e -= s + su), 1.0f);
            int n2 = this.ax;
            p0[n2] = p0[n2] + layer;
            Linalg.sca(3, p0, 0.25f);
            Linalg.sca(3, size, 0.25f);
            quads.add(this.makeRect(p0, size));
        }
        return quads;
    }

    public BakedQuad makeRect(float[] p0, float[] size) {
        float[] vec = new float[3];
        int[] data = (int[])this.quad.func_178209_a().clone();
        int stride = data.length >> 2;
        int j = 0;
        int i = 0;
        while (j < 4) {
            MCConv.intBitsToVec(3, vec, 0, data, i);
            Linalg.mul(3, vec, size);
            Linalg.add(3, vec, p0);
            MCConv.vecToIntBits(3, vec, data, i);
            vec[this.ax] = 1.0f;
            data[i + 4] = Float.floatToRawIntBits(Linalg.dot(3, vec, this.u));
            data[i + 5] = Float.floatToRawIntBits(Linalg.dot(3, vec, this.v));
            ++j;
            i += stride;
        }
        return new BakedQuad(data, this.quad.func_178211_c(), this.quad.func_178210_d(), this.quad.func_187508_a(), this.quad.func_239287_f_());
    }

    public static MicroBlockFace[] facesOf(Object key) {
        return MODEL_CACHE.computeIfAbsent(key, MicroBlockFace::create);
    }

    private static MicroBlockFace[] create(Object key) {
        Random rand = new Random();
        BlockState block = key instanceof BlockState ? (BlockState)key : null;
        IBakedModel model = block != null ? WrappedBlockModel.MODELS.func_178125_b(block) : WrappedBlockModel.MODELS.func_178126_b().getModel((ResourceLocation)key);
        MicroBlockFace[] faces = new MicroBlockFace[6];
        for (Direction d : Direction.values()) {
            rand.setSeed(42L);
            List quads = model.getQuads(block, d, rand, (IModelData)EmptyModelData.INSTANCE);
            if (quads.isEmpty()) continue;
            faces[d.ordinal()] = new MicroBlockFace((BakedQuad)quads.get(0));
        }
        return faces;
    }

    static {
        TileEntityModel.registerCacheInvalidate(MODEL_CACHE::clear);
    }
}

