/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render;

import cd4017be.lib.util.Orientation;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class Util {
    public static final FloatBuffer[] matrices = new FloatBuffer[16];
    public static final Util instance;
    public static int RenderFrame;

    public static void moveAndOrientToBlock(double x, double y, double z, Orientation o) {
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        FloatBuffer mat = matrices[o.ordinal()];
        mat.rewind();
        GL11.glMultMatrixf((FloatBuffer)mat);
    }

    public static void rotateTo(Orientation o) {
        FloatBuffer mat = matrices[o.ordinal()];
        mat.rewind();
        GL11.glMultMatrixf((FloatBuffer)mat);
    }

    @Deprecated
    public static void luminate(TileEntity te, Direction side, int b) {
        throw new UnsupportedOperationException();
    }

    public static int rotateNormal(int n, ModelRotation rot) {
        switch (rot) {
            default: {
                return n;
            }
            case X0_Y90: {
                return n & 0xFF00 | n << 16 & 0xFF0000 | ~n >> 16 & 0xFF;
            }
            case X0_Y180: {
                return n ^ 0xFF00FF;
            }
            case X0_Y270: {
                return n & 0xFF00 | ~n << 16 & 0xFF0000 | n >> 16 & 0xFF;
            }
            case X90_Y0: {
                return n & 0xFF | ~n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
            }
            case X90_Y90: {
                return n << 16 & 0xFF0000 | n >> 8 & 0xFFFF;
            }
            case X90_Y180: {
                return ~n & 0xFF | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
            }
            case X90_Y270: {
                return ~n << 16 & 0xFF0000 | (n ^ 0xFF00) >> 8 & 0xFFFF;
            }
            case X180_Y0: {
                return n ^ 0xFFFF00;
            }
            case X180_Y90: {
                return ~n & 0xFF00 | n << 16 & 0xFF0000 | n >> 16 & 0xFF;
            }
            case X180_Y180: {
                return n ^ 0xFFFF;
            }
            case X180_Y270: {
                return ~n & 0xFF00 | ~n << 16 & 0xFF0000 | ~n >> 16 & 0xFF;
            }
            case X270_Y0: {
                return n & 0xFF | n << 8 & 0xFF0000 | ~n >> 8 & 0xFF00;
            }
            case X270_Y90: {
                return n << 16 & 0xFF0000 | ~n >> 8 & 0xFFFF;
            }
            case X270_Y180: {
                return ~n & 0xFF | ~n << 8 & 0xFF0000 | ~n >> 8 & 0xFF00;
            }
            case X270_Y270: 
        }
        return ~n << 16 & 0xFF0000 | (n ^ 0xFF0000) >> 8 & 0xFFFF;
    }

    public static void rotate(int[] data, int px, ModelRotation rot) {
        int py = px + 1;
        int pz = px + 2;
        switch (rot) {
            case X0_Y0: {
                return;
            }
            case X0_Y90: {
                int i = data[pz];
                data[pz] = data[px];
                data[px] = Util.neg(i);
                return;
            }
            case X0_Y180: {
                data[px] = Util.neg(data[px]);
                data[pz] = Util.neg(data[pz]);
                return;
            }
            case X0_Y270: {
                int i = data[px];
                data[px] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X90_Y0: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X90_Y90: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = data[px];
                data[px] = i;
                return;
            }
            case X90_Y180: {
                int i = data[py];
                data[py] = data[pz];
                data[pz] = i;
                data[px] = Util.neg(data[px]);
                return;
            }
            case X90_Y270: {
                int i = data[px];
                data[px] = Util.neg(data[py]);
                data[py] = data[pz];
                data[pz] = Util.neg(i);
                return;
            }
            case X180_Y0: {
                data[py] = Util.neg(data[py]);
                data[pz] = Util.neg(data[pz]);
                return;
            }
            case X180_Y90: {
                data[py] = Util.neg(data[py]);
                int i = data[pz];
                data[pz] = data[px];
                data[px] = i;
                return;
            }
            case X180_Y180: {
                data[px] = Util.neg(data[px]);
                data[py] = Util.neg(data[py]);
                return;
            }
            case X180_Y270: {
                data[py] = Util.neg(data[py]);
                int i = data[px];
                data[px] = Util.neg(data[pz]);
                data[pz] = Util.neg(i);
                return;
            }
            case X270_Y0: {
                int i = data[pz];
                data[pz] = data[py];
                data[py] = Util.neg(i);
                return;
            }
            case X270_Y90: {
                int i = data[py];
                data[py] = Util.neg(data[pz]);
                data[pz] = data[px];
                data[px] = Util.neg(i);
                return;
            }
            case X270_Y180: {
                int i = data[pz];
                data[pz] = Util.neg(data[py]);
                data[py] = Util.neg(i);
                data[px] = Util.neg(data[px]);
                return;
            }
            case X270_Y270: {
                int i = data[pz];
                data[pz] = Util.neg(data[px]);
                data[px] = data[py];
                data[py] = Util.neg(i);
                return;
            }
        }
    }

    private static int neg(int i) {
        return Float.floatToRawIntBits(1.0f - Float.intBitsToFloat(i));
    }

    private Util() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        ++RenderFrame;
    }

    public static int[] texturedRect(float x, float y, float z, float w, float h, float tx, float ty, float tw, float th) {
        return new int[]{Float.floatToIntBits(x), Float.floatToIntBits(y), Float.floatToIntBits(z), Float.floatToIntBits(tx), Float.floatToIntBits(ty), Float.floatToIntBits(x + w), Float.floatToIntBits(y), Float.floatToIntBits(z), Float.floatToIntBits(tx + tw), Float.floatToIntBits(ty), Float.floatToIntBits(x + w), Float.floatToIntBits(y + h), Float.floatToIntBits(z), Float.floatToIntBits(tx + tw), Float.floatToIntBits(ty + th), Float.floatToIntBits(x), Float.floatToIntBits(y + h), Float.floatToIntBits(z), Float.floatToIntBits(tx), Float.floatToIntBits(ty + th)};
    }

    public static int[] texturedRect(Vector3d p, Vector3d w, Vector3d h, Vector2f t0, Vector2f t1, int color, int light) {
        return new int[]{Float.floatToIntBits((float)p.field_72450_a), Float.floatToIntBits((float)p.field_72448_b), Float.floatToIntBits((float)p.field_72449_c), color, Float.floatToIntBits(t0.field_189982_i), Float.floatToIntBits(t0.field_189983_j), light, Float.floatToIntBits((float)(p.field_72450_a + w.field_72450_a)), Float.floatToIntBits((float)(p.field_72448_b + w.field_72448_b)), Float.floatToIntBits((float)(p.field_72449_c + w.field_72449_c)), color, Float.floatToIntBits(t1.field_189982_i), Float.floatToIntBits(t0.field_189983_j), light, Float.floatToIntBits((float)(p.field_72450_a + w.field_72450_a + h.field_72450_a)), Float.floatToIntBits((float)(p.field_72448_b + w.field_72448_b + h.field_72448_b)), Float.floatToIntBits((float)(p.field_72449_c + w.field_72449_c + h.field_72449_c)), color, Float.floatToIntBits(t1.field_189982_i), Float.floatToIntBits(t1.field_189983_j), light, Float.floatToIntBits((float)(p.field_72450_a + h.field_72450_a)), Float.floatToIntBits((float)(p.field_72448_b + h.field_72448_b)), Float.floatToIntBits((float)(p.field_72449_c + h.field_72449_c)), color, Float.floatToIntBits(t0.field_189982_i), Float.floatToIntBits(t1.field_189983_j), light};
    }

    public static Vector2f getUV(TextureAtlasSprite tex, float u, float v) {
        return new Vector2f(tex.func_94214_a((double)u), tex.func_94207_b((double)v));
    }

    @Deprecated
    public static int[] extractData(BufferBuilder b, int from, int to) {
        int l = b.getVertexFormat().func_181719_f();
        int[] arr = new int[(to *= l) - (from *= l)];
        ByteBuffer bb = (ByteBuffer)b.func_227832_f_().getSecond();
        int p = bb.position();
        bb.position(from * 4);
        IntBuffer ib = bb.asIntBuffer();
        ib.get(arr);
        bb.position(p);
        return arr;
    }

    @Deprecated
    public static void renderToolTip(FontRenderer fr, int x, int y, int tc, int bc, String ... lines) {
        throw new UnsupportedOperationException();
    }

    static {
        for (Orientation o : Orientation.values()) {
            Vector3i x1 = o.r.func_176730_m();
            Vector3i y1 = o.u.func_176730_m();
            Vector3i z1 = o.b.func_176730_m();
            FloatBuffer buff = BufferUtils.createFloatBuffer((int)16);
            buff.put(new float[]{x1.func_177958_n(), x1.func_177956_o(), x1.func_177952_p(), 0.0f, y1.func_177958_n(), y1.func_177956_o(), y1.func_177952_p(), 0.0f, z1.func_177958_n(), z1.func_177956_o(), z1.func_177952_p(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
            buff.flip();
            Util.matrices[o.ordinal()] = buff;
        }
        instance = new Util();
        RenderFrame = 0;
    }
}

