/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.util.Orientation;
import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;

public class IntArrayModel {
    public static final VertexFormat FORMAT = DefaultVertexFormats.field_176600_a;
    private static final float EPSILON = 0.001f;
    public final int[] vertexData;
    private float ofsX = 0.0f;
    private float ofsY = 0.0f;
    private float ofsZ = 0.0f;
    private int brightness;
    private int color;

    public IntArrayModel(int[] data, int color, int brightness) {
        this.vertexData = data;
        this.color = color;
        this.brightness = brightness;
    }

    public IntArrayModel(int[] data) {
        this(data, -1, 0);
    }

    public IntArrayModel(int n) {
        this(new int[n * 28]);
    }

    public IntArrayModel origin(float x, float y, float z) {
        this.ofsX = x;
        this.ofsY = y;
        this.ofsZ = z;
        return this;
    }

    public void setBrightness(int l) {
        if (l == this.brightness) {
            return;
        }
        for (int i = 6; i < this.vertexData.length; i += 7) {
            this.vertexData[i] = l;
        }
        this.brightness = l;
    }

    public void setOffset(float dx, float dy, float dz) {
        if ((dx -= this.ofsX) * dx + (dy -= this.ofsY) * dy + (dz -= this.ofsZ) * dz < 1.0000001E-6f) {
            return;
        }
        for (int i = 0; i < this.vertexData.length; i += 5) {
            this.vertexData[i] = Float.floatToIntBits(dx + Float.intBitsToFloat(this.vertexData[i]));
            this.vertexData[++i] = Float.floatToIntBits(dy + Float.intBitsToFloat(this.vertexData[i]));
            this.vertexData[++i] = Float.floatToIntBits(dz + Float.intBitsToFloat(this.vertexData[i]));
        }
        this.ofsX += dx;
        this.ofsY += dy;
        this.ofsZ += dz;
    }

    public void setOffset(float ofs, Direction.Axis axis) {
        int i;
        switch (axis) {
            case X: {
                if (ofs == this.ofsX) {
                    return;
                }
                this.ofsX += (ofs -= this.ofsX);
                i = 0;
                break;
            }
            case Y: {
                if (ofs == this.ofsY) {
                    return;
                }
                this.ofsY += (ofs -= this.ofsY);
                i = 1;
                break;
            }
            case Z: {
                if (ofs == this.ofsZ) {
                    return;
                }
                this.ofsZ += (ofs -= this.ofsZ);
                i = 2;
                break;
            }
            default: {
                return;
            }
        }
        while (i < this.vertexData.length) {
            this.vertexData[i] = Float.floatToIntBits(ofs + Float.intBitsToFloat(this.vertexData[i]));
            i += 7;
        }
    }

    public void setColor(int c) {
        if (c == this.color) {
            return;
        }
        for (int i = 3; i < this.vertexData.length; i += 7) {
            this.vertexData[i] = c;
        }
        this.color = c;
    }

    public IntArrayModel withTexture(TextureAtlasSprite tex) {
        int[] data = Arrays.copyOf(this.vertexData, this.vertexData.length);
        for (int i = 4; i < data.length; i += 6) {
            data[i] = Float.floatToIntBits(tex.func_94214_a((double)Float.intBitsToFloat(data[i])));
            data[++i] = Float.floatToIntBits(tex.func_94207_b((double)Float.intBitsToFloat(data[i])));
        }
        return new IntArrayModel(data, this.color, this.brightness);
    }

    public IntArrayModel translated(float x, float y, float z) {
        x -= this.ofsX;
        y -= this.ofsY;
        z -= this.ofsZ;
        int[] data = Arrays.copyOf(this.vertexData, this.vertexData.length);
        for (int i = 0; i < data.length; i += 5) {
            data[i] = Float.floatToIntBits(x + Float.intBitsToFloat(data[i]));
            data[++i] = Float.floatToIntBits(y + Float.intBitsToFloat(data[i]));
            data[++i] = Float.floatToIntBits(z + Float.intBitsToFloat(data[i]));
        }
        return new IntArrayModel(data, this.color, this.brightness);
    }

    public IntArrayModel rotated(Orientation o) {
        throw new UnsupportedOperationException();
    }
}

