/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class JsonArrayLineReader
extends Reader {
    private final Iterator<JsonElement> it;
    private String cur;
    private int pos = 0;
    private int length = -1;

    public JsonArrayLineReader(JsonArray arr) {
        this.it = arr.iterator();
    }

    private boolean next() {
        if (!this.it.hasNext()) {
            return false;
        }
        this.cur = this.it.next().getAsString();
        this.pos = 0;
        this.length = this.cur.length();
        return true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.pos > this.length && !this.next()) {
            return -1;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.pos == this.length) {
            cbuf[off++] = 10;
            --len;
            ++this.pos;
            if (!this.next()) {
                return 1;
            }
        }
        int len1 = Math.min(len, this.length - this.pos);
        this.cur.getChars(this.pos, this.pos += len1, cbuf, off);
        if (len1 < len) {
            cbuf[off + len] = 10;
            ++this.pos;
            ++len;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.pos > this.length && !this.next()) {
            return -1;
        }
        if (this.pos < this.length) {
            return this.cur.charAt(this.pos++);
        }
        ++this.pos;
        return 10;
    }

    @Override
    public void close() throws IOException {
    }
}

