/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.Lib;
import cd4017be.lib.render.model.IModelDataItem;
import cd4017be.lib.render.model.TileEntityModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ModelDataItemOverride
extends ItemOverrideList {
    public static final ModelDataItemOverride INSTANCE = new ModelDataItemOverride();
    private static final Int2ObjectLinkedOpenHashMap<IModelData> MODEL_CACHE = new Int2ObjectLinkedOpenHashMap();

    public static IModelData getCached(int hash, Supplier<IModelData> generate) {
        IModelData data = (IModelData)MODEL_CACHE.getAndMoveToFirst(hash);
        if (data == null) {
            int max = (Integer)Lib.CFG_CLIENT.itemModelCache.get();
            while (MODEL_CACHE.size() >= max) {
                MODEL_CACHE.removeLast();
            }
            data = generate.get();
            MODEL_CACHE.putAndMoveToFirst(hash, (Object)data);
        }
        return data;
    }

    public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, ClientWorld world, LivingEntity livingEntity) {
        Item item = stack.func_77973_b();
        if (!(item instanceof IModelDataItem)) {
            return model;
        }
        IModelData data = ((IModelDataItem)item).getModelData(stack, world, livingEntity);
        if (data == EmptyModelData.INSTANCE) {
            return model;
        }
        return new BakedModelDataWrapper(model, data);
    }

    static {
        TileEntityModel.registerCacheInvalidate(() -> MODEL_CACHE.clear());
    }

    public static class BakedModelDataWrapper
    implements IBakedModel {
        protected final IBakedModel parent;
        protected final IModelData data;

        public BakedModelDataWrapper(IBakedModel parent, IModelData data) {
            this.parent = parent;
            this.data = data;
        }

        public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
            return this.parent.getQuads(state, side, rand, this.data);
        }

        public boolean func_177555_b() {
            return this.parent.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.parent.func_177556_c();
        }

        public boolean func_230044_c_() {
            return this.parent.func_230044_c_();
        }

        public boolean func_188618_c() {
            return this.parent.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.parent.getParticleTexture(this.data);
        }

        public ItemOverrideList func_188617_f() {
            return this.parent.func_188617_f();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.parent.func_177552_f();
        }
    }
}

