/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;

public class ParamertisedVariant
implements IModelTransform {
    public static final ParamertisedVariant BASE = new ParamertisedVariant("model", null);
    public final ModelRotation orient;
    public String subModel;
    public final Parameters params;

    public ParamertisedVariant(ModelRotation orient, String name, Parameters param) {
        this.orient = orient;
        this.subModel = name;
        this.params = param;
    }

    public ParamertisedVariant(String name, Parameters param) {
        this(ModelRotation.X0_Y0, name, param);
    }

    public ParamertisedVariant(ModelRotation orient) {
        this(orient, "model", null);
    }

    public String splitPath() {
        String[] parts = this.subModel.split("\\.");
        String path = parts[0];
        if (parts.length > 1) {
            path = path + "." + parts[1];
        }
        this.subModel = parts.length > 2 ? parts[2] : "model";
        return path;
    }

    public boolean isBase() {
        return this == BASE || this.params == null && this.orient == ModelRotation.X0_Y0 && this.subModel.equals(ParamertisedVariant.BASE.subModel);
    }

    public static ParamertisedVariant parse(String name, ModelRotation orient) {
        Parameters params;
        int i = name.indexOf(40);
        if (i < 0) {
            params = null;
        } else {
            String arg = name.substring(i + 1, name.length() - (name.endsWith(")") ? 1 : 0));
            name = name.substring(0, i);
            if (arg.isEmpty()) {
                params = new Parameters(new IOperand[0]);
            } else {
                String[] pars = arg.split(",");
                IOperand[] arr = new IOperand[pars.length];
                for (int j = 0; j < pars.length; ++j) {
                    try {
                        arr[j] = new Number(Double.parseDouble(pars[j]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        arr[j] = new Text(pars[j]);
                    }
                }
                params = new Parameters(arr);
            }
        }
        return new ParamertisedVariant(orient, name, params);
    }

    public static ParamertisedVariant parse(String name) {
        ModelRotation orient;
        int i = name.indexOf(35);
        if (i < 0) {
            orient = ModelRotation.X0_Y0;
        } else {
            orient = ModelRotation.valueOf((String)name.substring(i + 1).toUpperCase());
            if (orient == null) {
                orient = ModelRotation.X0_Y0;
            }
            name = name.substring(0, i);
        }
        return ParamertisedVariant.parse(name, orient);
    }
}

