/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.math.Orient;
import java.util.List;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.ModelProperty;

public class PartModel {
    public final String name;
    private final float[] ofs;
    private int orient = 1056;
    public static final ModelProperty<List<PartModel>> PART_MODELS = new ModelProperty();

    public PartModel(String name) {
        this.name = name;
        this.ofs = new float[3];
    }

    public PartModel offset(float x, float y, float z) {
        this.ofs[0] = x;
        this.ofs[1] = y;
        this.ofs[2] = z;
        return this;
    }

    public PartModel orient(int o, float x0, float y0, float z0) {
        this.orient = o;
        Orient.origin(o, this.ofs, x0, y0, z0);
        return this;
    }

    public boolean hasTransform() {
        return this.orient != 1056 || this.ofs[0] != 0.0f || this.ofs[1] != 0.0f || this.ofs[2] != 0.0f;
    }

    public Direction getSource(Direction d) {
        return d == null ? null : Orient.orient(Orient.inv(this.orient), d);
    }

    public BakedQuad transform(BakedQuad quad) {
        return Orient.orient(this.orient, quad, this.ofs);
    }
}

