/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.Lib;
import cd4017be.lib.render.model.JsonArrayLineReader;
import cd4017be.lib.render.model.ScriptModelBuilder;
import cd4017be.lib.script.Script;
import cd4017be.lib.script.ScriptLoader;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.script.ScriptException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public class ScriptModel
implements IModelGeometry<ScriptModel> {
    private final ScriptModelBuilder.Quad[] quads;

    public ScriptModel(List<ScriptModelBuilder.Quad> list) {
        this.quads = list.toArray(new ScriptModelBuilder.Quad[list.size()]);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TransformationMatrix transf = modelTransform.func_225615_b_();
        Function<String, TextureAtlasSprite> resolver = spriteGetter.compose(arg_0 -> ((IModelConfiguration)owner).resolveTexture(arg_0));
        SimpleBakedModel.Builder b = new SimpleBakedModel.Builder(owner, overrides);
        for (ScriptModelBuilder.Quad q : this.quads) {
            q.bake(b, transf, resolver);
        }
        return b.func_177646_a(resolver.apply("particle")).func_177645_b();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<String> names = new HashSet<String>();
        for (ScriptModelBuilder.Quad q : this.quads) {
            names.add(q.tex);
        }
        names.add("particle");
        ArrayList<RenderMaterial> list = new ArrayList<RenderMaterial>(names.size());
        for (String n : names) {
            list.add(ScriptModel.resolveTex(n, owner, missingTextureErrors));
        }
        return list;
    }

    public static RenderMaterial resolveTex(String name, IModelConfiguration owner, Set<Pair<String, String>> missingTextureErrors) {
        RenderMaterial rm = owner.resolveTexture(name);
        if (rm.func_229313_b_().equals((Object)MissingTextureSprite.func_195675_b())) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)name, (Object)owner.getModelName()));
        }
        return rm;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Loader
    extends ScriptLoader
    implements IModelLoader<ScriptModel> {
        public static final Loader INSTANCE = new Loader();
        private IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
        private ScriptModelBuilder builder = new ScriptModelBuilder();

        public void func_195410_a(IResourceManager resourceManager) {
            this.manager = resourceManager;
            this.scripts.clear();
        }

        public ScriptModel read(JsonDeserializationContext context, JsonObject modelContents) {
            JsonElement e = modelContents.get("code");
            if (e == null) {
                throw new IllegalStateException("missing element 'code'");
            }
            Reader r = e.isJsonArray() ? new JsonArrayLineReader(e.getAsJsonArray()) : new StringReader(e.getAsString());
            return this.compileModel(r, "code");
        }

        public ScriptModel compileModel(Reader r, String name) {
            try {
                return new ScriptModel(this.builder.run(this.compile(name, r)));
            }
            catch (IOException | ScriptException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected IOperand load(String name) {
            ResourceLocation rl = new ResourceLocation(name);
            rl = new ResourceLocation(rl.func_110624_b(), "models/" + rl.func_110623_a() + ".rcp");
            try (IResource r = this.manager.func_199002_a(rl);){
                Script script = this.compile(name, new InputStreamReader(r.func_199027_b()));
                return script;
            }
            catch (IOException | ScriptException e) {
                Lib.LOG.error("Failed to load model script " + rl, (Throwable)e);
                return Nil.NIL;
            }
        }
    }
}

