/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.script.Script;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.script.ScriptException;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScriptModelBuilder
implements IOperand {
    private static final String defaultFormat = "xyzuvrgba";
    private static final String cfNames = " BTNSWE";
    private static final String axes = "yYzZxXBTNSWE";
    private static final int rect = 152769024;
    private static final String[] F_NAMES = new String[]{"color", "orient", "pop", "push", "quad", "rect", "rotate", "scale", "scaleUV", "translate", "translateUV"};
    final ArrayList<Quad> quads = new ArrayList();
    final State[] states = new State[16];
    int curState;
    final IOperand[] stack = new IOperand[256];
    final IOperand.IFunction[] functions = new IOperand.IFunction[]{(s, b, t) -> {
        double[] v = IOperand.vec(s, b, t, 4);
        float[] uvc = this.states[this.curState].sUVC;
        for (int i = 0; i < 4; ++i) {
            int n = i + 2;
            uvc[n] = (float)((double)uvc[n] * v[i]);
        }
    }, (s, b, t) -> {
        IOperand.check(t - b, 2, 4);
        String or = s[b++].toString();
        double[] center = IOperand.vec(s, b, t, 3);
        State state = this.states[this.curState];
        float[] mat = new float[16];
        mat[3] = (float)center[0];
        mat[7] = (float)center[1];
        mat[11] = (float)center[2];
        mat[15] = 1.0f;
        int o = 0;
        for (int i = 0; i < 3; ++i) {
            float d;
            int a = axes.indexOf(or.charAt(i)) % 6;
            int j = ((a >> 1) + 1) % 3 << 2;
            mat[j | i] = d = (float)(-1 + (a << 1 & 2));
            int n = j | 3;
            mat[n] = mat[n] - (float)center[i] * d;
            a <<= 2;
            a = state.orient >> (a ^ 4) & 0xF0 | state.orient >> a << 4 & 0xF00;
            o |= a << ((i + 2) % 3 << 3);
        }
        state.matrix.func_226595_a_(new Matrix4f(mat));
        state.orient = o;
    }, (s, b, t) -> {
        IOperand.check(t - b, 0, 0);
        if (this.curState <= 0) {
            throw new ScriptException("transformation stack underflow");
        }
        this.states[this.curState--] = null;
    }, (s, b, t) -> {
        IOperand.check(t - b, 0, 0);
        if (this.curState >= 15) {
            throw new ScriptException("transformation stack overflow");
        }
        this.states[++this.curState] = new State(this.states[this.curState - 1]);
    }, (s, b, t) -> {
        IOperand.check(t - b, 5, 6);
        Quad quad = new Quad();
        String format = s[b + 4].toString();
        quad.tex = t - b > 5 ? s[b + 5].toString() : "particle";
        quad.cullFace = cfNames.indexOf(format.charAt(format.length() - 1));
        float[] vert = quad.vertices;
        for (int i = 0; i < 4; ++i) {
            double[] vec = IOperand.get((IOperand[])s, (int)b, (int)i, Vector.class).value;
            int n = 0;
            for (int j = 0; j < format.length(); ++j) {
                int q = defaultFormat.indexOf(format.charAt(j));
                if (q < 0) continue;
                vert[q + i * 9] = (float)vec[n++];
            }
        }
        this.quads.add(quad.transform(this.states[this.curState]));
    }, (s, b, t) -> {
        int tV;
        int tU;
        IOperand.check(t - b, 3, 4);
        Quad quad = new Quad();
        String format = s[b + 2].toString();
        quad.tex = t - b > 3 ? s[b + 3].toString() : "particle";
        quad.cullFace = format.length() <= 3 ? 0 : cfNames.indexOf(format.charAt(3));
        int iN = 0;
        int iU = 0;
        int iV = 0;
        int tN = format.indexOf(45);
        if (tN < 0) {
            tN = format.indexOf(43);
            iN = 1;
        }
        if ((tU = format.indexOf(85)) < 0) {
            tU = format.indexOf(117);
            iU = 1;
        }
        if ((tV = format.indexOf(86)) < 0) {
            tV = format.indexOf(118);
            iV = 1;
        }
        double[] pos = IOperand.get((IOperand[])s, (int)b, (int)0, Vector.class).value;
        double[] tex = IOperand.get((IOperand[])s, (int)b, (int)1, Vector.class).value;
        float[] vert = quad.vertices;
        for (int i = 0; i < 4; ++i) {
            int j = (iN != 0 ? i : 3 - i) * 9;
            int ri = 152769024 >> (i << 3) | iN * 36;
            vert[j + 0] = (float)pos[(ri >> tN + 2 & 1) * 3 + 0];
            vert[j + 1] = (float)pos[(ri >> tN + 1 & 1) * 3 + 1];
            vert[j + 2] = (float)pos[(ri >> tN + 0 & 1) * 3 + 2];
            vert[j + 3] = (float)tex[(ri >> tN - tU + 2 & 1 ^ iU) * 2 + 0];
            vert[j + 4] = (float)tex[(ri >> tN - tV + 2 & 1 ^ iV) * 2 + 1];
            vert[j + 5] = 1.0f;
            vert[j + 6] = 1.0f;
            vert[j + 7] = 1.0f;
            vert[j + 8] = 1.0f;
        }
        this.quads.add(quad.transform(this.states[this.curState]));
    }, (s, b, t) -> {
        double[] v;
        Matrix4f mat = this.states[this.curState].matrix;
        Matrix4f tr = null;
        if (t - b == 3) {
            v = IOperand.vec(s, b++, b, 3);
            tr = Matrix4f.func_226599_b_((float)((float)v[0]), (float)((float)v[1]), (float)((float)v[2]));
            mat.func_226595_a_(tr);
            tr.setTranslation(-((float)v[0]), -((float)v[1]), -((float)v[2]));
        }
        v = IOperand.vec(s, b, t - 1, 3);
        mat.func_226596_a_(new Quaternion(new Vector3f((float)v[0], (float)v[1], (float)v[2]), (float)s[t - 1].asDouble(), true));
        if (tr != null) {
            mat.func_226595_a_(tr);
        }
    }, (s, b, t) -> {
        double[] v = IOperand.vec(s, b, t, 3);
        this.states[this.curState].matrix.func_226595_a_(Matrix4f.func_226593_a_((float)((float)v[0]), (float)((float)v[1]), (float)((float)v[2])));
    }, (s, b, t) -> {
        double[] v = IOperand.vec(s, b, t, 2);
        float[] uvc = this.states[this.curState].sUVC;
        uvc[0] = (float)((double)uvc[0] * v[0]);
        uvc[1] = (float)((double)uvc[1] * v[1]);
    }, (s, b, t) -> {
        double[] v = IOperand.vec(s, b, t, 3);
        this.states[this.curState].matrix.func_226595_a_(Matrix4f.func_226599_b_((float)((float)v[0]), (float)((float)v[1]), (float)((float)v[2])));
    }, (s, b, t) -> {
        double[] v = IOperand.vec(s, b, t, 2);
        State st = this.states[this.curState];
        st.oU = (float)((double)st.oU + v[0] * (double)st.sUVC[0]);
        st.oV = (float)((double)st.oV + v[1] * (double)st.sUVC[1]);
    }};

    public List<Quad> run(Script s) throws ScriptException {
        this.quads.clear();
        this.states[0] = new State();
        this.stack[1] = this;
        s.call(this.stack, 1, 2);
        this.stack[0] = null;
        return this.quads;
    }

    @Override
    public boolean asBool() {
        return true;
    }

    @Override
    public IOperand get(String member) {
        int i = Arrays.binarySearch(F_NAMES, member);
        return i < 0 ? Nil.NIL : this.functions[i];
    }

    @OnlyIn(value=Dist.CLIENT)
    static class State {
        final Matrix4f matrix;
        final float[] sUVC;
        float oU;
        float oV;
        int orient;

        State() {
            this.matrix = new Matrix4f();
            this.matrix.func_226591_a_();
            this.sUVC = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
            this.orient = 106181136;
        }

        State(State s) {
            this.matrix = new Matrix4f(s.matrix);
            this.oU = s.oU;
            this.oV = s.oV;
            this.sUVC = (float[])s.sUVC.clone();
            this.orient = s.orient;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Quad {
        public final float[] vertices = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 16.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        public String tex;
        public int cullFace;
        public boolean shade = true;

        Quad transform(State s) {
            float[] vt = this.vertices;
            Vector4f v = new Vector4f();
            for (int i = 0; i < 36; i += 9) {
                v.func_195911_a(vt[i], vt[i + 1], vt[i + 2], 1.0f);
                v.func_229372_a_(s.matrix);
                vt[i] = v.func_195910_a();
                vt[i + 1] = v.func_195913_b();
                vt[i + 2] = v.func_195914_c();
                int k = i + 3;
                for (int j = 0; j < 6; ++j) {
                    int n = k++;
                    vt[n] = vt[n] * s.sUVC[j];
                }
                int n = i + 3;
                vt[n] = vt[n] + s.oU;
                int n2 = i + 4;
                vt[n2] = vt[n2] + s.oV;
            }
            this.cullFace = s.orient >> (this.cullFace << 2) & 0xF;
            return this;
        }

        public void bake(SimpleBakedModel.Builder b, TransformationMatrix transf, Function<String, TextureAtlasSprite> resolver) {
            TextureAtlasSprite sprite = resolver.apply(this.tex);
            Vector3f[] pos = new Vector3f[4];
            int[] data = new int[32];
            float[] vert = this.vertices;
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < 4) {
                Vector4f posi = new Vector4f(vert[k++] / 16.0f - 0.5f, vert[k++] / 16.0f - 0.5f, vert[k++] / 16.0f - 0.5f, 1.0f);
                transf.transformPosition(posi);
                pos[i] = new Vector3f(posi.func_195910_a(), posi.func_195913_b(), posi.func_195914_c());
                data[j] = Float.floatToRawIntBits(posi.func_195910_a() + 0.5f);
                data[j + 1] = Float.floatToRawIntBits(posi.func_195913_b() + 0.5f);
                data[j + 2] = Float.floatToRawIntBits(posi.func_195914_c() + 0.5f);
                data[j + 4] = Float.floatToRawIntBits(sprite.func_94214_a((double)vert[k++]));
                data[j + 5] = Float.floatToRawIntBits(sprite.func_94207_b((double)vert[k++]));
                data[j + 3] = (int)MathHelper.func_151237_a((double)((double)vert[k++] * 255.0), (double)0.0, (double)255.0) | (int)MathHelper.func_76131_a((float)(vert[k++] * 255.0f), (float)0.0f, (float)255.0f) << 8 | (int)MathHelper.func_76131_a((float)(vert[k++] * 255.0f), (float)0.0f, (float)255.0f) << 16 | (int)MathHelper.func_76131_a((float)(vert[k++] * 255.0f), (float)0.0f, (float)255.0f) << 24;
                ++i;
                j += 8;
            }
            Vector3f v = pos[2];
            v.func_195897_a(pos[0]);
            pos[3].func_195897_a(pos[1]);
            v.func_195896_c(pos[3]);
            v.func_229194_d_();
            data[23] = data[31] = Math.round(v.func_195899_a() * 127.0f) & 0xFF | (Math.round(v.func_195900_b() * 127.0f) & 0xFF) << 8 | (Math.round(v.func_195902_c() * 127.0f) & 0xFF) << 16;
            data[15] = data[31];
            data[7] = data[31];
            Direction d = Direction.func_176737_a((float)v.func_195899_a(), (float)v.func_195900_b(), (float)v.func_195902_c());
            BakedQuad bq = new BakedQuad(data, -1, d, sprite, this.shade);
            if (this.cullFace == 0) {
                b.func_177648_a(bq);
            } else {
                b.func_177650_a(transf.rotateTransform(Direction.func_82600_a((int)(this.cullFace - 1))), bq);
            }
        }
    }
}

