/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.render.model.JsonArrayLineReader;
import cd4017be.lib.render.model.ModelDataItemOverride;
import cd4017be.lib.render.model.ModelRef;
import cd4017be.lib.render.model.PartModel;
import cd4017be.lib.render.model.ScriptModel;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityModel
implements IModelGeometry<TileEntityModel> {
    private final List<Pair<String, IModelGeometry<?>>> partModels;
    public static final ModelDataMap.Builder MODEL_DATA_BUILDER = new ModelDataMap.Builder().withProperty(PartModel.PART_MODELS).withProperty(JitBakedModel.JIT_BAKED_MODEL);

    public TileEntityModel(List<Pair<String, IModelGeometry<?>>> partModels) {
        this.partModels = partModels;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        HashMap<String, IBakedModel> map = new HashMap<String, IBakedModel>(this.partModels.size());
        for (Pair<String, IModelGeometry<?>> e : this.partModels) {
            map.put((String)e.getLeft(), ((IModelGeometry)e.getRight()).bake(owner, bakery, spriteGetter, modelTransform, overrides, modelLocation));
        }
        return new Baked(map, owner.isSideLit(), owner.isShadedInGui(), owner.useSmoothLighting(), spriteGetter.apply(owner.resolveTexture("particle")), owner.getCameraTransforms());
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
        HashSet set = Sets.newHashSet();
        set.add(ScriptModel.resolveTex("particle", owner, missingTextureErrors));
        for (Pair<String, IModelGeometry<?>> e : this.partModels) {
            set.addAll(((IModelGeometry)e.getRight()).getTextures(owner, modelGetter, missingTextureErrors));
        }
        return set;
    }

    public static void registerCacheInvalidate(Runnable cache) {
        Loader.INSTANCE.invalidateCaches.add(cache);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Loader
    implements IModelLoader<TileEntityModel> {
        public static final Loader INSTANCE = new Loader();
        private ArrayList<Runnable> invalidateCaches = new ArrayList();

        public void func_195410_a(IResourceManager resourceManager) {
            for (Runnable r : this.invalidateCaches) {
                r.run();
            }
        }

        public TileEntityModel read(JsonDeserializationContext context, JsonObject modelContents) {
            List<Pair<String, IModelGeometry<?>>> parts;
            if (modelContents.has("parts")) {
                JsonObject obj = modelContents.get("parts").getAsJsonObject();
                parts = new ArrayList(obj.size());
                for (Map.Entry e : obj.entrySet()) {
                    JsonElement v = (JsonElement)e.getValue();
                    Object m = v.isJsonArray() ? ScriptModel.Loader.INSTANCE.compileModel(new JsonArrayLineReader(v.getAsJsonArray()), (String)e.getKey()) : new ModelRef(v.getAsString());
                    parts.add(Pair.of(e.getKey(), (Object)m));
                }
            } else {
                parts = Collections.emptyList();
            }
            return new TileEntityModel(parts);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Baked
    implements IDynamicBakedModel {
        final Map<String, IBakedModel> partMap;
        final TextureAtlasSprite particle;
        final ItemCameraTransforms transforms;
        final boolean sideLit;
        final boolean gui3d;
        final boolean smoothLight;

        public Baked(Map<String, IBakedModel> partMap, boolean sideLit, boolean gui3d, boolean smoothLight, TextureAtlasSprite particle, ItemCameraTransforms transforms) {
            this.partMap = partMap;
            this.particle = particle;
            this.sideLit = sideLit;
            this.gui3d = gui3d;
            this.smoothLight = smoothLight;
            this.transforms = transforms;
        }

        public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
            List parts = (List)data.getData(PartModel.PART_MODELS);
            IBakedModel jitModel = (IBakedModel)data.getData(JitBakedModel.JIT_BAKED_MODEL);
            if (parts == null) {
                return jitModel == null ? Collections.emptyList() : jitModel.func_200117_a(state, side, rand);
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (PartModel part : parts) {
                IBakedModel m = this.partMap.get(part.name);
                if (m == null) continue;
                List list = m.getQuads(state, part.getSource(side), rand, data);
                if (!part.hasTransform()) {
                    quads.addAll(list);
                    continue;
                }
                for (BakedQuad q : list) {
                    quads.add(part.transform(q));
                }
            }
            if (jitModel != null) {
                quads.addAll(jitModel.func_200117_a(state, side, rand));
            }
            return quads;
        }

        public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
            IBakedModel model = (IBakedModel)tileData.getData(JitBakedModel.JIT_BAKED_MODEL);
            if (model != null) {
                model.getModelData(world, pos, state, tileData);
            }
            return tileData;
        }

        public boolean func_177555_b() {
            return this.smoothLight;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_230044_c_() {
            return this.sideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleTexture(IModelData data) {
            TextureAtlasSprite tex;
            IBakedModel model = (IBakedModel)data.getData(JitBakedModel.JIT_BAKED_MODEL);
            if (model != null && (tex = model.func_177554_e()) != null) {
                return tex;
            }
            return this.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return ModelDataItemOverride.INSTANCE;
        }

        public ItemCameraTransforms func_177552_f() {
            return this.transforms;
        }
    }
}

