/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class WrappedBlockModel
implements IBakedModel {
    public static final BlockModelShapes MODELS = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
    public final IBakedModel model;
    public final BlockState state;
    public IModelData data = EmptyModelData.INSTANCE;

    public WrappedBlockModel(IBakedModel model, BlockState state) {
        this.model = model;
        this.state = state;
    }

    public WrappedBlockModel(BlockState state) {
        this(MODELS.func_178125_b(state), state);
    }

    public List<BakedQuad> getQuads(Direction side, Random rand) {
        return this.model.getQuads(this.state, side, rand, this.data);
    }

    public void updateData(IBlockDisplayReader world, BlockPos pos) {
        this.data = this.model.getModelData(world, pos, this.state, this.data);
    }

    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.model.getQuads(this.state, side, rand, this.data);
    }

    public boolean func_177555_b() {
        return this.model.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.model.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.model.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.model.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model.getParticleTexture(this.data);
    }

    public ItemOverrideList func_188617_f() {
        return this.model.func_188617_f();
    }

    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        this.data = this.model.getModelData(world, pos, this.state, this.data);
        return tileData;
    }
}

