/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Function;
import cd4017be.lib.script.Parser;
import cd4017be.lib.script.Script;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import javax.script.ScriptException;

public class Compiler {
    public final String fileName;
    private ByteBuffer code;
    private ByteBuffer out;
    private final String[] names;
    private final char[] nameIdx;
    private final int globals;
    private final ArrayList<Function> functions = new ArrayList();
    private final ArrayList<Long> lines = new ArrayList();
    private char line;
    private char col;
    private char val;
    byte last;
    private char locals;
    private char locOfs;
    private char params;
    private char curStack;
    private char maxStack;
    private char[] extraVars;
    private int funStart;
    ArrayList<Integer> breakPos;
    ArrayList<Integer> continuePos;

    public Compiler(String fileName, Parser parser) {
        this.fileName = fileName;
        this.code = parser.getTokens();
        this.out = (ByteBuffer)this.code.duplicate().clear().position(this.code.limit());
        int l = parser.nameCount();
        this.names = new String[l];
        this.nameIdx = new char[l];
        this.globals = parser.getNames(this.names, this.nameIdx);
    }

    public Script compile() throws ScriptException {
        int version = 0;
        byte c = this.next();
        if (c == 44 && "VERSION".equals(this.names[this.name()])) {
            this.check(this.next(), (byte)35);
            c = this.check(this.next(), 49, 50, 51);
            if (c == 51) {
                version = 1;
            } else if (c == 49) {
                version = (int)this.number();
            }
            this.check(this.next(), (byte)34);
        } else {
            this.code.rewind();
        }
        this.functions.add(null);
        this.compFunc(-1);
        this.functions.set(0, this.functions.remove(this.functions.size() - 1));
        Script script = new Script(this.fileName, this.functions.toArray(new Function[this.functions.size()]), this.names, this.globals);
        script.version = version;
        return script;
    }

    private char[] compFunc(int param) throws ScriptException {
        int i;
        int funStart = this.funStart;
        char line = this.line;
        char locOfs = this.locOfs;
        char params = this.params;
        char curStack = this.curStack;
        char maxStack = this.maxStack;
        char[] extraVars = this.extraVars;
        this.funStart = this.out.position();
        if (param >= 0) {
            byte t;
            this.extraVars = new char[param];
            Arrays.fill(this.extraVars, '\uffff');
            while ((t = this.next()) == 45) {
                this.defLocal();
                ++param;
            }
            this.check(t, (byte)38);
        } else {
            param = 0;
            this.extraVars = new char[0];
        }
        this.params = (char)param;
        this.locOfs = (char)(this.locals - param);
        this.curStack = '\u0000';
        this.maxStack = (char)param;
        this.compBlock();
        this.addLine();
        int l = this.lines.size();
        for (i = 0; i < l && this.lines.get(i).intValue() <= this.funStart; ++i) {
        }
        char[] lineNumbers = new char[l -= i];
        char[] codeIndices = new char[l];
        int j = 0;
        while (j < l) {
            long x = this.lines.get(i);
            codeIndices[j] = (char)((int)x - this.funStart);
            lineNumbers[j] = (char)(x >> 32);
            ++j;
            ++i;
        }
        this.lines.subList(this.lines.size() - l, this.lines.size()).clear();
        byte[] data = new byte[this.out.position() - this.funStart];
        this.out.position(this.funStart).mark();
        this.out.get(data).reset();
        this.functions.add(new Function(param, this.maxStack, line, data, codeIndices, lineNumbers));
        this.funStart = funStart;
        this.locOfs = locOfs;
        this.params = params;
        this.curStack = curStack;
        this.maxStack = maxStack;
        char[] ev = this.extraVars;
        this.extraVars = extraVars;
        return (char[])(ev.length > 0 ? ev : null);
    }

    private void compBlock() throws ScriptException {
        char locals = this.locals;
        byte t = this.next();
        while (t != 39 && t != 63) {
            t = this.compExec(t, false);
            if (this.curStack == '\u0000') continue;
            throw this.err("internal error: invalid stack " + this.curStack);
        }
        if (this.locals != locals) {
            this.opClear(locals - this.locOfs);
            this.locals = locals;
        }
    }

    private byte compExec(byte t, boolean cond) throws ScriptException {
        switch (t) {
            case 34: {
                break;
            }
            case 38: {
                this.compBlock();
                break;
            }
            case 61: {
                if (cond) {
                    this.err(t);
                }
                do {
                    this.check(this.next(), (byte)45);
                    byte name = this.defLocal();
                    t = this.next();
                    if (t == 35) {
                        this.curStack = (char)(this.curStack - '\u0001');
                        t = this.compExpr(this.next());
                        continue;
                    }
                    this.opClear(name + 1);
                } while (t == 33);
                this.check(t, (byte)34);
                break;
            }
            case 59: {
                this.breakPos.add(this.opJmp((byte)84));
                this.check(this.next(), (byte)34);
                break;
            }
            case 58: {
                this.continuePos.add(this.opJmp((byte)84));
                this.check(this.next(), (byte)34);
                break;
            }
            case 60: {
                t = this.next();
                if (t == 34) {
                    this.op((byte)70, 1);
                } else {
                    this.check(this.compExpr(t), (byte)34);
                }
                this.op((byte)88, -1);
                break;
            }
            case 57: {
                ArrayList<Integer> continuePos = this.continuePos;
                ArrayList<Integer> breakPos = this.breakPos;
                this.continuePos = new ArrayList();
                this.breakPos = new ArrayList();
                this.check(this.next(), (byte)36);
                this.check(this.next(), (byte)45);
                byte itvar = this.defLocal();
                this.check(this.next(), (byte)20);
                this.check(this.compExpr(this.next()), (byte)37);
                char p = this.pos();
                int p1 = this.opJmp((byte)86);
                t = this.compExec(this.next(), true);
                char p2 = this.pos();
                for (int i : this.continuePos) {
                    this.out.putChar(i, p2);
                }
                this.op((byte)87, 0);
                this.out.put(itvar);
                this.out.putChar(p);
                this.locals = (char)(this.locals - 2);
                p2 = this.pos();
                this.out.putChar(p1, p2);
                if (!this.breakPos.isEmpty()) {
                    this.op((byte)68, 0);
                    this.out.put((byte)(this.locals - this.locOfs));
                    for (int i : this.breakPos) {
                        this.out.putChar(i, p2);
                    }
                }
                this.continuePos = continuePos;
                this.breakPos = breakPos;
                return t;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.check(this.next(), (byte)36);
                this.check(this.compExpr(this.next()), (byte)37);
                int p = this.opJmp((byte)(t == 52 ? 81 : (t == 53 ? 80 : (t == 55 ? 82 : 83))));
                t = this.compExec(this.next(), true);
                if (t == 56) {
                    int p1 = p;
                    p = this.opJmp((byte)84);
                    this.out.putChar(p1, this.pos());
                    t = this.compExec(this.next(), true);
                }
                this.out.putChar(p, this.pos());
                return t;
            }
            default: {
                t = this.compExpr(t);
                if (t == 47) {
                    if (this.last != 65) {
                        this.err("Function name must be a global variable!");
                    }
                    char var = this.out.getChar(this.out.position() - 2);
                    this.out.position(this.out.position() - 3);
                    this.curStack = (char)(this.curStack - '\u0001');
                    t = this.compOperand(t);
                    this.op((byte)67, -1);
                    this.out.putChar(var);
                    return t;
                }
                if (t != 35) {
                    this.op((byte)69, -1);
                } else if (this.last == 64) {
                    byte var = this.out.get(this.out.position() - 1);
                    this.out.position(this.out.position() - 2);
                    this.curStack = (char)(this.curStack - '\u0001');
                    t = this.compExpr(this.next());
                    this.op((byte)66, -1);
                    this.out.put(var);
                } else if (this.last == 65) {
                    char var = this.out.getChar(this.out.position() - 2);
                    this.out.position(this.out.position() - 3);
                    this.curStack = (char)(this.curStack - '\u0001');
                    t = this.compExpr(this.next());
                    this.op((byte)67, -1);
                    this.out.putChar(var);
                } else if (this.last == 89) {
                    char var = this.out.getChar(this.out.position() - 2);
                    this.out.position(this.out.position() - 3);
                    t = this.compExpr(this.next());
                    this.op((byte)90, -2);
                    this.out.putChar(var);
                } else if (this.last == 52) {
                    this.out.position(this.out.position() - 1);
                    this.curStack = (char)(this.curStack + '\u0001');
                    t = this.compExpr(this.next());
                    this.op((byte)76, -3);
                } else {
                    this.err("invalid assignment");
                }
                this.check(t, (byte)34);
            }
        }
        return this.next();
    }

    private byte compExpr(byte t) throws ScriptException {
        if ((t = this.compOperand(t)) >= 32) {
            return t;
        }
        byte[] ops = new byte[8];
        int size = 0;
        do {
            byte c;
            byte p;
            ops[size++] = t;
            t = this.compOperand(this.next());
            byte by = p = t < 32 ? Parser.PRIOR[t] : (byte)0;
            while (size > 0 && Parser.PRIOR[c = ops[size - 1]] >= p) {
                this.op((byte)(c | 0x20), -1);
                --size;
            }
        } while (t < 32);
        return t;
    }

    private byte compOperand(byte t) throws ScriptException {
        switch (t) {
            case 47: {
                this.op((byte)71, 1);
                this.out.put((byte)this.functions.size());
                char[] param = this.compFunc(this.val);
                if (param != null) {
                    for (char v : param) {
                        this.op((byte)64, 1);
                        this.val = v;
                        this.out.put(this.local());
                    }
                    this.op((byte)77, -param.length);
                    this.out.put((byte)(param.length + 1));
                }
                t = this.next();
                break;
            }
            case 45: {
                this.op((byte)64, 1);
                this.out.put(this.local());
                t = this.next();
                break;
            }
            case 44: {
                this.op((byte)65, 1);
                this.out.putChar(this.name());
                t = this.next();
                break;
            }
            case 49: {
                double v = this.number();
                int iv = (int)v;
                if (v != (double)iv) {
                    this.op((byte)73, 1);
                    this.out.putDouble(v);
                } else if (iv == (byte)iv) {
                    this.op((byte)91, 1);
                    this.out.put((byte)iv);
                } else if (iv == (short)iv) {
                    this.op((byte)92, 1);
                    this.out.putShort((short)iv);
                } else {
                    this.op((byte)93, 1);
                    this.out.putInt(iv);
                }
                t = this.next();
                break;
            }
            case 50: {
                this.op((byte)74, 1);
                t = this.next();
                break;
            }
            case 51: {
                this.op((byte)75, 1);
                t = this.next();
                break;
            }
            case 46: {
                this.op((byte)70, 1);
                t = this.next();
                break;
            }
            case 48: {
                this.op((byte)72, 1);
                this.out.putChar(this.name());
                t = this.next();
                break;
            }
            case 40: {
                int n = 0;
                t = this.next();
                if (t != 41 && t != 42 && t != 43) {
                    ++n;
                    t = this.compExpr(t);
                    while (t == 33) {
                        if (++n > 255) {
                            throw this.err("too many parameters");
                        }
                        t = this.compExpr(this.next());
                    }
                }
                if (t == 42) {
                    this.op((byte)78, 1 - n);
                } else if (t == 43) {
                    this.op((byte)79, 1 - n);
                } else {
                    this.check(t, (byte)41);
                    this.op((byte)77, 1 - n);
                }
                this.out.put((byte)n);
                t = this.next();
                break;
            }
            case 36: {
                this.check(this.compExpr(this.next()), (byte)37);
                t = this.next();
                break;
            }
            default: {
                if (t >= 32) {
                    throw this.err("expression", t);
                }
                byte c = t;
                t = this.compOperand(this.next());
                this.op(c, 0);
            }
        }
        while (t == 62 || t == 36) {
            if (t == 62) {
                this.op((byte)89, 0);
                this.out.putChar(this.name());
            } else {
                int n = 0;
                t = this.next();
                if (t != 37) {
                    ++n;
                    t = this.compExpr(t);
                    while (t == 33) {
                        if (++n > 255) {
                            throw this.err("too many parameters");
                        }
                        t = this.compExpr(this.next());
                    }
                    this.check(t, (byte)37);
                }
                this.op((byte)85, -n);
                this.out.put((byte)n);
            }
            t = this.next();
        }
        return t;
    }

    private byte next() {
        byte t = this.code.get();
        char v = this.code.getChar();
        switch (t) {
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 62: {
                this.val = v;
                this.col = (char)(this.col + '\u0001');
                break;
            }
            case 32: {
                this.addLine();
                this.line = v;
                this.col = '\u0000';
                return this.next();
            }
            default: {
                this.col = v;
            }
        }
        return t;
    }

    private void addLine() {
        int p = this.out.position();
        int l = this.lines.size() - 1;
        if (l >= 0 && this.lines.get(l).intValue() == p) {
            this.lines.remove(l);
        }
        this.lines.add((long)this.line << 32 | (long)p);
    }

    private void check(byte t, byte exp) throws ScriptException {
        if (t != exp) {
            throw this.err(String.format("exp. %s , got %s", Parser.OP_NAMES[exp], Parser.OP_NAMES[t]));
        }
    }

    private byte check(byte t, byte ... exp) throws ScriptException {
        for (byte e : exp) {
            if (e != t) continue;
            return t;
        }
        throw this.err(String.format("exp. %s , got %s", Parser.OP_NAMES[exp[0]], Parser.OP_NAMES[t]));
    }

    private ScriptException err(String exp, byte t) {
        return this.err(String.format("exp. %s, got %s", exp, Parser.OP_NAMES[t]));
    }

    private ScriptException err(byte c) {
        return this.err(String.format("unexpected token: %s", Parser.OP_NAMES[c]));
    }

    private ScriptException err(String msg) {
        return new ScriptException(msg, this.fileName, this.line, this.col);
    }

    private char name() {
        return this.nameIdx[this.val];
    }

    private double number() {
        long val = this.val;
        for (int i = 16; i < 64; i += 16) {
            this.next();
            val |= (long)this.val << i;
        }
        return Double.longBitsToDouble(val);
    }

    private byte defLocal() throws ScriptException {
        this.locals = (char)(this.val + '\u0001');
        if (this.locals - this.locOfs > this.maxStack) {
            this.maxStack = (char)(this.locals - this.locOfs);
        }
        return this.local();
    }

    private byte local() throws ScriptException {
        int val = this.val - this.locOfs;
        if (val >= this.params || (val -= this.extraVars.length) >= 0) {
            return (byte)val;
        }
        for (int i = 0; i < this.extraVars.length; ++i) {
            char v = this.extraVars[i];
            if (v == '\uffff') {
                this.extraVars[i] = this.val;
            } else if (v != this.val) continue;
            return (byte)i;
        }
        throw this.err("internal error");
    }

    private void op(byte code, int stack) {
        this.last = code;
        this.out.put(this.last);
        this.curStack = (char)(this.curStack + stack);
        int i = this.locals - this.locOfs + this.curStack;
        if (i > this.maxStack) {
            this.maxStack = (char)i;
        }
    }

    private void opClear(int lvl) {
        if (this.last == 68) {
            this.out.position(this.out.position() - 1);
        } else {
            this.op((byte)68, 0);
        }
        this.out.put((byte)lvl);
        this.curStack = '\u0000';
    }

    private int opJmp(byte code) {
        this.op(code, code == 84 ? 0 : -1);
        this.out.putChar('\u0000');
        return this.out.position() - 2;
    }

    private char pos() {
        return (char)(this.out.position() - this.funStart);
    }
}

