/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.Script;
import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.script.obj.Vector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.script.ScriptException;

public class Function
implements IOperand {
    private static final int TICK_LIMIT = 262144;
    public static final byte gloc = 64;
    public static final byte gvar = 65;
    public static final byte sloc = 66;
    public static final byte svar = 67;
    public static final byte clear = 68;
    public static final byte pop = 69;
    public static final byte cst_nil = 70;
    public static final byte cst_func = 71;
    public static final byte cst_T = 72;
    public static final byte cst_F64 = 73;
    public static final byte cst_false = 74;
    public static final byte cst_true = 75;
    public static final byte arr_set = 76;
    public static final byte arr_pack = 77;
    public static final byte vec_pack = 78;
    public static final byte text_pack = 79;
    public static final byte goif = 80;
    public static final byte goifn = 81;
    public static final byte gosucc = 82;
    public static final byte gofail = 83;
    public static final byte go = 84;
    public static final byte call = 85;
    public static final byte iterate = 86;
    public static final byte end = 87;
    public static final byte ret = 88;
    public static final byte access = 89;
    public static final byte assign = 90;
    public static final byte cst_I8 = 91;
    public static final byte cst_I16 = 92;
    public static final byte cst_I32 = 93;
    private final byte[] code;
    public final int Nparam;
    public final int lineOfs;
    public final int Nstack;
    private final char[] codeIndices;
    private final char[] lineNumbers;
    public Script script;

    public Function(int param, int stack, int lineOfs, byte[] code, char[] codeIndices, char[] lineNumbers) {
        this.Nparam = param;
        this.Nstack = stack;
        this.lineOfs = lineOfs;
        this.code = code;
        this.codeIndices = codeIndices;
        this.lineNumbers = lineNumbers;
    }

    public Function(DataInputStream dis) throws IOException {
        this.Nparam = dis.readByte() & 0x7F;
        this.Nstack = dis.readByte() & 0xFF;
        this.code = new byte[dis.readUnsignedShort()];
        dis.read(this.code);
        this.lineOfs = dis.readUnsignedShort();
        int i = dis.readUnsignedShort();
        this.lineNumbers = new char[i];
        this.codeIndices = new char[i];
        for (int j = 0; j < i; ++j) {
            this.codeIndices[j] = dis.readChar();
            this.lineNumbers[j] = dis.readChar();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void call(IOperand[] stack, int bot, int top) throws ScriptException {
        if (top - bot != this.Nparam) {
            throw new ScriptException("wrong number of parameters!", this.script.fileName, this.lineOfs);
        }
        if (bot + this.Nstack > stack.length) {
            throw new ScriptException("Stack overflow!", this.script.fileName, this.lineOfs);
        }
        ByteBuffer code = ByteBuffer.wrap(this.code);
        int tc = 262144;
        try {
            block34: while (true) {
                IOperand a;
                if (!code.hasRemaining()) {
                    stack[bot - 1] = Nil.NIL;
                    Arrays.fill(stack, bot, bot + this.Nstack, null);
                    return;
                }
                if (--tc < 0) {
                    throw this.err(new Exception("ran for more than 262144 cycles: infinite loop?"), code);
                }
                byte op = code.get();
                if ((op & 0xC0) == 0) {
                    a = stack[--top];
                    a = (op & 0x20) == 0 ? a.op(op) : stack[--top].opR(op & 0x1F, a);
                    stack[top++] = a;
                    continue;
                }
                switch (op) {
                    case 64: {
                        a = stack[bot + (code.get() & 0xFF)];
                        stack[top++] = a == null ? Nil.NIL : a.onCopy();
                        continue block34;
                    }
                    case 66: {
                        stack[bot + (code.get() & 0xFF)] = stack[--top];
                        continue block34;
                    }
                    case 65: {
                        stack[top++] = this.script.globals[code.getChar()].onCopy();
                        continue block34;
                    }
                    case 67: {
                        this.script.globals[code.getChar()] = stack[--top];
                        continue block34;
                    }
                    case 68: {
                        int l = bot + (code.get() & 0xFF);
                        if (l < top) {
                            Arrays.fill(stack, l, top, null);
                        }
                        top = l;
                        continue block34;
                    }
                    case 69: {
                        if (!((a = stack[--top]) instanceof Error)) continue block34;
                        throw (Error)a;
                    }
                    case 70: {
                        stack[top++] = Nil.NIL;
                        continue block34;
                    }
                    case 71: {
                        stack[top++] = this.script.functions[code.get() & 0xFF];
                        continue block34;
                    }
                    case 72: {
                        stack[top++] = new Text(this.script.dictionary[code.getChar()]);
                        continue block34;
                    }
                    case 73: {
                        stack[top++] = new Number(code.getDouble());
                        continue block34;
                    }
                    case 93: {
                        stack[top++] = new Number(code.getInt());
                        continue block34;
                    }
                    case 92: {
                        stack[top++] = new Number(code.getShort());
                        continue block34;
                    }
                    case 91: {
                        stack[top++] = new Number(code.get());
                        continue block34;
                    }
                    case 75: {
                        stack[top++] = Number.TRUE;
                        continue block34;
                    }
                    case 74: {
                        stack[top++] = Number.FALSE;
                        continue block34;
                    }
                    case 76: {
                        stack[top - 3].put(stack[top - 2], stack[top - 1]);
                        top -= 3;
                        continue block34;
                    }
                    case 77: {
                        int l = top;
                        stack[top -= code.get() & 0xFF] = new Array(stack, top++, l);
                        continue block34;
                    }
                    case 78: {
                        int l = top;
                        stack[top -= code.get() & 0xFF] = new Vector(stack, top++, l);
                        continue block34;
                    }
                    case 79: {
                        int l = top;
                        StringBuilder s = new StringBuilder();
                        for (int i = top -= code.get() & 0xFF; i < l; ++i) {
                            s.append(stack[i].toString());
                        }
                        stack[top++] = new Text(s.toString());
                        continue block34;
                    }
                    case 80: {
                        int l = code.getChar();
                        if (!stack[--top].asBool()) continue block34;
                        code.position(l);
                        continue block34;
                    }
                    case 81: {
                        int l = code.getChar();
                        if (stack[--top].asBool()) continue block34;
                        code.position(l);
                        continue block34;
                    }
                    case 82: {
                        int l = code.getChar();
                        if (stack[--top].isError()) continue block34;
                        code.position(l);
                        continue block34;
                    }
                    case 83: {
                        int l = code.getChar();
                        if (!stack[--top].isError()) continue block34;
                        code.position(l);
                        continue block34;
                    }
                    case 84: {
                        code.position(code.getChar());
                        continue block34;
                    }
                    case 85: {
                        int l = top;
                        stack[(top -= code.get() & 0xFF) - 1].call(stack, top, l);
                        continue block34;
                    }
                    case 86: {
                        IOperand.OperandIterator it;
                        a = stack[--top];
                        if (a instanceof IOperand.OperandIterator) {
                            it = (IOperand.OperandIterator)a;
                        } else {
                            it = a.iterator();
                            stack[top] = it;
                        }
                        char p = code.getChar();
                        if (it.hasNext()) {
                            stack[++top] = it.next();
                            ++top;
                            continue block34;
                        }
                        code.position(p);
                        continue block34;
                    }
                    case 87: {
                        top = bot + (code.get() & 0xFF);
                        a = stack[top];
                        ((IOperand.OperandIterator)stack[top - 1]).set(a);
                        code.position(code.getChar());
                        continue block34;
                    }
                    case 88: {
                        stack[bot - 1] = stack[top - 1];
                        return;
                    }
                    case 89: {
                        stack[top - 1] = stack[top - 1].get(this.script.dictionary[code.getChar()]);
                        continue block34;
                    }
                    case 90: {
                        a = stack[--top];
                        stack[--top].set(this.script.dictionary[code.getChar()], a);
                        continue block34;
                    }
                }
                throw new Exception(String.format("invalid opcode 0x%02X", op));
            }
        }
        catch (Exception e) {
            throw this.err(e, code);
        }
    }

    private ScriptException err(Exception ex, ByteBuffer code) {
        int p = Arrays.binarySearch(this.codeIndices, (char)code.position());
        p = p == -1 ? this.lineOfs : this.lineNumbers[p < 0 ? -2 - p : p];
        String msg = ex.getMessage();
        return (ScriptException)new ScriptException(ex.getClass().getSimpleName() + (msg == null ? "" : ": " + msg), this.script.fileName, p).initCause(ex);
    }

    public void writeData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.Nparam);
        dos.writeByte(this.Nstack);
        dos.writeShort(this.code.length);
        dos.write(this.code);
        dos.writeShort(this.lineOfs);
        dos.writeShort(this.lineNumbers.length);
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            dos.writeChar(this.codeIndices[i]);
            dos.writeChar(this.lineNumbers[i]);
        }
    }

    public int size() {
        return this.code.length;
    }

    @Override
    public boolean asBool() {
        return true;
    }

    @Override
    public Object value() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < this.Nparam; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append("loc").append(i);
        }
        sb.append(") {bytes ").append(this.code.length).append(", stack ").append(this.Nstack).append('}');
        return sb.toString();
    }
}

