/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Text;
import cd4017be.lib.script.obj.Vector;

public class Parameters {
    public final IOperand[] param;

    public Parameters(IOperand ... param) {
        this.param = param;
    }

    public boolean has(int i) {
        return this.param.length > i;
    }

    public String getString(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        IOperand o = this.param[i];
        if (o instanceof Text) {
            return ((Text)o).value;
        }
        throw this.ex("String", o, i);
    }

    public double getNumber(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        return this.param[i].asDouble();
    }

    public int getIndex(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        return this.param[i].asIndex();
    }

    public boolean getBool(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        return this.param[i].asBool();
    }

    public Object[] getArray(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        IOperand o = this.param[i];
        if (o instanceof Array) {
            return ((Array)o).value();
        }
        throw this.ex("Array", o, i);
    }

    public double[] getVector(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        IOperand o = this.param[i];
        if (o instanceof Vector) {
            return ((Vector)o).value;
        }
        throw this.ex("Vector", o, i);
    }

    public <T> T get(int i, Class<T> c) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        Object o = this.param[i].value();
        if (c.isInstance(o)) {
            return c.cast(o);
        }
        throw this.ex(c.getSimpleName(), o, i);
    }

    public Object get(int i) {
        if (i >= this.param.length) {
            throw this.num(i);
        }
        return this.param[i].value();
    }

    public Object[] getArrayOrAll(int i) {
        IOperand[] p = this.param;
        int l = p.length;
        if (i > l) {
            throw this.num(i);
        }
        if (l - i == 1 && p[i] instanceof Array) {
            return ((Array)p[i]).value();
        }
        Object[] arr = new Object[l - i];
        int j = 0;
        while (i < l) {
            arr[j] = p[i].value();
            ++i;
            ++j;
        }
        return arr;
    }

    public double[] getVectorOrAll(int i) {
        IOperand[] p = this.param;
        int l = p.length;
        if (i > l) {
            throw this.num(i);
        }
        if (l - i == 1 && p[i] instanceof Vector) {
            return ((Vector)p[i]).value;
        }
        double[] vec = new double[l - i];
        int j = 0;
        while (i < l) {
            vec[j] = p[i].asDouble();
            ++i;
            ++j;
        }
        return vec;
    }

    public Object[] getArrayOrAll() {
        return this.getArrayOrAll(0);
    }

    public double[] getVectorOrAll() {
        return this.getVectorOrAll(0);
    }

    private IllegalArgumentException num(int pos) {
        return new IllegalArgumentException(String.format("Too few arguments, expected at least %d", pos + 1));
    }

    private IllegalArgumentException ex(String exp, Object got, int pos) {
        if (got instanceof Exception) {
            Exception e = (Exception)got;
            return new IllegalArgumentException(String.format("Evaluation of paramter %s @ %d returned an error:\n%s: %s", exp, pos, e.getClass().getSimpleName(), e.getMessage()), e);
        }
        return new IllegalArgumentException(String.format("expected %s @ %d , got %s", exp, pos, got == null ? "null" : got.getClass().getSimpleName()));
    }
}

