/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;

public class Parser {
    ByteBuffer tokens = ByteBuffer.allocate(196608);
    CharBuffer string = this.tokens.asCharBuffer();
    final HashMap<String, Short> names = new HashMap();
    final ArrayList<String> nameList = new ArrayList();
    final HashMap<String, Long> locals = new HashMap();
    final ArrayList<Long> funcPtrs = new ArrayList();
    BitSet locLvls = new BitSet();
    BitSet globals = new BitSet();
    int nextLocal;
    short line;
    short col;
    boolean newline;
    public static final String[] OP_NAMES = new String[]{"==", "~=", "~", "~~", "<", ">=", ">", "<=", "&", "~&", "|", "~|", "+", "-", "*", "/", "%", "^", "<<", ">>", ":", "?", "#", "$", null, null, null, null, null, null, null, null, "\n", ",", ";", "=", "(", ")", "{", "}", "[", "]", "]#", "]$", "var", "lvar", "nil", "function", "string", "number", "false", "true", "if", "ifnot", "ifval", "iferr", "else", "for", "continue", "break", "return", "Loc", ".x", "EOF"};
    public static final byte[] PRIOR = new byte[]{4, 4, 3, 3, 4, 4, 4, 4, 2, 2, 1, 1, 6, 6, 7, 7, 7, 8, 5, 5, 8, 1, 1, 1};
    public static final byte LINE = 32;
    public static final byte SEP_PAR = 33;
    public static final byte SEP_CMD = 34;
    public static final byte ASN = 35;
    public static final byte B_PAR = 36;
    public static final byte E_PAR = 37;
    public static final byte B_BLOCK = 38;
    public static final byte E_BLOCK = 39;
    public static final byte B_LIST = 40;
    public static final byte E_ARR = 41;
    public static final byte E_VEC = 42;
    public static final byte E_TEXT = 43;
    public static final byte VAR = 44;
    public static final byte LOCVAR = 45;
    public static final byte NIL = 46;
    public static final byte FUNC = 47;
    public static final byte STR = 48;
    public static final byte NUM = 49;
    public static final byte FALSE = 50;
    public static final byte TRUE = 51;
    public static final byte K_IF = 52;
    public static final byte K_IFNOT = 53;
    public static final byte K_IFVAL = 54;
    public static final byte K_IFERR = 55;
    public static final byte K_ELSE = 56;
    public static final byte K_FOR = 57;
    public static final byte K_CONT = 58;
    public static final byte K_BR = 59;
    public static final byte K_RET = 60;
    public static final byte K_LOC = 61;
    public static final byte ACCESS = 62;
    public static final byte EOF = 63;

    public void clear() {
        this.tokens.clear();
        this.names.clear();
        this.nameList.clear();
        this.locals.clear();
        this.locLvls.clear();
        this.globals.clear();
        this.funcPtrs.clear();
        this.nextLocal = 0;
        this.line = 1;
        this.col = 0;
        this.newline = true;
    }

    public Parser parse(Reader reader, String name) throws ScriptException, IOException {
        try (Reader script = reader;){
            this.clear();
            int bracketLvl = 0;
            int blockLvl = 0;
            boolean read = true;
            boolean defLoc = false;
            boolean loop = false;
            int c = this.next(script);
            while (c >= 0) {
                switch (c) {
                    case 44: {
                        this.add((byte)33);
                        defLoc = this.locLvls.get(bracketLvl);
                        break;
                    }
                    case 40: {
                        this.add((byte)36);
                        ++bracketLvl;
                        break;
                    }
                    case 41: {
                        this.add((byte)37);
                        --bracketLvl;
                        break;
                    }
                    case 91: {
                        this.add((byte)40);
                        ++bracketLvl;
                        break;
                    }
                    case 93: {
                        --bracketLvl;
                        c = this.next(script);
                        if (c == 35) {
                            this.add((byte)42);
                            break;
                        }
                        if (c == 36) {
                            this.add((byte)43);
                            break;
                        }
                        read = false;
                        this.add((byte)41);
                        break;
                    }
                    case 123: {
                        ++bracketLvl;
                        if (this.prev(-1) == 37) {
                            for (int i = this.tokens.position() - 6; i >= 0; i -= 3) {
                                byte t = this.tokens.get(i);
                                if (t == 44 || t == 33 || t == 32) continue;
                                if (t != 36) break;
                                this.funcPtrs.add((long)blockLvl | (long)i << 32);
                                this.tokens.put(i, (byte)47);
                                this.tokens.position(i += 3);
                                int j = i;
                                while ((t = this.tokens.get(j)) != 37) {
                                    if (t == 44) {
                                        this.tokens.put((byte)45).putShort(this.tokens.getShort(j + 1));
                                        ++this.nextLocal;
                                    } else if (t == 32) {
                                        this.newline = true;
                                    }
                                    j += 3;
                                }
                                j = this.tokens.position() - 2;
                                int l = this.nextLocal - 1;
                                while (j > i) {
                                    String s = this.rem(this.tokens.getShort(j));
                                    if (this.locals.put(s, Long.valueOf(l & 0xFFFF | blockLvl + 1 << 16)) != null) {
                                        throw new ScriptException("duplicate local variable: " + s, name, this.line, this.col);
                                    }
                                    this.tokens.putShort(j, (short)l);
                                    j -= 3;
                                    --l;
                                }
                                break;
                            }
                        }
                        this.add((byte)38);
                        if (loop) {
                            loop = false;
                            break;
                        }
                        ++blockLvl;
                        break;
                    }
                    case 59: {
                        this.add((byte)34);
                        this.locLvls.clear(bracketLvl);
                        if (!loop) break;
                        loop = false;
                    }
                    case 125: {
                        int l;
                        long fp;
                        if (c == 125) {
                            --bracketLvl;
                            this.add((byte)39);
                        }
                        int lvl = blockLvl--;
                        this.nextLocal = 0;
                        this.locals.values().removeIf(x -> {
                            if (x.intValue() >>> 16 == lvl) {
                                return true;
                            }
                            this.nextLocal = Math.max(this.nextLocal, x.shortValue() + 1);
                            return false;
                        });
                        if (blockLvl < 0) {
                            throw new ScriptException("excess }", name, this.line, this.col);
                        }
                        if (this.funcPtrs.isEmpty() || (int)(fp = this.funcPtrs.get(l = this.funcPtrs.size() - 1).longValue()) != blockLvl) break;
                        long mask = -1L << l + 32;
                        int[] n = new int[]{0};
                        this.locals.replaceAll((k, v) -> {
                            if ((v & mask) == 0L) {
                                return v;
                            }
                            n[0] = n[0] + 1;
                            return v & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                        });
                        this.tokens.putShort((int)(fp >> 32) + 1, (short)n[0]);
                        this.funcPtrs.remove(l);
                        break;
                    }
                    case 61: {
                        c = this.next(script);
                        if (c == 61) {
                            this.add((byte)0);
                            break;
                        }
                        read = false;
                        this.add((byte)35);
                        break;
                    }
                    case 60: {
                        c = this.next(script);
                        if (c == 61) {
                            this.add((byte)7);
                            break;
                        }
                        if (c == 60) {
                            this.add((byte)18);
                            break;
                        }
                        read = false;
                        this.add((byte)4);
                        break;
                    }
                    case 62: {
                        c = this.next(script);
                        if (c == 61) {
                            this.add((byte)5);
                            break;
                        }
                        if (c == 62) {
                            this.add((byte)19);
                            break;
                        }
                        read = false;
                        this.add((byte)6);
                        break;
                    }
                    case 126: {
                        c = this.next(script);
                        if (c == 61) {
                            this.add((byte)1);
                            break;
                        }
                        if (c == 38) {
                            this.add((byte)9);
                            break;
                        }
                        if (c == 124) {
                            this.add((byte)11);
                            break;
                        }
                        if (c == 126) {
                            this.add((byte)3);
                            break;
                        }
                        read = false;
                        this.add((byte)2);
                        break;
                    }
                    case 38: {
                        this.add((byte)8);
                        break;
                    }
                    case 124: {
                        this.add((byte)10);
                        break;
                    }
                    case 43: {
                        this.add((byte)12);
                        break;
                    }
                    case 45: {
                        this.add((byte)13);
                        break;
                    }
                    case 42: {
                        this.add((byte)14);
                        break;
                    }
                    case 47: {
                        this.add((byte)15);
                        break;
                    }
                    case 37: {
                        this.add((byte)16);
                        break;
                    }
                    case 94: {
                        this.add((byte)17);
                        break;
                    }
                    case 63: {
                        this.add((byte)21);
                        break;
                    }
                    case 35: {
                        this.add((byte)22);
                        break;
                    }
                    case 58: {
                        this.add((byte)20);
                        break;
                    }
                    case 36: {
                        this.add((byte)23);
                        break;
                    }
                    case 34: 
                    case 39: {
                        this.startString();
                        while (true) {
                            int c1;
                            if ((c1 = this.next(script)) == 92) {
                                c1 = this.next(script);
                                if (c1 == 110) {
                                    c1 = 10;
                                } else if (c1 == 116) {
                                    c1 = 9;
                                }
                            } else if (c1 == c) break;
                            if (c1 < 0) break;
                            this.string.append((char)c1);
                        }
                        this.add((byte)48, this.getString());
                        break;
                    }
                    case 33: {
                        while ((c = this.next(script)) >= 0 && c != 10) {
                        }
                        break;
                    }
                    case 46: {
                        this.startString();
                        while ((c = this.next(script)) >= 0) {
                            if (Character.isJavaIdentifierPart(c)) {
                                this.string.append((char)c);
                                continue;
                            }
                            read = false;
                            break;
                        }
                        this.add((byte)62, this.getString());
                        break;
                    }
                    default: {
                        if (c >= 48 && c <= 57) {
                            this.startString();
                            this.string.append((char)c);
                            while ((c = this.next(script)) >= 0) {
                                if (c >= 48 && c <= 57 || c == 46 || c == 101) {
                                    this.string.append((char)c);
                                    continue;
                                }
                                read = false;
                                break;
                            }
                            String s = this.getString();
                            try {
                                double x2 = Double.parseDouble(s);
                                if (this.prev(-1) == 15 && Parser.canInv(this.prev(-2))) {
                                    this.remLast();
                                    x2 = 1.0 / x2;
                                }
                                if (this.prev(-1) == 13 && Parser.canInv(this.prev(-2))) {
                                    this.remLast();
                                    x2 = -x2;
                                }
                                if (x2 != 0.0) {
                                    this.add(x2);
                                    break;
                                }
                                this.add(Double.doubleToRawLongBits(x2) < 0L ? (byte)51 : 50);
                                break;
                            }
                            catch (NumberFormatException e) {
                                throw new ScriptException("illegal number format: " + s, name, this.line, this.col);
                            }
                        }
                        if (Character.isJavaIdentifierStart(c)) {
                            this.startString();
                            this.string.append((char)c);
                            boolean extvar = false;
                            while ((c = this.next(script)) >= 0) {
                                if (Character.isJavaIdentifierPart(c)) {
                                    this.string.append((char)c);
                                    continue;
                                }
                                read = false;
                                break;
                            }
                            String s = this.getString();
                            if (extvar) {
                                this.add((byte)44, s);
                                break;
                            }
                            if ("nil".equals(s)) {
                                this.add((byte)46);
                                break;
                            }
                            if ("false".equals(s)) {
                                this.add((byte)50);
                                break;
                            }
                            if ("true".equals(s)) {
                                this.add((byte)51);
                                break;
                            }
                            if ("NaN".equals(s)) {
                                this.add(Double.NaN);
                                break;
                            }
                            if ("if".equals(s)) {
                                this.add((byte)52);
                                break;
                            }
                            if ("ifnot".equals(s)) {
                                this.add((byte)53);
                                break;
                            }
                            if ("else".equals(s)) {
                                this.add((byte)56);
                                break;
                            }
                            if ("ifval".equals(s)) {
                                this.add((byte)54);
                                break;
                            }
                            if ("iferr".equals(s)) {
                                this.add((byte)55);
                                break;
                            }
                            if ("for".equals(s)) {
                                defLoc = true;
                                loop = true;
                                ++this.nextLocal;
                                ++blockLvl;
                                this.add((byte)57);
                                break;
                            }
                            if ("return".equals(s)) {
                                this.add((byte)60);
                                break;
                            }
                            if ("break".equals(s)) {
                                this.add((byte)59);
                                break;
                            }
                            if ("continue".equals(s)) {
                                this.add((byte)58);
                                break;
                            }
                            if ("Loc".equals(s)) {
                                this.add((byte)61);
                                this.locLvls.set(bracketLvl);
                                defLoc = true;
                                break;
                            }
                            if (defLoc) {
                                short l;
                                defLoc = false;
                                if (this.locals.put(s, Long.valueOf((l = (short)this.nextLocal++) & 0xFFFF | blockLvl << 16)) != null) {
                                    throw new ScriptException("duplicate local variable: " + s, name, this.line, this.col);
                                }
                                this.add((byte)45, l);
                                break;
                            }
                            Long l = this.locals.get(s);
                            if (l != null) {
                                this.add((byte)45, l.shortValue());
                                if (this.funcPtrs.isEmpty()) break;
                                this.locals.put(s, l | 1L << 31 + this.funcPtrs.size());
                                break;
                            }
                            this.add((byte)44, s);
                            break;
                        }
                        if (Character.isWhitespace(c)) break;
                        throw new ScriptException("unexpected character: " + (char)c, name, this.line, this.col);
                    }
                }
                if (read) {
                    c = this.next(script);
                } else {
                    read = true;
                }
                if (bracketLvl >= 0) continue;
                throw new ScriptException("excess closing bracket", name, this.line, this.col);
            }
            this.add((byte)63);
            if (blockLvl != 0) {
                throw new ScriptException("unclosed blocks", name, this.line, this.col);
            }
            if (bracketLvl != 0) {
                throw new ScriptException("unclosed brackets", name, this.line, this.col);
            }
            Parser parser = this;
            return parser;
        }
    }

    public ByteBuffer getTokens() {
        return (ByteBuffer)this.tokens.flip();
    }

    public int nameCount() {
        return this.names.size();
    }

    public int getNames(String[] n, char[] idx) {
        Map.Entry[] entries = this.names.entrySet().toArray(new Map.Entry[this.names.size()]);
        Arrays.sort(entries, (a, b) -> ((String)a.getKey()).compareTo((String)b.getKey()));
        int iv = 0;
        char in = (char)this.globals.cardinality();
        for (Map.Entry e : entries) {
            int n2;
            int i = (Short)e.getValue() & 0xFFFF;
            if (this.globals.get(i)) {
                n2 = iv;
                iv = (char)(iv + 1);
            } else {
                n2 = in;
                in = (char)(in + '\u0001');
            }
            idx[i] = n2;
            n[n2] = (String)e.getKey();
        }
        this.names.clear();
        return iv;
    }

    private static boolean canInv(byte t) {
        switch (t) {
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                return false;
            }
        }
        return true;
    }

    private int next(Reader reader) throws IOException {
        int c = reader.read();
        if (c == 10) {
            this.line = (short)(this.line + 1);
            this.col = 0;
            this.newline = true;
        } else {
            this.col = c == 9 ? (short)(this.col + 4) : (short)(this.col + 1);
        }
        return c;
    }

    private void startString() {
        this.string.clear().position(this.tokens.position() + 1 >> 1).mark();
    }

    private String getString() {
        return this.string.limit(this.string.position()).reset().toString();
    }

    private void add(byte t) {
        this.add(t, this.col);
    }

    private void add(double val) {
        long v = Double.doubleToLongBits(val);
        int i = 0;
        while (i < 4) {
            this.tokens.put((byte)49).putShort((short)v);
            ++i;
            v >>>= 16;
        }
    }

    private void add(byte t, String s) {
        short i = this.names.computeIfAbsent(s, k -> {
            this.nameList.add((String)k);
            return (short)(this.nameList.size() - 1);
        });
        this.add(t, i);
        if (t == 44) {
            this.globals.set(i);
        }
    }

    private String rem(short i) {
        String s = this.nameList.get(i);
        if (i == this.nameList.size() - 1) {
            this.globals.clear(this.names.remove(this.nameList.remove(i)).shortValue());
        }
        return s;
    }

    private void add(byte t, short arg) {
        if (this.newline) {
            this.newline = false;
            this.tokens.put((byte)32).putShort(this.line);
        }
        this.tokens.put(t).putShort(arg);
    }

    private byte prev(int p) {
        return this.tokens.get(p * 3 + this.tokens.position());
    }

    private void remLast() {
        this.tokens.position(this.tokens.position() - 3);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ByteBuffer buf = (ByteBuffer)this.tokens.duplicate().flip();
        while (buf.hasRemaining()) {
            byte b = buf.get();
            sb.append(OP_NAMES[b]);
            char c = buf.getChar();
            switch (b) {
                case 49: {
                    buf.position(buf.position() + 9);
                    break;
                }
                case 44: 
                case 45: 
                case 47: 
                case 48: 
                case 62: {
                    sb.append((int)c);
                }
            }
            sb.append(' ');
        }
        return sb.toString();
    }
}

