/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Text;
import java.util.Arrays;
import java.util.function.Function;
import javax.script.ScriptException;

public class Array
implements IOperand {
    public IOperand[] array;

    public Array(int cap) {
        this.array = new IOperand[cap];
    }

    public Array(IOperand[] arr, int from, int to) {
        this(to -= from);
        System.arraycopy(arr, from, this.array, 0, to);
    }

    public Array(IOperand ... arr) {
        this.array = arr;
    }

    public <T> Array(T[] objects, Function<T, IOperand> wrapper) {
        int n = objects.length;
        this.array = new IOperand[n];
        for (int i = 0; i < n; ++i) {
            this.array[i] = wrapper.apply(objects[i]);
        }
    }

    @Override
    public boolean asBool() {
        return this.array.length != 0;
    }

    @Override
    public IOperand op(int code) {
        switch (code) {
            case 22: {
                return new Number(this.array.length);
            }
            case 23: {
                return new Text(this.toString());
            }
        }
        return IOperand.super.op(code);
    }

    @Override
    public IOperand opR(int code, IOperand x) {
        IOperand[] a = this.array;
        int l = a.length;
        switch (code) {
            case 12: {
                if (x instanceof Array) {
                    IOperand[] b = ((Array)x).array;
                    int l1 = b.length;
                    IOperand[] arr = Arrays.copyOf(a, l + l1);
                    System.arraycopy(b, 0, arr, l, l1);
                    return new Array(arr);
                }
                IOperand[] arr = Arrays.copyOf(a, l + 1);
                arr[l] = x;
                return new Array(arr);
            }
            case 13: {
                if (x instanceof Array) {
                    IOperand[] b = ((Array)x).array;
                    int n = 0;
                    int[] idx = new int[l];
                    for (int i = 0; i < l; ++i) {
                        IOperand y = a[i];
                        boolean stay = true;
                        for (IOperand z : b) {
                            if (!z.equals(y)) continue;
                            stay = false;
                            break;
                        }
                        if (!stay) continue;
                        idx[n++] = i;
                    }
                    if (n == l) {
                        return this;
                    }
                    IOperand[] c = new IOperand[n];
                    for (int i = 0; i < n; ++i) {
                        c[i] = a[idx[i]];
                    }
                    return new Array(c);
                }
                for (int i = 0; i < l; ++i) {
                    if (!x.equals(a[i])) continue;
                    IOperand[] b = new IOperand[--l];
                    System.arraycopy(a, 0, b, 0, i);
                    System.arraycopy(a, i + 1, b, i, l - i);
                    return new Array(b);
                }
                return this;
            }
            case 20: {
                int i = x.asIndex();
                return i >= 0 && i < l ? a[i] : Nil.NIL;
            }
            case 6: {
                for (int i = 0; i < l; ++i) {
                    if (!x.equals(a[i])) continue;
                    return new Number(i + 1);
                }
                return Number.FALSE;
            }
            case 5: {
                if (x instanceof Array) {
                    IOperand[] b;
                    for (IOperand opB : b = ((Array)x).array) {
                        boolean found = false;
                        for (IOperand opA : a) {
                            if (!opB.equals(opA)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return Number.FALSE;
                    }
                    return Number.TRUE;
                }
                for (int i = 0; i < l; ++i) {
                    if (!x.opR(code, a[i]).asBool()) continue;
                    return new Number(i + 1);
                }
                return Number.FALSE;
            }
        }
        return IOperand.super.opR(code, x);
    }

    @Override
    public IOperand opL(int code, IOperand x) {
        switch (code) {
            case 12: {
                int l = this.array.length;
                IOperand[] arr = new IOperand[l + 1];
                arr[0] = x;
                System.arraycopy(this.array, 0, arr, 1, l);
                return new Array(arr);
            }
            case 5: 
            case 6: {
                for (IOperand op : this.array) {
                    if (x.opR(code, op).asBool()) continue;
                    return Number.FALSE;
                }
                return Number.TRUE;
            }
        }
        return IOperand.super.opL(code, x);
    }

    @Override
    public void put(IOperand idx, IOperand val) {
        int i = idx.asIndex();
        if (i >= 0 && i < this.array.length) {
            this.array[i] = val;
        }
    }

    @Override
    public void call(IOperand[] stack, int bot, int top) throws ScriptException {
        int l = this.array.length - 1;
        if (l < 0) {
            stack[bot - 1] = Nil.NIL;
            Arrays.fill(stack, bot, top, null);
        } else {
            if (top + l > stack.length) {
                throw new ScriptException("Stack overflow: Array call [" + l + "]");
            }
            System.arraycopy(this.array, 1, stack, top, l);
            this.array[0].call(stack, bot, top + l);
        }
    }

    @Override
    public IOperand.OperandIterator iterator() {
        return new Iterator();
    }

    public Object[] value() {
        int l = this.array.length;
        Object[] arr = new Object[l];
        for (int i = l - 1; i >= 0; --i) {
            arr[i] = this.array[i].value();
        }
        return arr;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    class Iterator
    implements IOperand.OperandIterator {
        int idx;

        Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < Array.this.array.length;
        }

        @Override
        public IOperand next() {
            return Array.this.array[this.idx++];
        }

        @Override
        public void set(IOperand e) {
            Array.this.array[this.idx - 1] = e;
        }

        @Override
        public void reset() {
            this.idx = 0;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}

