/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.Parser;
import cd4017be.lib.script.obj.IOperand;
import javax.annotation.Nonnull;

public class Error
extends Exception
implements IOperand {
    private static final int MAX_TRACE_DEPTH = 12;
    public final int depth;
    public final Error parent;
    public String message;

    public static Error of(Exception e) {
        if (e instanceof Error) {
            return (Error)e;
        }
        return new Error(e.toString());
    }

    public Error(String message) {
        this.depth = 0;
        this.parent = null;
        this.message = message == null ? "" : message;
    }

    public Error(@Nonnull Error parent, String message) {
        this.depth = parent.depth + 1;
        this.parent = this.depth < 12 ? parent : parent.parent;
        this.message = message == null ? "" : message;
    }

    public Error reset(String message) {
        this.message = message;
        return this;
    }

    @Override
    public boolean asBool() {
        return false;
    }

    @Override
    public IOperand.OperandIterator iterator() throws Error {
        throw new Error(this, "attempt to iterate over errored value:");
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public IOperand op(int code) {
        return new Error(this, Parser.OP_NAMES[code] + "ERROR");
    }

    @Override
    public IOperand opR(int code, IOperand x) {
        return new Error(this, "ERROR" + Parser.OP_NAMES[code] + "(" + x + ")");
    }

    @Override
    public IOperand opL(int code, IOperand x) {
        return new Error(this, "(" + x + ")" + Parser.OP_NAMES[code] + "ERROR");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.depth + ": " + this.message);
        if (this.depth >= 12) {
            sb.append(12 - this.depth + 1).append(" more operations on ERROR ...");
        }
        Error e = this.parent;
        while (e != null) {
            sb.append("\n").append(e.depth).append(": ").append(e.message);
            e = e.parent;
        }
        return sb.toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object value() {
        return this;
    }
}

