/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.Parser;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.Vector;
import javax.script.ScriptException;

public interface IOperand {
    public static final byte eq = 0;
    public static final byte neq = 1;
    public static final byte xor = 2;
    public static final byte xnor = 3;
    public static final byte ls = 4;
    public static final byte nls = 5;
    public static final byte gr = 6;
    public static final byte ngr = 7;
    public static final byte and = 8;
    public static final byte nand = 9;
    public static final byte or = 10;
    public static final byte nor = 11;
    public static final byte add = 12;
    public static final byte sub = 13;
    public static final byte mul = 14;
    public static final byte div = 15;
    public static final byte mod = 16;
    public static final byte pow = 17;
    public static final byte lsh = 18;
    public static final byte rsh = 19;
    public static final byte index = 20;
    public static final byte ref = 21;
    public static final byte len = 22;
    public static final byte text = 23;
    public static final OperandIterator NULL_IT = new OperandIterator(){

        @Override
        public IOperand next() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void set(IOperand obj) {
        }

        @Override
        public Object value() {
            return null;
        }
    };

    default public IOperand onCopy() {
        return this;
    }

    public boolean asBool();

    default public int asIndex() {
        return -1;
    }

    default public double asDouble() {
        return Double.NaN;
    }

    default public Object value() {
        return this;
    }

    default public boolean isError() {
        return false;
    }

    default public IOperand op(int code) {
        return new Error("undefined " + Parser.OP_NAMES[code] + this);
    }

    default public IOperand opR(int code, IOperand x) {
        return x.opL(code, this);
    }

    default public IOperand opL(int code, IOperand x) {
        return new Error("undefined " + x + " " + Parser.OP_NAMES[code] + " " + this);
    }

    default public void put(IOperand idx, IOperand val) {
    }

    default public IOperand get(String member) {
        return new Error(this + " has no member " + member);
    }

    default public void set(String member, IOperand va) {
    }

    default public void call(IOperand[] stack, int bot, int top) throws ScriptException {
        throw new ScriptException(this + " is not callable!");
    }

    default public OperandIterator iterator() throws Error {
        return NULL_IT;
    }

    default public boolean equals(IOperand obj) {
        Object o1 = this.value();
        Object o2 = obj.value();
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static double[] vec(IOperand[] stack, int bot, int top, int len) throws ScriptException {
        double[] v;
        if (top - bot == 1 && stack[bot] instanceof Vector) {
            v = ((Vector)stack[bot]).value;
        } else if (top >= bot) {
            v = new double[top - bot];
            int i = 0;
            while (bot < top) {
                v[i] = stack[bot].asDouble();
                ++i;
                ++bot;
            }
        } else {
            throw new ScriptException("negative arguments available for vector");
        }
        if (len >= 0 && v.length != len) {
            throw new ScriptException("expected vector of length " + len + ", got " + v.length);
        }
        return v;
    }

    public static void check(int n, int min, int max) throws ScriptException {
        if (n < min) {
            throw new ScriptException("too few arguments provided: got " + n + ", expected at least " + min);
        }
        if (n > max) {
            throw new ScriptException("too many arguments provided: got " + n + ", expected at most " + max);
        }
    }

    public static <T extends IOperand> T get(IOperand[] stack, int bot, int i, Class<T> type) throws ScriptException {
        try {
            return (T)((IOperand)type.cast(stack[bot + i]));
        }
        catch (ClassCastException e) {
            throw new ScriptException("expected " + type.getSimpleName() + " @ arg " + i + ", got " + stack[bot + i]);
        }
    }

    @FunctionalInterface
    public static interface IFunction
    extends IOperand {
        @Override
        default public boolean asBool() {
            return true;
        }

        @Override
        public void call(IOperand[] var1, int var2, int var3) throws ScriptException;
    }

    public static interface OperandIterator
    extends IOperand {
        @Override
        default public boolean asBool() {
            return this.hasNext();
        }

        public boolean hasNext();

        public IOperand next();

        public void set(IOperand var1);

        default public void reset() {
        }
    }
}

