/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.IOperand;
import java.util.function.LongBinaryOperator;

public class Number
implements IOperand {
    public static final Number TRUE = new Number(-0.0).onCopy();
    public static final Number FALSE = new Number(0.0).onCopy();
    public static final Number NAN = new Number(Double.NaN).onCopy();
    private boolean copied;
    public double value;

    public Number(double value) {
        this.value = value;
    }

    private Number of(double value) {
        if (this.copied) {
            return new Number(value);
        }
        this.value = value;
        return this;
    }

    @Override
    public Number onCopy() {
        this.copied = true;
        return this;
    }

    @Override
    public boolean asBool() {
        return Double.doubleToRawLongBits(this.value) < 0L;
    }

    @Override
    public int asIndex() {
        return (int)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public boolean isError() {
        return Double.isNaN(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public IOperand op(int code) {
        double v = this.value;
        switch (code) {
            case 13: {
                return this.of(-v);
            }
            case 12: {
                return this.of(Math.abs(v));
            }
            case 15: {
                return this.of(1.0 / v);
            }
            case 16: {
                return this.of(v - Math.floor(v));
            }
            case 22: {
                return this.of(Math.rint(v));
            }
            case 17: {
                return this.of(Math.sqrt(v));
            }
            case 5: {
                return this.of(Math.ceil(v));
            }
            case 7: {
                return this.of(Math.floor(v));
            }
            case 4: {
                return this.of(Math.nextDown(v));
            }
            case 6: {
                return this.of(Math.nextUp(v));
            }
            case 18: {
                return this.of(Math.exp(v));
            }
            case 19: {
                return this.of(Math.log(v));
            }
            case 10: {
                return this.of(Math.cos(v));
            }
            case 11: {
                return this.of(Math.acos(v));
            }
            case 8: {
                return this.of(Math.sin(v));
            }
            case 9: {
                return this.of(Math.asin(v));
            }
            case 2: {
                return this.of(Math.tan(v));
            }
            case 3: {
                return this.of(Math.atan(v));
            }
            case 0: {
                return this.of(v >= 1.0 ? 1.0 : (v <= 0.0 ? 0.0 : v));
            }
            case 1: {
                return this.of(v >= 1.0 ? 0.0 : (v <= 0.0 ? 1.0 : 1.0 - v));
            }
            case 23: {
                return this.of(Math.toDegrees(v));
            }
            case 20: {
                return this.of(Math.toRadians(v));
            }
            case 21: {
                return this.of(Math.signum(v));
            }
        }
        return IOperand.super.op(code);
    }

    @Override
    public IOperand opR(int code, IOperand x) {
        if (!(x instanceof Number)) {
            return x.opL(code, this);
        }
        double a = this.value;
        double b = ((Number)x).value;
        switch (code) {
            case 12: {
                return this.of(a + b);
            }
            case 13: {
                return this.of(a - b);
            }
            case 14: {
                return this.of(a * b);
            }
            case 15: {
                return this.of(a / b);
            }
            case 16: {
                return this.of(a % b);
            }
            case 17: {
                return this.of(Math.pow(a, b));
            }
            case 0: {
                return a == b ? TRUE : FALSE;
            }
            case 1: {
                return a != b ? TRUE : FALSE;
            }
            case 6: {
                return a > b ? TRUE : FALSE;
            }
            case 5: {
                return a >= b ? TRUE : FALSE;
            }
            case 4: {
                return a < b ? TRUE : FALSE;
            }
            case 7: {
                return a <= b ? TRUE : FALSE;
            }
            case 18: {
                return this.of(Math.scalb(a, (int)b));
            }
            case 19: {
                return this.of(Math.scalb(a, -((int)b)));
            }
            case 8: {
                return this.of(Number.and(a, b));
            }
            case 9: {
                return this.of(-Number.and(a, b));
            }
            case 10: {
                return this.of(Number.or(a, b));
            }
            case 11: {
                return this.of(-Number.or(a, b));
            }
            case 2: {
                return this.of(Number.xor(a, b));
            }
            case 3: {
                return this.of(-Number.xor(a, b));
            }
            case 22: {
                return this.of(Math.hypot(a, b));
            }
            case 20: {
                return this.of(Math.atan2(b, a));
            }
        }
        return x.opL(code, this);
    }

    static double and(double a, double b) {
        return Number.bitwise(a, b, (x, y) -> x & y);
    }

    static double or(double a, double b) {
        return Number.bitwise(a, b, (x, y) -> x | y);
    }

    static double xor(double a, double b) {
        return Number.bitwise(a, b, (x, y) -> x ^ y);
    }

    static double bitwise(double a, double b, LongBinaryOperator op) {
        long la = Double.doubleToRawLongBits(a);
        long lb = Double.doubleToRawLongBits(b);
        int expA = (int)(la >> 52) & 0x7FF;
        int expB = (int)(lb >> 52) & 0x7FF;
        if (expA == 2047 || expB == 2047) {
            return Double.NaN;
        }
        la = la & 0xFFFFFFFFFFFFFL | (expA == 0 ? 0L : 0x10000000000000L) ^ la >> 63;
        lb = lb & 0xFFFFFFFFFFFFFL | (expB == 0 ? 0L : 0x10000000000000L) ^ lb >> 63;
        int exp = expA - expB;
        if (exp < 0) {
            la >>= -exp > 63 || expB == 2047 ? 63 : -exp;
        } else if (exp > 0) {
            lb >>= exp > 63 || expA == 2047 ? 63 : exp;
        }
        exp = Math.max(expA, expB);
        la = op.applyAsLong(la, lb);
        lb = la ^ la >> 63;
        if (lb != 0L) {
            expA = Long.numberOfLeadingZeros(lb) - 11;
            lb = (exp -= expA) <= 0 ? (lb <<= expA + exp) : (long)exp << 52 | lb << expA & 0xFFFFFFFFFFFFFL;
        }
        return Double.longBitsToDouble(lb | la & Long.MIN_VALUE);
    }

    public static void main(String[] args) {
        double a = 6.953355807835004E-309;
        double b = 8.344026969402005E-309;
        System.out.println("and: " + Number.bitwise(a, b, (x, y) -> x & y));
        System.out.println("or: " + Number.bitwise(a, b, (x, y) -> x | y));
        System.out.println("xor: " + Number.bitwise(a, b, (x, y) -> x ^ y));
        System.out.println("nand: " + Number.bitwise(a, b, (x, y) -> x & y ^ 0xFFFFFFFFFFFFFFFFL));
        System.out.println("nor: " + Number.bitwise(a, b, (x, y) -> (x | y) ^ 0xFFFFFFFFFFFFFFFFL));
        System.out.println("nxor: " + Number.bitwise(a, b, (x, y) -> x ^ y ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public IOperand opL(int code, IOperand x) {
        switch (code) {
            default: 
        }
        return IOperand.super.opL(code, x);
    }

    @Override
    public IOperand.OperandIterator iterator() {
        return new IntIterator((int)Math.ceil(this.value));
    }

    @Override
    public Object value() {
        return this.value;
    }

    static class IntIterator
    implements IOperand.OperandIterator {
        final int max;
        int cur;

        public IntIterator(int max) {
            this.max = max;
            this.cur = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.max;
        }

        @Override
        public Number next() {
            return new Number(this.cur++);
        }

        @Override
        public void set(IOperand e) {
        }

        @Override
        public void reset() {
            this.cur = 0;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}

