/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import java.util.Arrays;

public class Vector
implements IOperand {
    private boolean copied;
    public final double[] value;

    public Vector(int n) {
        this.value = new double[n];
    }

    public Vector(IOperand[] args, int from, int to) {
        int n = 0;
        for (int i = from; i < to; ++i) {
            n += args[i] instanceof Vector ? ((Vector)args[i]).value.length : 1;
        }
        double[] value = new double[n];
        n = 0;
        for (int i = from; i < to; ++i) {
            IOperand op = args[i];
            if (op instanceof Vector) {
                double[] x = ((Vector)op).value;
                int l = x.length;
                System.arraycopy(x, 0, value, n, l);
                n += l;
                continue;
            }
            value[n++] = op.asDouble();
        }
        this.value = value;
    }

    private Vector of() {
        if (this.copied) {
            return new Vector(this.value.length);
        }
        return this;
    }

    @Override
    public boolean asBool() {
        return this.value.length > 0;
    }

    @Override
    public int asIndex() {
        return this.value.length == 0 ? 0 : (int)this.value[0];
    }

    @Override
    public IOperand onCopy() {
        this.copied = true;
        return this;
    }

    @Override
    public IOperand op(int code) {
        switch (code) {
            case 22: {
                return new Number(this.value.length);
            }
            case 4: {
                double y = Double.POSITIVE_INFINITY;
                for (double x : this.value) {
                    if (!(x < y)) continue;
                    y = x;
                }
                return new Number(y);
            }
            case 6: {
                double y = Double.NEGATIVE_INFINITY;
                for (double x : this.value) {
                    if (!(x > y)) continue;
                    y = x;
                }
                return new Number(y);
            }
            case 12: {
                double y = 0.0;
                for (double x : this.value) {
                    y += x;
                }
                return new Number(y);
            }
            case 14: {
                double y = 0.0;
                for (double x : this.value) {
                    y *= x;
                }
                return new Number(y);
            }
            case 8: {
                double y = -0.0;
                for (double x : this.value) {
                    y = Number.and(y, x);
                }
                return new Number(y);
            }
            case 9: {
                double y = -0.0;
                for (double x : this.value) {
                    y = Number.and(y, x);
                }
                return new Number(-y);
            }
            case 10: {
                double y = 0.0;
                for (double x : this.value) {
                    y = Number.or(y, x);
                }
                return new Number(y);
            }
            case 11: {
                double y = 0.0;
                for (double x : this.value) {
                    y = Number.or(y, x);
                }
                return new Number(-y);
            }
            case 2: {
                double y = 0.0;
                for (double x : this.value) {
                    y = Number.xor(y, x);
                }
                return new Number(y);
            }
            case 3: {
                double y = -0.0;
                for (double x : this.value) {
                    y = Number.xor(y, x);
                }
                return new Number(y);
            }
            case 13: {
                Vector ret = this.of();
                double[] a = this.value;
                double[] c = ret.value;
                for (int i = this.value.length - 1; i >= 0; --i) {
                    c[i] = -a[i];
                }
                return ret;
            }
            case 15: {
                Vector ret = this.of();
                double[] a = this.value;
                double[] c = ret.value;
                for (int i = this.value.length - 1; i >= 0; --i) {
                    c[i] = 1.0 / a[i];
                }
                return ret;
            }
            case 0: {
                if (this.value.length > 0) {
                    double y = this.value[0];
                    for (int i = 1; i < this.value.length; ++i) {
                        if (this.value[i] == y) continue;
                        return Number.FALSE;
                    }
                }
                return Number.TRUE;
            }
            case 1: {
                int l = this.value.length - 1;
                for (int i = 0; i < l; ++i) {
                    double x = this.value[i];
                    for (int j = i + 1; j <= l; ++j) {
                        if (this.value[j] == x) continue;
                        return Number.FALSE;
                    }
                }
                return Number.TRUE;
            }
            case 23: {
                double y = 0.0;
                for (double x : this.value) {
                    y += x;
                }
                return new Number(y / (double)this.value.length);
            }
        }
        return IOperand.super.op(code);
    }

    @Override
    public IOperand opR(int code, IOperand x) {
        if (code == 20) {
            int i = x.asIndex();
            if (i >= 0 && i < this.value.length) {
                return new Number(this.value[i]);
            }
            return Number.FALSE;
        }
        if (code == 17 && x instanceof Vector) {
            double[] a = this.value;
            double[] b = ((Vector)x).value;
            double y = 0.0;
            for (int i = Math.min(a.length, b.length) - 1; i >= 0; --i) {
                y += a[i] * b[i];
            }
            return new Number(y);
        }
        if (x instanceof Vector) {
            double[] b = ((Vector)x).value;
            double[] a = this.value;
            Vector r0 = b.length < a.length ? (Vector)x : this;
            Vector ret = r0.of();
            Vector.vectorOp(code, a, b, ret.value);
            return ret;
        }
        if (x instanceof Number) {
            Vector ret = this.of();
            Vector.scalarOp(code, this.value, ((Number)x).value, ret.value);
            return ret;
        }
        return x.opL(code, this);
    }

    @Override
    public IOperand opL(int code, IOperand x) {
        if (x instanceof Number) {
            Vector ret = this.of();
            Vector.scalarOp(code, ((Number)x).value, this.value, ret.value);
            return ret;
        }
        return IOperand.super.opL(code, x);
    }

    private static void scalarOp(int code, double[] a, double b, double[] c) {
        int l = c.length;
        switch (code) {
            case 12: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] + b;
                }
                break;
            }
            case 13: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] - b;
                }
                break;
            }
            case 14: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] * b;
                }
                break;
            }
            case 15: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] / b;
                }
                break;
            }
            case 16: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] % b;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.and(a[i], b);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.and(a[i], b);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.or(a[i], b);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.or(a[i], b);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.xor(a[i], b);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.xor(a[i], b);
                }
                break;
            }
            case 18: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Math.scalb(a[i], (int)b);
                }
                break;
            }
            case 19: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Math.scalb(a[i], -((int)b));
                }
                break;
            }
            case 0: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] == b ? -0.0 : 0.0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] != b ? -0.0 : 0.0;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] > b ? -0.0 : 0.0;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] <= b ? -0.0 : 0.0;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] < b ? -0.0 : 0.0;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] >= b ? -0.0 : 0.0;
                }
                break;
            }
            default: {
                Arrays.fill(c, Double.NaN);
            }
        }
    }

    private static void scalarOp(int code, double a, double[] b, double[] c) {
        int l = c.length;
        switch (code) {
            case 12: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a + b[i];
                }
                break;
            }
            case 13: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a - b[i];
                }
                break;
            }
            case 14: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a * b[i];
                }
                break;
            }
            case 15: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a / b[i];
                }
                break;
            }
            case 16: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a % b[i];
                }
                break;
            }
            case 8: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.and(a, b[i]);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.and(a, b[i]);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.or(a, b[i]);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.or(a, b[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.xor(a, b[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.xor(a, b[i]);
                }
                break;
            }
            case 18: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Math.scalb(a, (int)b[i]);
                }
                break;
            }
            case 19: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Math.scalb(a, -((int)b[i]));
                }
                break;
            }
            case 0: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a == b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a != b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a > b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a <= b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a < b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a >= b[i] ? -0.0 : 0.0;
                }
                break;
            }
            default: {
                Arrays.fill(c, Double.NaN);
            }
        }
    }

    private static void vectorOp(int code, double[] a, double[] b, double[] c) {
        int l = c.length;
        switch (code) {
            case 12: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] + b[i];
                }
                break;
            }
            case 13: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] - b[i];
                }
                break;
            }
            case 14: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] * b[i];
                }
                break;
            }
            case 15: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] / b[i];
                }
                break;
            }
            case 16: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] % b[i];
                }
                break;
            }
            case 8: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.and(a[i], b[i]);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.and(a[i], b[i]);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.or(a[i], b[i]);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.or(a[i], b[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Number.xor(a[i], b[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < l; ++i) {
                    c[i] = -Number.xor(a[i], b[i]);
                }
                break;
            }
            case 18: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Math.scalb(a[i], (int)b[i]);
                }
                break;
            }
            case 19: {
                for (int i = 0; i < l; ++i) {
                    c[i] = Math.scalb(a[i], -((int)b[i]));
                }
                break;
            }
            case 0: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] == b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] != b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] > b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] <= b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] < b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 5: {
                for (int i = 0; i < l; ++i) {
                    c[i] = a[i] >= b[i] ? -0.0 : 0.0;
                }
                break;
            }
            case 22: {
                if (l == 3) {
                    double ax = a[0];
                    double ay = a[1];
                    double az = a[2];
                    double bx = b[0];
                    double by = b[1];
                    double bz = b[2];
                    c[0] = ay * bz - az * by;
                    c[1] = az * bx - ax * bz;
                    c[2] = ax * by - ay * bx;
                    break;
                }
            }
            default: {
                Arrays.fill(c, Double.NaN);
            }
        }
    }

    @Override
    public void put(IOperand idx, IOperand val) {
        int i = idx.asIndex();
        if (i >= 0 && i < this.value.length) {
            this.value[i] = val.asDouble();
        }
    }

    @Override
    public IOperand.OperandIterator iterator() {
        return new Iterator();
    }

    @Override
    public Object value() {
        return this.value;
    }

    public String toString() {
        return Arrays.toString(this.value);
    }

    class Iterator
    implements IOperand.OperandIterator {
        int cur = 0;

        Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cur < Vector.this.value.length;
        }

        @Override
        public IOperand next() {
            return new Number(Vector.this.value[this.cur++]);
        }

        @Override
        public void set(IOperand e) {
            Vector.this.value[this.cur - 1] = e.asDouble();
        }

        @Override
        public void reset() {
            this.cur = 0;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}

