/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.text;

import cd4017be.lib.Lib;
import cd4017be.lib.text.TooltipUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.Language;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.lwjgl.glfw.GLFW;

public class TooltipEditor {
    private static final int CURSOR_BLINK_INTERVAL = 500;
    private HashMap<String, String> edited = new HashMap();
    private String editingKey;
    private String editingValue = "";
    String[] lastKeys = new String[8];
    int pos;
    int ofs;
    private int cursor;
    private int cursor2;
    private Language lastLanguage;
    private boolean specialCombo;

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        if (TooltipUtil.editor == null && ((Boolean)Lib.CFG_CLIENT.tooltipEditEnable.get()).booleanValue()) {
            TooltipUtil.editor = new TooltipEditor();
            Lib.LOG.info("ingame tooltip editor is enabled");
        }
    }

    public TooltipEditor() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.lastLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
    }

    public boolean hasEdited(String key) {
        this.pos = this.pos + 1 & 7;
        this.lastKeys[this.pos] = key;
        return key.equals(this.editingKey) || this.edited.containsKey(key);
    }

    public String getTranslation(String key) {
        this.pos = this.pos + 1 & 7;
        this.lastKeys[this.pos] = key;
        if (key.equals(this.editingKey)) {
            return this.textField();
        }
        String s = this.edited.get(key);
        if (s != null) {
            return s;
        }
        return TooltipUtil.getUnhideIllegalFormat(key);
    }

    private String textField() {
        int b;
        int a;
        if (System.currentTimeMillis() % 500L * 2L >= 500L) {
            return this.editingValue;
        }
        if (this.cursor == this.cursor2) {
            return this.put(this.cursor, "|", this.cursor);
        }
        if (this.cursor < this.cursor2) {
            a = this.cursor;
            b = this.cursor2;
        } else {
            a = this.cursor2;
            b = this.cursor;
        }
        return this.editingValue.substring(0, a) + "[" + this.editingValue.substring(a, b) + "]" + this.editingValue.substring(b);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void keyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        int k = event.getKeyCode();
        if (this.editingKey != null) {
            this.textFieldInput(k);
        } else if (k == 83 && GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)293) == 1) {
            this.specialCombo = true;
            this.save();
        } else if (k == 293) {
            Language l = Minecraft.func_71410_x().func_135016_M().func_135041_c();
            if (!l.equals((Object)this.lastLanguage)) {
                this.save();
                this.lastLanguage = l;
                this.edited.clear();
            }
        } else {
            return;
        }
        event.setCanceled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void keyReleased(GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event) {
        if (this.editingKey != null) {
            event.setCanceled(true);
        } else if (event.getKeyCode() == 293) {
            if (this.specialCombo) {
                this.specialCombo = false;
            } else {
                String key = this.lastKeys[this.pos];
                if (key != null) {
                    this.editingValue = this.getTranslation(key);
                    this.cursor = this.cursor2 = this.editingValue.length();
                    this.editingKey = key;
                    this.ofs = 0;
                    TooltipUtil.altOverride = Screen.func_231172_r_();
                    TooltipUtil.shiftOverride = Screen.func_231173_s_();
                    TooltipUtil.overrideModifiers = true;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void keyTyped(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
        if (this.editingKey == null) {
            return;
        }
        char c = event.getCodePoint();
        if (!Character.isISOControl(c)) {
            this.editingValue = this.put(this.cursor, "" + c, this.cursor2);
            this.cursor = this.cursor2 = (this.cursor < this.cursor2 ? this.cursor : this.cursor2) + 1;
        }
        event.setCanceled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void render(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (this.editingKey == null) {
            return;
        }
        Screen gui = e.getGui();
        FontRenderer fr = gui.getMinecraft().field_71466_p;
        for (int i = 0; i < 8; ++i) {
            String s;
            String string = s = i == this.ofs ? this.editingKey : this.lastKeys[this.pos - i & 7];
            if (s == null) continue;
            MatrixStack matrixStack = e.getMatrixStack();
            int n = gui.field_230709_l_;
            fr.getClass();
            fr.func_238405_a_(matrixStack, s, 5.0f, (float)(n - 9 * (i + 1) - 5), i == this.ofs ? 0xFFFF80 : (this.edited.containsKey(s) ? 0x8080FF : 0xC0C0C0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void textFieldInput(int k) {
        boolean shift = Screen.func_231173_s_();
        block0 : switch (k) {
            case 262: {
                if (shift) {
                    if (this.cursor2 >= this.editingValue.length()) break;
                    ++this.cursor2;
                    break;
                }
                if (this.cursor >= this.editingValue.length()) break;
                this.cursor2 = ++this.cursor;
                break;
            }
            case 263: {
                if (shift) {
                    if (this.cursor2 <= 0) break;
                    --this.cursor2;
                    break;
                }
                if (this.cursor <= 0) break;
                this.cursor2 = --this.cursor;
                break;
            }
            case 269: {
                this.cursor2 = this.editingValue.length();
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 268: {
                this.cursor2 = 0;
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 261: {
                if (this.cursor != this.cursor2) {
                    this.editingValue = this.put(this.cursor, "", this.cursor2);
                    this.cursor2 = this.cursor < this.cursor2 ? this.cursor : this.cursor2;
                    this.cursor = this.cursor2;
                    break;
                }
                if (this.cursor >= this.editingValue.length()) break;
                this.editingValue = this.put(this.cursor, "", this.cursor + 1);
                break;
            }
            case 259: {
                if (this.cursor != this.cursor2) {
                    this.editingValue = this.put(this.cursor, "", this.cursor2);
                    this.cursor2 = this.cursor < this.cursor2 ? this.cursor : this.cursor2;
                    this.cursor = this.cursor2;
                    break;
                }
                if (this.cursor <= 0) break;
                this.editingValue = this.put(this.cursor - 1, "", this.cursor);
                this.cursor2 = --this.cursor;
                break;
            }
            case 257: {
                this.editingValue = this.put(this.cursor, "\n", this.cursor2);
                this.cursor = this.cursor2 = (this.cursor < this.cursor2 ? this.cursor : this.cursor2) + 1;
                break;
            }
            case 265: {
                int p = this.editingValue.lastIndexOf(10, this.cursor - 1);
                int n = this.cursor2 = p < 0 ? 0 : p;
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 264: {
                int p = this.editingValue.indexOf(10, this.cursor + 1);
                int n = this.cursor2 = p < 0 ? this.editingValue.length() : p;
                if (shift) break;
                this.cursor = this.cursor2;
                break;
            }
            case 256: {
                String key = this.editingKey;
                this.editingKey = null;
                if (!this.editingValue.equals(this.getTranslation(key))) {
                    this.edited.put(key, this.editingValue);
                }
                TooltipUtil.overrideModifiers = false;
                break;
            }
            case 266: {
                if (this.ofs < 7) {
                    ++this.ofs;
                }
                String nkey = this.lastKeys[this.pos - this.ofs & 7];
                String key = this.editingKey;
                this.editingKey = null;
                if (!this.editingValue.equals(this.getTranslation(key))) {
                    this.edited.put(key, this.editingValue);
                }
                if (nkey != null) {
                    this.editingValue = this.getTranslation(nkey);
                    this.editingKey = nkey;
                    this.cursor = this.cursor2 = this.editingValue.length();
                    break;
                }
                TooltipUtil.overrideModifiers = false;
                break;
            }
            case 267: {
                if (this.ofs > 0) {
                    --this.ofs;
                }
                String nkey = this.lastKeys[this.pos - this.ofs & 7];
                String key = this.editingKey;
                this.editingKey = null;
                if (!this.editingValue.equals(this.getTranslation(key))) {
                    this.edited.put(key, this.editingValue);
                }
                if (nkey != null) {
                    this.editingValue = this.getTranslation(nkey);
                    this.editingKey = nkey;
                    this.cursor = this.cursor2 = this.editingValue.length();
                    break;
                }
                TooltipUtil.overrideModifiers = false;
                break;
            }
            default: {
                if (!Screen.func_231172_r_() || shift || Screen.func_231174_t_()) break;
                switch (k) {
                    case 67: {
                        if (this.cursor == this.cursor2) break block0;
                        TooltipUtil.setClipboardString(this.get(this.cursor, this.cursor2));
                        break block0;
                    }
                    case 88: {
                        if (this.cursor == this.cursor2) break block0;
                        TooltipUtil.setClipboardString(this.get(this.cursor, this.cursor2));
                        this.editingValue = this.put(this.cursor, "", this.cursor2);
                        this.cursor2 = this.cursor < this.cursor2 ? this.cursor : this.cursor2;
                        this.cursor = this.cursor2;
                        break block0;
                    }
                    case 86: {
                        String s = TooltipUtil.getClipboardString();
                        this.editingValue = this.put(this.cursor, s, this.cursor2);
                        this.cursor = this.cursor2 = (this.cursor < this.cursor2 ? this.cursor : this.cursor2) + s.length();
                        break block0;
                    }
                    case 65: {
                        this.cursor = 0;
                        this.cursor2 = this.editingValue.length();
                        break block0;
                    }
                    case 83: {
                        this.edited.put(this.editingKey, this.editingValue);
                        break block0;
                    }
                    case 90: {
                        String s = this.edited.get(this.editingKey);
                        if (s == null) break block0;
                        this.editingValue = s;
                        if (this.cursor > this.editingValue.length()) {
                            this.cursor = this.editingValue.length();
                        }
                        this.cursor2 = this.cursor;
                    }
                }
            }
        }
    }

    private String put(int start, String repl, int end) {
        if (end < start) {
            int x = start;
            start = end;
            end = x;
        }
        return this.editingValue.substring(0, start) + repl + this.editingValue.substring(end);
    }

    private String get(int start, int end) {
        if (end < start) {
            int x = start;
            start = end;
            end = x;
        }
        return this.editingValue.substring(start, end);
    }

    public void save() {
        JsonObject jo;
        Throwable throwable;
        if (this.edited.isEmpty()) {
            return;
        }
        File file = FMLPaths.GAMEDIR.get().resolve((String)Lib.CFG_CLIENT.tooltipEditPath.get()).toFile();
        file.mkdirs();
        file = new File(file, this.lastLanguage.getCode() + ".json");
        try {
            throwable = null;
            try (JsonReader jr = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                jo = Streams.parse((JsonReader)jr).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException e) {
            jo = new JsonObject();
        }
        catch (IOException | RuntimeException e) {
            Lib.LOG.error("TooltipEditor failed reading existing lang file: " + file, (Throwable)e);
            return;
        }
        for (Map.Entry<String, String> e : this.edited.entrySet()) {
            jo.addProperty(e.getKey(), TooltipUtil.hideIllegalFormat(e.getValue()));
        }
        try {
            throwable = null;
            try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                jw.setIndent("  ");
                Streams.write((JsonElement)jo, (JsonWriter)jw);
                Lib.LOG.info("TooltipEditor modified {} lang entries", (Object)this.edited.size());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            Lib.LOG.error("TooltipEditor failed saving changes to lang file: " + file, (Throwable)e);
        }
    }
}

