/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.text;

import cd4017be.lib.Lib;
import cd4017be.lib.text.TooltipEditor;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.Direction;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLLoader;
import org.lwjgl.glfw.GLFW;

public class TooltipUtil {
    public static final TranslationTextComponent EXT_TOOLTIP_HINT = new TranslationTextComponent("cd4017be_lib.ext");
    public static final TranslationTextComponent TOOLTIP_HINT = new TranslationTextComponent("cd4017be_lib.info");
    public static final StringTextComponent EMPTY = new StringTextComponent("");
    private static final Pattern numberFormat = Pattern.compile("%(?:(\\d+)\\$)?(?:(-?\\d?)\\.(\\d+))?u");
    public static TooltipEditor editor;
    public static boolean shiftOverride;
    public static boolean altOverride;
    public static boolean overrideModifiers;
    private static final String[] DecScale;
    public static final double[] ScaleUnits;
    public static final double[] exp10;

    @OnlyIn(value=Dist.CLIENT)
    public static boolean showShiftHint() {
        return (Boolean)Lib.CFG_CLIENT.shiftForMainTooltip.get() == false || (overrideModifiers ? shiftOverride : Screen.func_231173_s_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean showAltHint() {
        return overrideModifiers ? altOverride : Screen.func_231172_r_();
    }

    public static String format(String s, Object ... args) {
        s = TooltipUtil.translate(s).trim().replace("\\n", "\n");
        try {
            Matcher m = numberFormat.matcher(s);
            String s1 = "";
            while (m.find()) {
                double val = 0.0;
                int exp = 0;
                int n = 3;
                String g = m.group(1);
                if (g != null) {
                    val = ((Number)args[Integer.parseInt(g)]).doubleValue();
                } else {
                    for (int i = 0; i < args.length; ++i) {
                        if (!(args[i] instanceof Number)) continue;
                        val = ((Number)args[i]).doubleValue();
                        Object[] nargs = new Object[args.length - 1];
                        if (i > 0) {
                            System.arraycopy(args, 0, nargs, 0, i);
                        }
                        if (i < nargs.length) {
                            System.arraycopy(args, i + 1, nargs, i, nargs.length - i);
                        }
                        args = nargs;
                        break;
                    }
                }
                g = m.group(2);
                if (g != null && !g.isEmpty()) {
                    exp = Integer.parseInt(g);
                }
                if ((g = m.group(3)) != null) {
                    n = Integer.parseInt(g);
                }
                s1 = s1 + s.substring(0, m.start()) + TooltipUtil.formatNumber(val, n, exp);
                s = s.substring(m.end());
                m.reset(s);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Boolean) {
                    args[i] = TooltipUtil.translate((Boolean)args[i] != false ? "gui.yes" : "gui.no");
                    continue;
                }
                if (!(args[i] instanceof Direction)) continue;
                args[i] = TooltipUtil.translate("enumfacing." + args[i]);
            }
            return String.format(s1 + s, args);
        }
        catch (IllegalFormatException e) {
            return s + "\n" + e.toString();
        }
    }

    public static String translate(String s) {
        return s.startsWith("\\") ? s.substring(1) : (editor != null ? editor.getTranslation(s) : TooltipUtil.getUnhideIllegalFormat(s));
    }

    static String getUnhideIllegalFormat(String key) {
        return LanguageMap.func_74808_a().func_230503_a_(key).replaceAll("%s", "%");
    }

    static String hideIllegalFormat(String s) {
        return s.replaceAll("%", "%s");
    }

    public static boolean hasTranslation(String s) {
        return LanguageMap.func_74808_a().func_230506_b_(s) || editor != null && editor.hasEdited(s);
    }

    public static String formatNumber(double x, int w, int c) {
        return TooltipUtil.formatNumber(x, w, c < 0 ? 1.0 / exp10[-c] : exp10[c], false, true);
    }

    public static String formatNumber(double x, int w, double c, boolean sign, boolean trim) {
        if (w < 0 || w >= exp10.length) {
            throw new IllegalArgumentException("invalid width " + w);
        }
        if (Double.isNaN(x)) {
            return "NaN";
        }
        StringBuilder sb = new StringBuilder(w + 3);
        if (x < 0.0) {
            sb.append('-');
            x = -x;
        } else if (sign) {
            sb.append('+');
        }
        int i = Arrays.binarySearch(ScaleUnits, x / c);
        if (i < 0) {
            i = -2 - i;
        }
        if (i < 0) {
            return sb.append('0').toString();
        }
        if (i >= DecScale.length) {
            return sb.append("Infinity").toString();
        }
        int y = (int)Math.floor(x /= ScaleUnits[i]);
        w += sb.length();
        int p = sb.append(y).length();
        x -= (double)y;
        if ((w -= p) > 0) {
            y = (int)Math.round(x *= exp10[w]);
            while (w > 0) {
                int z;
                if ((y -= (z = y / 10) * 10) != 0 || !trim) {
                    sb.insert(p, (char)(48 + y));
                    trim = false;
                }
                y = z;
                --w;
            }
        }
        if (!trim) {
            sb.insert(p, '.');
        }
        return sb.append(DecScale[i]).toString();
    }

    public static String formatNumber(double x, int w) {
        String ds;
        String tex = String.format("%." + w + "f", x);
        if (tex.contains(ds = "" + DecimalFormatSymbols.getInstance().getDecimalSeparator())) {
            while (tex.endsWith("0")) {
                tex = tex.substring(0, tex.length() - 1);
            }
            if (tex.endsWith(ds)) {
                tex = tex.substring(0, tex.length() - 1);
            }
        }
        return tex;
    }

    public static List<IFormattableTextComponent> convertText(String text) {
        String[] lines = text.split("\n");
        ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>(lines.length);
        for (String s : lines) {
            list.add(TooltipUtil.convert(s));
        }
        return list;
    }

    public static List<IFormattableTextComponent> convertText(List<String> text) {
        ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>(text.size());
        for (String s : text) {
            list.add(TooltipUtil.convert(s));
        }
        return list;
    }

    public static IFormattableTextComponent convert(String s) {
        return new StringTextComponent(s);
    }

    public static IFormattableTextComponent cTranslate(String s) {
        return TooltipUtil.convert(TooltipUtil.translate(s));
    }

    public static IFormattableTextComponent cFormat(String s, Object ... args) {
        return TooltipUtil.convert(TooltipUtil.format(s, args));
    }

    public static String getClipboardString() {
        String s = GLFW.glfwGetClipboardString((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i());
        return s == null ? "" : s;
    }

    public static void setClipboardString(String s) {
        GLFW.glfwSetClipboardString((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (CharSequence)s);
    }

    static {
        shiftOverride = true;
        altOverride = false;
        overrideModifiers = FMLLoader.getDist() == Dist.DEDICATED_SERVER;
        DecScale = new String[]{"a", "f", "p", "n", "\u00b5", "m", "", "k", "M", "G", "T", "P", "E"};
        ScaleUnits = new double[]{1.0E-18, 1.0E-15, 1.0E-12, 1.0E-9, 1.0E-6, 0.001, 1.0, 1000.0, 1000000.0, 1.0E9, 1.0E12, 1.0E15, 1.0E18, 1.0E21};
        exp10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15};
    }
}

