/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tick;

import cd4017be.lib.tick.IGate;
import cd4017be.lib.tick.ISlowTickable;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GateUpdater
implements Consumer<TickEvent.ServerTickEvent> {
    private static final Logger LOG = LogManager.getLogger();
    public static GateUpdater GATE_UPDATER;
    public static int TICK;
    public final MinecraftServer server;
    private IGate[] updateQueue;
    private ISlowTickable[] slowTicks;
    private int start;
    private int end;
    private int mask;
    private int slowCount;
    private boolean evaluating;
    private int steps = -1;
    private static final SimpleCommandExceptionType ERROR_NOT_PAUSED;

    public GateUpdater(MinecraftServer server) {
        this.server = server;
        this.updateQueue = new IGate[16];
        this.mask = 15;
        this.slowTicks = new ISlowTickable[8];
        this.end = 0;
        this.start = 0;
        this.slowCount = 0;
    }

    public void add(IGate update) {
        if (this.evaluating) {
            throw new IllegalStateException("Scheduling gate updates is not allowed during evaluation!");
        }
        this.updateQueue[this.end] = update;
        this.end = this.end + 1 & this.mask;
        if (this.end == this.start) {
            this.grow();
        }
    }

    public void add(ISlowTickable update) {
        if (this.slowCount >= this.slowTicks.length) {
            this.slowTicks = Arrays.copyOf(this.slowTicks, this.slowCount << 1);
        }
        this.slowTicks[this.slowCount++] = update;
    }

    @Override
    public void accept(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        IProfiler profiler = this.server.func_213185_aS();
        profiler.func_76320_a("GateUpdater");
        ++TICK;
        if (this.start != this.end && this.steps != 0) {
            this.tickGates(profiler);
        }
        if ((TICK & 7) < this.slowCount) {
            this.tickSlow(profiler);
        }
        profiler.func_76319_b();
    }

    private void tickGates(IProfiler profiler) {
        IGate g;
        int e;
        if (this.steps > 0) {
            --this.steps;
        }
        profiler.func_76320_a("evaluate");
        this.evaluating = true;
        IGate[] queue = this.updateQueue;
        int m = this.mask;
        int j = e = this.end;
        int i = this.start;
        while (i != e) {
            g = queue[i];
            queue[i] = null;
            if (g.evaluate()) {
                queue[j] = g;
                j = j + 1 & m;
            }
            i = i + 1 & m;
        }
        this.evaluating = false;
        this.start = e;
        this.end = j;
        profiler.func_219895_b("latchOut");
        i = e;
        while (i != j) {
            this.start = this.start + 1 & this.mask;
            g = queue[i];
            queue[i] = null;
            g.latchOut();
            i = i + 1 & m;
        }
        profiler.func_76319_b();
    }

    private void tickSlow(IProfiler profiler) {
        profiler.func_76320_a("tick8");
        for (int i = TICK & 7; i < this.slowCount; i += 8) {
            if (this.slowTicks[i].tick8()) continue;
            this.slowTicks[i] = this.slowTicks[--this.slowCount];
            this.slowTicks[this.slowCount] = null;
            i -= 8;
        }
        profiler.func_76319_b();
    }

    private void grow() {
        int l = this.updateQueue.length;
        IGate[] arr = new IGate[l << 1];
        System.arraycopy(this.updateQueue, this.start, arr, 0, l - this.start);
        System.arraycopy(this.updateQueue, 0, arr, l - this.start, this.start);
        this.updateQueue = arr;
        this.mask = arr.length - 1;
        this.start = 0;
        this.end = l;
    }

    private int count() {
        return this.end - this.start & this.mask;
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerAboutToStartEvent event) {
        if (GATE_UPDATER != null) {
            return;
        }
        GATE_UPDATER = new GateUpdater(event.getServer());
        MinecraftForge.EVENT_BUS.addListener((Consumer)GATE_UPDATER);
        TICK = 0;
        LOG.info("GATE_UPDATER started");
    }

    @SubscribeEvent
    public static void onServerStop(FMLServerStoppingEvent event) {
        if (GATE_UPDATER == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)GATE_UPDATER);
        LOG.info("GATE_UPDATER shut down: had {} active gate updates and {} slow ticks", (Object)GATE_UPDATER.count(), (Object)GateUpdater.GATE_UPDATER.slowCount);
        GATE_UPDATER = null;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"gateUpdater").executes(GateUpdater::cmd_count)).requires(src -> src.func_197034_c(2))).then(Commands.func_197057_a((String)"pause").executes(GateUpdater::cmd_pause))).then(Commands.func_197057_a((String)"resume").executes(GateUpdater::cmd_resume))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"step").executes(GateUpdater::cmd_step)).then(Commands.func_197056_a((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(GateUpdater::cmd_step))));
    }

    private static int cmd_count(CommandContext<CommandSource> cont) {
        int n = GATE_UPDATER.count();
        int s = GateUpdater.GATE_UPDATER.steps;
        ((CommandSource)cont.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(s < 0 ? "command.cd4017be.ticking" : "command.cd4017be.stepping", new Object[]{n, s}), true);
        return s;
    }

    private static int cmd_pause(CommandContext<CommandSource> cont) {
        GateUpdater.GATE_UPDATER.steps = 0;
        ((CommandSource)cont.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.cd4017be.paused"), true);
        return 0;
    }

    private static int cmd_resume(CommandContext<CommandSource> cont) {
        GateUpdater.GATE_UPDATER.steps = -1;
        ((CommandSource)cont.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.cd4017be.resumed"), true);
        return 0;
    }

    private static int cmd_step(CommandContext<CommandSource> cont) throws CommandSyntaxException {
        int s = GateUpdater.GATE_UPDATER.steps;
        if (s < 0) {
            throw ERROR_NOT_PAUSED.create();
        }
        try {
            s = (Integer)cont.getArgument("ticks", Integer.class);
        }
        catch (IllegalArgumentException e) {
            s = 1;
        }
        GateUpdater.GATE_UPDATER.steps = s;
        return GateUpdater.cmd_count(cont);
    }

    static {
        ERROR_NOT_PAUSED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("command.cd4017be.not_paused"));
    }
}

