/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridItem;
import cd4017be.lib.Content;
import cd4017be.lib.Lib;
import cd4017be.lib.block.BlockTE;
import cd4017be.lib.container.ContainerAssembler;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.Sync;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.SaferFakePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class Assembler
extends BaseTileEntity
implements BaseTileEntity.ITickableServerOnly,
IItemHandlerModifiable,
IUnnamedContainerProvider,
BlockTE.ITEBreak {
    final ArrayList<ItemStack> disassembly = new ArrayList();
    final ItemStack[] inventory = new ItemStack[23];
    ItemStack[] assembly;
    short[] counts;
    @Sync
    public long hasSlot;
    @Sync(type=Sync.Type.Fix)
    public final byte[] refs = new byte[23];
    @Sync(type=Sync.Type.I16)
    public int maxDA;
    @Sync(type=Sync.Type.I16)
    public int remDA;
    @Sync(type=Sync.Type.I16)
    public int maxASS;
    @Sync(type=Sync.Type.I16)
    public int countASS;
    @Sync(type=Sync.Type.I8)
    public int idxDA;
    @Sync(type=Sync.Type.I8)
    public int t;
    boolean canDA = true;
    boolean updateASS = true;
    LazyOptional<IItemHandler> inv_main;
    LazyOptional<IItemHandler> inv_out;
    LazyOptional<IItemHandler> inv_top;
    SaferFakePlayer player;

    public Assembler(TileEntityType<?> type) {
        super(type);
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        int i;
        ItemStack stack;
        if (--this.t > 0) {
            return;
        }
        this.t = 5;
        if (!this.disassembly.isEmpty()) {
            if (--this.idxDA < 0) {
                this.idxDA = this.disassembly.size() - 1;
            }
            stack = this.disassembly.get(this.idxDA);
            this.remDA -= stack.func_190916_E();
            if ((stack = ItemHandlerHelper.insertItemStacked((IItemHandler)this, (ItemStack)stack, (boolean)false)).func_190926_b()) {
                this.disassembly.remove(this.idxDA);
            } else {
                this.remDA += stack.func_190916_E();
                this.disassembly.set(this.idxDA, stack);
            }
        } else if (this.canDA && this.disassemble(stack = this.inventory[0])) {
            stack.func_190918_g(1);
            this.maxDA = 0;
            for (ItemStack stack1 : this.disassembly) {
                this.maxDA += stack1.func_190916_E();
            }
            this.remDA = this.maxDA;
        } else {
            this.canDA = false;
            this.remDA = 0;
        }
        if (!this.updateASS || this.counts == null) {
            return;
        }
        this.updateASS = false;
        int n = 0;
        int j = 2;
        block1: for (i = 0; i < this.counts.length; ++i) {
            short m = this.counts[i];
            if (m >= 0) continue;
            n += m;
            if ((this.hasSlot >> i & 1L) != 0L) continue;
            while (j < 23) {
                if (this.refs[j] < 0) {
                    this.refs[j] = (byte)(i + 1);
                    this.inventory[j] = this.assembly[i].func_77946_l();
                    this.inventory[j].func_190920_e(1);
                    this.hasSlot |= 1L << i;
                    continue block1;
                }
                ++j;
            }
        }
        this.countASS = this.maxASS + n;
        if (n < 0) {
            return;
        }
        stack = this.inventory[1];
        if (stack.func_190916_E() > stack.func_77976_d()) {
            return;
        }
        stack.func_190917_f(1);
        for (i = 0; i < this.counts.length; ++i) {
            int n2 = i;
            this.counts[n2] = (short)(this.counts[n2] - this.assembly[i].func_190916_E());
        }
        this.hasSlot = 0L;
        this.updateASS = true;
    }

    private PlayerEntity fakePlayer() {
        if (this.player != null) {
            return this.player;
        }
        this.player = new SaferFakePlayer((ServerWorld)this.field_145850_b, SaferFakePlayer.DEFAULT_PROFILE);
        this.player.func_226286_f_((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        return this.player;
    }

    private boolean disassemble(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_190931_a) {
            return false;
        }
        if (item != Content.grid) {
            if (!((Boolean)Lib.CFG_SERVER.canCutBlocks.get()).booleanValue()) {
                return false;
            }
            if ((stack = Content.microblock.convert(stack, this.field_145850_b, this.fakePlayer(), this.field_174879_c)).func_190926_b()) {
                return false;
            }
            this.disassembly.add(stack);
            return true;
        }
        ListNBT list = stack.func_190925_c("BlockEntityTag").func_150295_c("parts", 10);
        int j0 = this.disassembly.size();
        block0: for (int i = 0; i < list.size(); ++i) {
            GridPart part = GridPart.load(null, list.func_150305_b(i), 1);
            if (part == null) continue;
            if (part.dissassemble(this.field_145850_b, this.field_174879_c)) {
                CompoundNBT nbt = new CompoundNBT();
                part.storeState(nbt, 1);
                list.set(i, (INBT)nbt);
            }
            if ((stack = part.asItemStack()).func_190926_b()) continue;
            int j1 = this.disassembly.size();
            for (int j = j0; j < j1; ++j) {
                ItemStack stack1 = this.disassembly.get(j);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stack1)) continue;
                stack1.func_190917_f(stack.func_190916_E());
                continue block0;
            }
            this.disassembly.add(stack);
        }
        return true;
    }

    private void cancelAssemble() {
        int i;
        if (this.assembly == null) {
            return;
        }
        for (i = 0; i < this.counts.length; ++i) {
            ItemStack stack = this.assembly[i];
            stack.func_190917_f((int)this.counts[i]);
            int n = stack.func_190916_E();
            if (n <= 0) continue;
            this.disassembly.add(stack);
            this.remDA += n;
            this.maxDA += n;
        }
        for (i = 2; i < 23; ++i) {
            if (this.refs[i] == 0) continue;
            this.inventory[i] = ItemStack.field_190927_a;
            this.refs[i] = 0;
        }
        this.assembly = null;
        this.counts = null;
        this.hasSlot = 0L;
        this.updateASS = false;
        this.countASS = 0;
    }

    private void startAssemble(ItemStack stack) {
        int l = this.disassembly.size();
        if (!((Boolean)Lib.CFG_SERVER.canReplicate.get()).booleanValue() || !this.disassemble(stack)) {
            return;
        }
        List<ItemStack> list = this.disassembly.subList(l, this.disassembly.size());
        l = list.size();
        this.assembly = list.toArray(new ItemStack[l]);
        list.clear();
        this.counts = new short[l];
        for (int j = 2; j < 23; ++j) {
            stack = this.inventory[j];
            int n = stack.func_190916_E();
            for (int i = 0; n > 0 && i < l; ++i) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)this.assembly[i])) continue;
                int n2 = i;
                this.counts[n2] = (short)(this.counts[n2] + n);
                this.inventory[j] = ItemStack.field_190927_a;
                n = 0;
            }
            if (n > 0) continue;
            this.refs[j] = -1;
        }
        this.hasSlot = 0L;
        this.countASS = 0;
        this.maxASS = 0;
        for (int i = 0; i < l; ++i) {
            int m = this.assembly[i].func_190916_E();
            this.maxASS += m;
            this.countASS += m;
            int n = i;
            this.counts[n] = (short)(this.counts[n] - m);
            short n3 = this.counts[n];
            if (n3 >= 0) continue;
            this.countASS += n3;
        }
        this.updateASS = true;
    }

    private ItemStack insertAssemble(int slot, ItemStack stack, boolean simulate) {
        int ref = this.refs[slot] - 1;
        if (ref < 0) {
            return stack;
        }
        ItemStack stack1 = this.assembly[ref];
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stack1)) {
            return stack;
        }
        if (simulate) {
            return ItemStack.field_190927_a;
        }
        int n = stack.func_190916_E();
        this.countASS += n;
        int n2 = ref;
        this.counts[n2] = (short)(this.counts[n2] + n);
        if ((n = (int)this.counts[n2]) >= 0) {
            this.countASS -= n;
            this.inventory[slot] = ItemStack.field_190927_a;
            this.refs[slot] = -1;
            this.updateASS = true;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlots() {
        return 23;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot];
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (this.refs[slot] != 0) {
            return this.insertAssemble(slot, stack, simulate);
        }
        ItemStack stack0 = this.inventory[slot];
        int n = stack0.func_190916_E();
        int m = Math.min(stack.func_77976_d() - n, stack.func_190916_E());
        if (m <= 0 || n > 0 && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack0, (ItemStack)stack)) {
            return stack;
        }
        if (!simulate) {
            if (n > 0) {
                stack0.func_190917_f(m);
            } else {
                stack = stack.func_77946_l();
                stack.func_190920_e(m);
                this.inventory[slot] = stack;
                this.canDA |= slot == 0;
                if (slot == 1) {
                    this.startAssemble(stack);
                }
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - m));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.refs[slot] != 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.inventory[slot];
        if ((amount = Math.min(amount, stack.func_190916_E())) <= 0) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
        }
        if (amount >= stack.func_190916_E()) {
            this.inventory[slot] = ItemStack.field_190927_a;
            if (slot == 1) {
                this.cancelAssemble();
            } else if (slot != 0 && this.assembly != null) {
                this.refs[slot] = -1;
                this.updateASS = true;
            }
            return stack;
        }
        this.updateASS |= slot == 1;
        return stack.func_77979_a(amount);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot < 2 ^ stack.func_77973_b() instanceof IGridItem;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        if ((mode & 1) != 0) {
            nbt.func_218657_a("inv", (INBT)ItemFluidUtil.saveInventory(this.inventory));
            ListNBT list = new ListNBT();
            for (ItemStack stack : this.disassembly) {
                list.add((Object)ItemFluidUtil.saveItemHighRes(stack));
            }
            nbt.func_218657_a("disass", (INBT)list);
            if (this.assembly != null) {
                list = new ListNBT();
                for (int i = 0; i < this.assembly.length; ++i) {
                    CompoundNBT tag = ItemFluidUtil.saveItemHighRes(this.assembly[i]);
                    tag.func_74777_a("fill", this.counts[i]);
                    list.add((Object)tag);
                }
                nbt.func_218657_a("assembly", (INBT)list);
            }
        }
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        if ((mode & 1) != 0) {
            ItemFluidUtil.loadInventory(nbt.func_150295_c("inv", 10), this.inventory);
            ListNBT list = nbt.func_150295_c("disass", 10);
            this.disassembly.clear();
            for (int i = 0; i < list.size(); ++i) {
                this.disassembly.add(ItemFluidUtil.loadItemHighRes(list.func_150305_b(i)));
            }
            if (nbt.func_150297_b("assembly", 9)) {
                list = nbt.func_150295_c("assembly", 10);
                int l = list.size();
                this.assembly = new ItemStack[l];
                this.counts = new short[l];
                for (int i = 0; i < l; ++i) {
                    CompoundNBT tag = list.func_150305_b(i);
                    this.counts[i] = tag.func_74765_d("fill");
                    this.assembly[i] = ItemFluidUtil.loadItemHighRes(tag);
                }
            }
        }
    }

    public ContainerAssembler createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerAssembler(id, inv, this, this);
    }

    @Sync(to=-2147483648)
    public float progressDA() {
        return -((float)this.remDA) / (float)this.maxDA;
    }

    @Sync(to=-2147483648)
    public float progressASS() {
        return -((float)this.countASS) / (float)this.maxASS;
    }

    public short count(int slot) {
        return (slot = this.refs[slot + 2] - 1) < 0 ? (short)(slot + 2) : this.counts[slot];
    }

    @Override
    public void onBreak(BlockState newState, boolean moving) {
        this.cancelAssemble();
        for (ItemStack stack : this.inventory) {
            ItemFluidUtil.dropStack(stack, this.field_145850_b, this.field_174879_c);
        }
        for (ItemStack stack : this.disassembly) {
            ItemFluidUtil.dropStack(stack, this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void onLoad() {
        this.inv_top = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this, 1, 2));
        this.inv_main = LazyOptional.of(() -> new InvMain());
        this.inv_out = LazyOptional.of(() -> new InvOut());
        super.onLoad();
    }

    protected void invalidateCaps() {
        this.inv_top.invalidate();
        this.inv_main.invalidate();
        this.inv_out.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(cap, side);
        }
        switch (side) {
            case UP: {
                return this.inv_top.cast();
            }
            case DOWN: {
                return this.inv_out.cast();
            }
        }
        return this.inv_main.cast();
    }

    private class InvMain
    implements IItemHandler {
        private InvMain() {
        }

        public int getSlots() {
            return 22;
        }

        public ItemStack getStackInSlot(int slot) {
            return Assembler.this.getStackInSlot(slot == 0 ? 0 : slot + 1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return Assembler.this.insertItem(slot == 0 ? 0 : slot + 1, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return Assembler.this.extractItem(slot == 0 ? 0 : slot + 1, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return Assembler.this.getSlotLimit(slot == 0 ? 0 : slot + 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return Assembler.this.isItemValid(slot == 0 ? 0 : slot + 1, stack);
        }
    }

    private class InvOut
    implements IItemHandler {
        private InvOut() {
        }

        public int getSlots() {
            return 22;
        }

        public ItemStack getStackInSlot(int slot) {
            return Assembler.this.getStackInSlot(slot + 1);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && (amount = Math.min(amount, Assembler.this.inventory[1].func_190916_E() - 1)) <= 0) {
                return ItemStack.field_190927_a;
            }
            return Assembler.this.extractItem(slot + 1, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return Assembler.this.getSlotLimit(slot + 1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }
}

