/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.lib.block.OrientedBlock;
import cd4017be.lib.network.INBTSynchronized;
import cd4017be.lib.util.Orientation;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class BaseTileEntity
extends TileEntity
implements INBTSynchronized {
    private Chunk chunk;
    public boolean unloaded = true;
    protected boolean redraw;
    protected boolean sent;
    public static final int REDRAW = 16;
    public static final AxisAlignedBB DONT_RENDER = new AxisAlignedBB(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);

    public BaseTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public boolean unloaded() {
        return this.unloaded;
    }

    public Chunk getChunk() {
        if (this.chunk == null) {
            this.chunk = (Chunk)this.field_145850_b.func_217353_a(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4, ChunkStatus.field_222617_m, false);
        }
        return this.chunk;
    }

    public void saveDirty() {
        if (this.unloaded) {
            return;
        }
        Chunk c = this.getChunk();
        if (c != null) {
            c.func_76630_e();
        }
    }

    public void clientDirty(boolean redraw) {
        if (this.unloaded) {
            return;
        }
        if (this.sent) {
            this.sent = false;
            this.redraw = false;
        }
        this.redraw |= redraw;
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        this.saveDirty();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.storeState(nbt, 1);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadState(nbt, 1);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.storeState(nbt, 2);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadState(nbt, 2);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        int i = 4 | (this.redraw ? 16 : 0);
        this.storeState(nbt, i);
        if (nbt.isEmpty()) {
            return null;
        }
        this.sent = true;
        return new SUpdateTileEntityPacket(this.field_174879_c, i, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        int i = pkt.func_148853_f();
        this.loadState(nbt, 4 | i);
        this.redraw = (i & 0x10) != 0;
        if (this.redraw) {
            this.requestModelDataUpdate();
            BlockState state = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K ? this instanceof ITickableServerOnly : this instanceof ITickableClientOnly) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        if (!this.unloaded) {
            this.func_145836_u();
        }
        this.unloaded = false;
    }

    protected void onUnload() {
    }

    public void onChunkUnloaded() {
        this.chunk = null;
        this.unloaded = true;
        this.onUnload();
        this.invalidateCaps();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chunk = null;
        this.unloaded = true;
        this.onUnload();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c);
    }

    public Orientation orientation() {
        BlockState state = this.func_195044_w();
        Block block = state.func_177230_c();
        if (block instanceof OrientedBlock) {
            return (Orientation)((Object)state.func_177229_b((Property)((OrientedBlock)block).orientProp));
        }
        return Orientation.S12;
    }

    @Nullable
    public Chunk getChunk(BlockPos pos, boolean loadChunks) {
        int cx = pos.func_177958_n() >> 4;
        int cz = pos.func_177952_p() >> 4;
        ChunkPos cp = this.getChunk().func_76632_l();
        return cx == cp.field_77276_a && cz == cp.field_77275_b ? this.chunk : (Chunk)this.field_145850_b.func_217353_a(cx, cz, ChunkStatus.field_222617_m, loadChunks);
    }

    public BlockState getBlockState(BlockPos pos, boolean loadChunks) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        Chunk c = this.getChunk(pos, loadChunks);
        return c != null ? c.func_180495_p(pos) : Blocks.field_201940_ji.func_176223_P();
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, boolean loadChunks) {
        if (World.func_189509_E((BlockPos)pos)) {
            return null;
        }
        Chunk c = this.getChunk(pos, loadChunks);
        return c != null ? c.func_177424_a(pos, Chunk.CreateEntityType.IMMEDIATE) : null;
    }

    @Nullable
    public TileEntity getNeighborTileEntity(Direction side, boolean loadChunks) {
        return this.getTileEntity(this.field_174879_c.func_177972_a(side), loadChunks);
    }

    public <T> T getNeighborCapability(Direction side, Capability<T> cap, T empty) {
        TileEntity te = this.getTileEntity(this.field_174879_c.func_177972_a(side), false);
        return (T)(te != null ? te.getCapability(cap, side.func_176734_d()).orElse(empty) : empty);
    }

    public <T> boolean updateNeighborCapability(Direction side, Capability<T> cap, Consumer<T> cache, T empty) {
        TileEntity te = this.getTileEntity(this.field_174879_c.func_177972_a(side), false);
        if (te == null) {
            cache.accept(empty);
            return false;
        }
        LazyOptional oc = te.getCapability(cap, side);
        cache.accept(oc.orElse(empty));
        if (oc.isPresent()) {
            oc.addListener(op -> {
                if (!this.updateNeighborCapability(side, cap, cache, empty)) {
                    this.onNeighbourRemoved(side);
                }
            });
        }
        return true;
    }

    protected void onNeighbourRemoved(Direction side) {
    }

    public static interface ITickableClientOnly
    extends ITickableTileEntity {
    }

    public static interface ITickableServerOnly
    extends ITickableTileEntity {
    }
}

