/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.lib.block.BlockTE;
import cd4017be.lib.capability.CachedCap;
import cd4017be.lib.capability.NullEnergyStorage;
import cd4017be.lib.container.ContainerEnergySupply;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.tileentity.BaseTileEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergySupply
extends BaseTileEntity
implements IEnergyStorage,
BaseTileEntity.ITickableServerOnly,
BlockTE.ITENeighborChange,
IUnnamedContainerProvider,
IPlayerPacketReceiver {
    final LazyOptional<IEnergyStorage> handler = LazyOptional.of(() -> this);
    final CachedCap<IEnergyStorage>[] receivers = new CachedCap[6];
    public int flowI;
    public int flowO;
    @Sync(to=-2147483648)
    public int lastI;
    @Sync(to=-2147483648)
    public int lastO;
    @Sync(to=-2147483647)
    public int limI;
    @Sync(to=-2147483647)
    public int limO;
    @Sync(to=-2147483647)
    public long sumI;
    @Sync(to=-2147483647)
    public long sumO;
    @Sync(to=1)
    public long t0;
    boolean updateCaps;

    @Sync(to=-2147483648)
    public long t() {
        return this.field_145850_b.func_82737_E() - this.t0 - 1L;
    }

    public EnergySupply(TileEntityType<EnergySupply> type) {
        super(type);
    }

    public void func_73660_a() {
        this.lastI = this.flowI;
        this.lastO = this.flowO;
        this.flowI = 0;
        this.flowO = 0;
        if (this.limO <= 0) {
            return;
        }
        if (this.updateCaps) {
            for (CachedCap<IEnergyStorage> cc : this.receivers) {
                cc.update();
            }
            this.updateCaps = false;
        }
        for (CachedCap<IEnergyStorage> cc : this.receivers) {
            this.extractEnergy(cc.get().receiveEnergy(this.limO, false), false);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    @Override
    public void onNeighborTEChange(BlockPos from) {
        this.updateCaps = true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        for (Direction d : Direction.values()) {
            this.receivers[d.ordinal()] = new CachedCap<NullEnergyStorage>(this.field_145850_b, this.field_174879_c.func_177967_a(d, -1), d, CapabilityEnergy.ENERGY, NullEnergyStorage.INSTANCE);
        }
        this.updateCaps = true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive > this.limI) {
            maxReceive = this.limI;
        }
        if (!simulate) {
            this.flowI += maxReceive;
            this.sumI += (long)maxReceive;
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.limO) {
            maxExtract = this.limO;
        }
        if (!simulate) {
            this.flowO += maxExtract;
            this.sumO += (long)maxExtract;
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        return this.limO;
    }

    public int getMaxEnergyStored() {
        int n = this.limI + this.limO;
        return n < 0 ? Integer.MAX_VALUE : n;
    }

    public boolean canExtract() {
        return this.limO > 0;
    }

    public boolean canReceive() {
        return this.limI > 0;
    }

    public ContainerEnergySupply createMenu(int windowId, PlayerInventory playerInv, PlayerEntity player) {
        return new ContainerEnergySupply(windowId, playerInv, this);
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.limI = pkt.readInt();
                if (this.limI >= 0) break;
                this.limI = 0;
                break;
            }
            case 1: {
                this.limO = pkt.readInt();
                if (this.limO >= 0) break;
                this.limO = 0;
                break;
            }
            case 2: {
                this.sumI = 0L;
                this.sumO = 0L;
                this.t0 = this.field_145850_b.func_82737_E();
                break;
            }
            default: {
                return;
            }
        }
        this.saveDirty();
    }
}

