/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.tileentity;

import cd4017be.lib.capability.IMultiFluidHandler;
import cd4017be.lib.container.ContainerFluidSupply;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidSupply
extends BaseTileEntity
implements IMultiFluidHandler,
IUnnamedContainerProvider,
IPlayerPacketReceiver {
    public static int MAX_SLOTS = 12;
    final LazyOptional<IFluidHandler> handler = LazyOptional.of(() -> this);
    public final ArrayList<Slot> slots = new ArrayList();
    @Sync(to=-2147483648)
    public int scroll;

    public FluidSupply(TileEntityType<FluidSupply> type) {
        super(type);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getTanks() {
        return MAX_SLOTS;
    }

    public FluidStack getFluidInTank(int tank) {
        return tank < this.slots.size() ? this.slots.get((int)tank).stack : FluidStack.EMPTY;
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        if (tank < this.slots.size()) {
            if (stack.isEmpty()) {
                this.slots.remove(tank);
            } else {
                this.slots.get((int)tank).stack = stack;
            }
        } else if (!stack.isEmpty()) {
            this.slots.add(new Slot(stack));
        }
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    @Override
    public boolean shouldFill(int tank) {
        return true;
    }

    @Override
    public boolean shouldDrain(int tank) {
        return true;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int n = resource.getAmount();
        for (Slot s : this.slots) {
            if (!resource.isFluidEqual(s.stack)) continue;
            if (action.execute()) {
                s.countIn += n;
            }
            return n;
        }
        if (this.slots.size() >= MAX_SLOTS) {
            return 0;
        }
        if (action.execute()) {
            Slot s = new Slot(new FluidStack(resource, 1000));
            s.countIn = n;
            this.slots.add(s);
        }
        return n;
    }

    @Override
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int n = resource.getAmount();
        for (Slot s : this.slots) {
            if (!resource.isFluidEqual(s.stack)) continue;
            n = Math.min(n, s.stack.getAmount());
            if (action.execute()) {
                s.countOut += n;
            }
            return new FluidStack(s.stack, n);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.slots.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Slot s = this.slots.get(0);
        int n = Math.min(maxDrain, s.stack.getAmount());
        if (action.execute()) {
            s.countOut += n;
        }
        return new FluidStack(s.stack, n);
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        ListNBT list = new ListNBT();
        for (Slot s : this.slots) {
            CompoundNBT tag = s.stack.writeToNBT(new CompoundNBT());
            tag.func_74768_a("in", s.countIn);
            tag.func_74768_a("out", s.countOut);
            list.add((Object)tag);
        }
        nbt.func_218657_a("slots", (INBT)list);
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        this.slots.clear();
        for (INBT tb : nbt.func_150295_c("slots", 10)) {
            CompoundNBT tag = (CompoundNBT)tb;
            Slot s = new Slot(FluidStack.loadFluidStackFromNBT((CompoundNBT)tag));
            s.countIn = tag.func_74762_e("in");
            s.countOut = tag.func_74762_e("out");
            this.slots.add(s);
        }
    }

    public ContainerFluidSupply createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerFluidSupply(id, inv, this);
    }

    @Override
    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        int cmd = pkt.readByte();
        if (cmd < 0) {
            this.scroll = pkt.readUnsignedByte();
            return;
        }
        boolean zero = cmd < 16;
        if ((cmd = (cmd & 0xF) + this.scroll) >= this.slots.size()) {
            return;
        }
        Slot s = this.slots.get(cmd);
        if (zero) {
            s.countIn = 0;
            s.countOut = 0;
        } else if (s.countIn < s.countOut) {
            s.countOut -= s.countIn;
            s.countIn = 0;
        } else {
            s.countIn -= s.countOut;
            s.countOut = 0;
        }
    }

    public static class Slot
    implements Supplier<Object[]> {
        public FluidStack stack;
        public int countOut;
        public int countIn;

        public Slot(FluidStack stack) {
            this.stack = stack;
        }

        @Override
        public Object[] get() {
            return new Object[]{this.countIn, this.countOut};
        }
    }
}

